/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.nanotec;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class NanotecPD4N
extends Ascii {
    private final int ADDR_DEFAULT = 1;
    private final int BAUD_DEFAULT = 115000;
    private final int TIMEOUT = 1000;
    private int driveAddr = 1;
    private boolean useCRC = false;
    private boolean debug = false;
    private int lastErrorLocation;
    private static final String Lbl = "NanotecPD4N:  ";

    public NanotecPD4N() {
        super(Ascii.Option.NO_NET);
    }

    @Override
    public synchronized void open(DriverConstants.ConnType connType, String ident, int baudRate, int commParm) throws DriverException {
        super.open(connType, ident, baudRate == 0 ? 115000 : baudRate, 0);
        this.setTimeout(1000);
        this.setTerminator(Ascii.Terminator.CR);
        this.setChecksumUsage(true);
        try {
            this.writePrivate(CmndPrivate.MOTOR_TYPE, 0);
            this.writePrivate(CmndPrivate.DRIVE_ADDRESS, 1);
            this.writePrivate(CmndPrivate.DIGITAL_INPUT1, 7);
            this.writePrivate(CmndPrivate.DIGITAL_INPUT2, 7);
            this.writePrivate(CmndPrivate.AUTOMATE_STATUS, 0);
            this.writePrivate(CmndPrivate.CLOSED_LOOP, 0);
            this.lastErrorLocation = this.getErrorMemoryLocation();
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void open(String serialName) throws DriverException {
        this.openSerial(serialName, 115000);
    }

    public void open(String serialName, int baudRate) throws DriverException {
        DataRate dataRate = DataRate.valueOf("BAUD_" + Integer.toString(baudRate));
        this.openSerial(serialName, baudRate);
    }

    public void writeGeneral(CmndGeneral cmnd, int value) throws DriverException {
        if (!cmnd.writeAllowed) {
            throw new DriverException("NanotecPD4N:  Write not allowed for " + cmnd.toString());
        }
        if (value < cmnd.minValue || value > cmnd.maxValue) {
            throw new DriverException("NanotecPD4N:  Value outside of allowed range " + String.valueOf(cmnd.minValue) + " to " + String.valueOf(cmnd.maxValue) + " for " + cmnd.toString());
        }
        String cmndText = "Write " + cmnd.toString();
        String cmndBody = String.valueOf(this.driveAddr) + cmnd.symbol;
        cmndBody = !cmnd.longFormat ? cmndBody + String.valueOf(value) : cmndBody + "=" + String.valueOf(value);
        this.responseToCommand(cmndBody, cmndText);
    }

    private void writePrivate(CmndPrivate cmnd, int value) throws DriverException {
        if (!cmnd.writeAllowed) {
            throw new DriverException("NanotecPD4N:  Write not allowed for " + cmnd.toString());
        }
        if (value < cmnd.minValue || value > cmnd.maxValue) {
            throw new DriverException("NanotecPD4N:  Value outside of allowed range " + String.valueOf(cmnd.minValue) + " to " + String.valueOf(cmnd.maxValue) + " for " + cmnd.toString());
        }
        String cmndText = "Write " + cmnd.toString();
        String cmndBody = String.valueOf(this.driveAddr) + cmnd.symbol;
        cmndBody = !cmnd.longFormat ? cmndBody + String.valueOf(value) : cmndBody + "=" + String.valueOf(value);
        this.responseToCommand(cmndBody, cmndText);
    }

    private void writePrivate(CmndPrivate cmnd) throws DriverException {
        if (!cmnd.writeAllowed) {
            throw new DriverException("NanotecPD4N:  Write not allowed for " + cmnd.toString());
        }
        String cmndText = "Write " + cmnd.toString();
        String cmndBody = String.valueOf(this.driveAddr) + cmnd.symbol;
        this.responseToCommand(cmndBody, cmndText);
    }

    public void writeMotion(CmndMotion cmnd, int value) throws DriverException {
        if (!this.isMotorReady()) {
            throw new DriverException("NanotecPD4N:  motion parameters cannot be changed while motor not ready");
        }
        if (value < cmnd.minValue || value > cmnd.maxValue) {
            throw new DriverException("NanotecPD4N:  Value outside of allowed range " + String.valueOf(cmnd.minValue) + " to " + String.valueOf(cmnd.maxValue) + " for " + cmnd.toString());
        }
        String cmndText = "Write " + cmnd.toString();
        String cmndBody = String.valueOf(this.driveAddr) + cmnd.symbol;
        cmndBody = !cmnd.longFormat ? cmndBody + String.valueOf(value) : cmndBody + "=" + String.valueOf(value);
        this.responseToCommand(cmndBody, cmndText);
    }

    public String readGeneral(CmndGeneral cmnd) throws DriverException {
        String cmndText = "Read " + cmnd.toString();
        String cmndBody = String.valueOf(this.driveAddr);
        if (!cmnd.longFormat) {
            if (cmnd.writeAllowed) {
                cmndBody = cmndBody + "Z";
            }
            cmndBody = cmndBody + cmnd.symbol;
        } else {
            cmndBody = cmndBody + cmnd.symbol;
        }
        String response = this.responseToCommand(cmndBody, cmndText);
        return response.substring(cmndBody.length());
    }

    private String readPrivate(CmndPrivate cmnd) throws DriverException {
        String cmndText = "Read " + cmnd.toString();
        String cmndBody = String.valueOf(this.driveAddr);
        if (!cmnd.longFormat) {
            if (cmnd.writeAllowed) {
                cmndBody = cmndBody + "Z";
            }
            cmndBody = cmndBody + cmnd.symbol;
        } else {
            cmndBody = cmndBody + cmnd.symbol;
        }
        String response = this.responseToCommand(cmndBody, cmndText);
        return response.substring(cmndBody.length());
    }

    public String readMotion(CmndMotion cmnd) throws DriverException {
        String cmndText = "Read " + cmnd.toString();
        String cmndBody = String.valueOf(this.driveAddr);
        if (!cmnd.longFormat) {
            cmndBody = cmndBody + "Z";
            cmndBody = cmndBody + cmnd.symbol;
        } else {
            cmndBody = cmndBody + cmnd.symbol;
        }
        String response = this.responseToCommand(cmndBody, cmndText);
        return response.substring(cmndBody.length());
    }

    private String responseToCommand(String cmndBody, String cmndText) throws DriverException {
        boolean foundCrc;
        String cmndSend = "#" + cmndBody;
        if (this.useCRC) {
            cmndSend = cmndSend + String.format("\t%02X", this.computeCRC(cmndSend));
        }
        String response = this.read(cmndSend);
        if (this.debug) {
            System.out.println("Command sent = " + cmndSend + ", response = " + response);
        }
        if (response.indexOf("?crc") > -1) {
            throw new DriverException("NanotecPD4N:  controller reports checksum error");
        }
        if (response.indexOf("?") > -1) {
            String cmndSym = cmndBody.substring(1);
            throw new DriverException("NanotecPD4N:  invalid command " + cmndSym + " (" + cmndText + ")");
        }
        int indexTab = response.indexOf("\t");
        boolean bl = foundCrc = indexTab > -1;
        if (this.useCRC != foundCrc) {
            throw new DriverException(Lbl + String.format("checksum expected = %b, found = %b", this.useCRC, foundCrc));
        }
        if (foundCrc) {
            String expect;
            String crcStr = response.substring(indexTab + 1);
            if (!crcStr.equals(expect = String.format("%02X", this.computeCRC(response.substring(0, indexTab))))) {
                throw new DriverException("NanotecPD4N:  checksum = " + crcStr + ", expected = " + expect);
            }
            return response.substring(0, indexTab);
        }
        return response;
    }

    private byte computeCRC(String input) {
        int polyCRC = 7;
        byte[] inArray = input.getBytes();
        int nbyte = inArray.length;
        byte crc = 0;
        for (int ibyte = 0; ibyte < nbyte; ++ibyte) {
            for (int i = 0; i < 8; ++i) {
                crc = (crc & 0x80) != (inArray[ibyte] & 0x80) ? (byte)(crc << 1 ^ 7) : (byte)(crc << 1);
                int n = ibyte;
                inArray[n] = (byte)(inArray[n] << 1);
            }
        }
        return crc;
    }

    public int readStatus() throws DriverException {
        String resp = this.readGeneral(CmndGeneral.READ_STATUS);
        int idx = resp.indexOf(CmndGeneral.READ_STATUS.symbol);
        String statusStr = resp.substring(idx + 1);
        return Integer.parseInt(statusStr);
    }

    public boolean isMotorReady() throws DriverException {
        int status = this.readStatus();
        return (status & 1) != 0;
    }

    public boolean isPositionError() throws DriverException {
        int status = this.readStatus();
        return (status & 4) != 0;
    }

    public int getLimitSwitches() throws DriverException {
        int outputs = Integer.parseInt(this.readPrivate(CmndPrivate.OUTPUT_LINES));
        return outputs & 3;
    }

    private int getErrorMemoryLocation() throws DriverException {
        String errMem = this.readGeneral(CmndGeneral.READ_ERROR_MEMORY);
        int errorRecord = Integer.parseInt(errMem);
        if (errorRecord < 1 || errorRecord > 32) {
            throw new DriverException("NanotecPD4N:  Error record number " + errMem + " is out of range 1 to 32");
        }
        return errorRecord;
    }

    public boolean getErrorFlag() throws DriverException {
        return !this.getErrorType().equals("NONE");
    }

    public String getErrorType() throws DriverException {
        String errorType = "";
        int currentErrorLocation = this.getErrorMemoryLocation();
        if (currentErrorLocation != this.lastErrorLocation || this.debug) {
            if (this.debug && currentErrorLocation == this.lastErrorLocation) {
                System.out.println("Debug mode: read although not new");
            }
            this.lastErrorLocation = currentErrorLocation;
            String cmndBody = String.valueOf(this.driveAddr) + "Z" + String.valueOf(currentErrorLocation) + "E";
            String cmndText = "Read error-memory record " + String.valueOf(currentErrorLocation);
            String response = this.responseToCommand(cmndBody, cmndText);
            int errorCode = Integer.parseInt(response.substring(cmndBody.length()));
            errorType = MotorErrors.decode(errorCode);
        }
        return !errorType.equals("") ? errorType : "NONE";
    }

    public void resetError() throws DriverException {
        this.writePrivate(CmndPrivate.RESET_ERROR);
    }

    public double readTemperature() throws DriverException {
        String resp = this.readGeneral(CmndGeneral.TEMPERATURE);
        double adc = Integer.parseInt(resp);
        double frac = adc / 1023.0;
        double temperature = 1266500.0 / (4250.0 + Math.log10(0.33 * frac / (1.0 - frac)) * 298.0) - 273.0;
        return temperature;
    }

    public void setLimitSwitchBehavior(boolean value) throws DriverException {
        int bitcode = (value ? LimitSwitchBehavior.TRAVEL_BACKWARD : LimitSwitchBehavior.STOP).bitCode;
        int setting = Integer.parseInt(this.readGeneral(CmndGeneral.SWITCH_BEHAVIOR));
        int newSetting = setting & 0x7FF | bitcode;
        this.writeGeneral(CmndGeneral.SWITCH_BEHAVIOR, newSetting);
    }

    public void startMotor() throws DriverException {
        if (!this.isMotorReady()) {
            throw new DriverException("NanotecPD4N:  startMotor invoked while motor not ready");
        }
        this.lastErrorLocation = this.getErrorMemoryLocation();
        this.readPrivate(CmndPrivate.START_MOTOR);
    }

    public void stopMotor(int ramp) throws DriverException {
        this.writePrivate(CmndPrivate.STOP_MOTOR, ramp);
    }

    public void loadRecord(int record) throws DriverException {
        this.writePrivate(CmndPrivate.LOAD_RECORD, record);
    }

    public void saveRecord(int record) throws DriverException {
        this.writePrivate(CmndPrivate.SAVE_RECORD, record);
    }

    public boolean readChecksumUsage() {
        return this.useCRC;
    }

    void setChecksumUsage(boolean value) throws DriverException {
        try {
            this.writePrivate(CmndPrivate.USE_CHECKSUM, value ? 1 : 0);
            this.useCRC = value;
        }
        catch (DriverException e) {
            this.useCRC = !this.useCRC;
            try {
                this.writePrivate(CmndPrivate.USE_CHECKSUM, value ? 1 : 0);
                this.useCRC = value;
            }
            catch (DriverException ex) {
                this.useCRC = !this.useCRC;
                throw ex;
            }
        }
    }

    void setDebug(boolean value) {
        this.debug = value;
    }

    static enum LimitSwitchBehavior {
        TRAVEL_FORWARD(2048),
        TRAVEL_BACKWARD(4096),
        STOP(8192),
        IGNORE(16384);

        private static final int otherBits = 2047;
        private int bitCode;

        private LimitSwitchBehavior(int bitCode) {
            this.bitCode = bitCode;
        }

        public static String decode(int bitPattern) throws DriverException {
            int bits = bitPattern & 0x7800;
            LimitSwitchBehavior[] behavior = LimitSwitchBehavior.values();
            int found = -1;
            for (int i = 0; i < behavior.length; ++i) {
                if (bits != behavior[i].bitCode) continue;
                found = i;
                break;
            }
            if (found == -1) {
                throw new DriverException("NanotecPD4N:  invalid code for limit-switch behavior");
            }
            return behavior[found].toString();
        }
    }

    static enum DataRate {
        BAUD_110(1),
        BAUD_300(2),
        BAUD_600(3),
        BAUD_1200(4),
        BAUD_2400(5),
        BAUD_4800(6),
        BAUD_9600(7),
        BAUD_14400(8),
        BAUD_19200(9),
        BAUD_38400(10),
        BAUD_5760000(11),
        BAUD_115200(12);

        private int rateCode;

        private DataRate(int rateCode) {
            this.rateCode = rateCode;
        }

        int getCode() {
            return this.rateCode;
        }
    }

    public static enum MotorErrors {
        LOWVOLTAGE(1, "under voltage"),
        TEMPERATURE(2, "controller temperature out of range"),
        OVERCURRENT(4, "overcurrent triggered switch-off"),
        EEPROM(8, "incorrect data in EEPROM"),
        POSITION(16, "position error"),
        INTERNAL(32, "internal error"),
        UNASSIGNED(64, "unassigned bit"),
        COMPONENT(128, "component returned one error");

        private int mask;
        private String descr;

        private MotorErrors(int mask, String descr) {
            this.mask = mask;
            this.descr = descr;
        }

        public static String decode(int errorCode) {
            String meaning = "";
            MotorErrors[] motorErr = MotorErrors.values();
            int nErrors = motorErr.length;
            for (int i = 0; i < nErrors; ++i) {
                if ((errorCode & motorErr[i].mask) == 0) continue;
                meaning = meaning + motorErr[i].toString() + " ";
            }
            return meaning;
        }
    }

    public static enum CmndMotion {
        MODE("p", 1, 4, ""),
        DISTANCE("s", -100000000, 100000000, "steps"),
        FREQUENCY_MIN("u", 1, 160000, "steps/s"),
        FREQUENCY_MAX("o", 1, 1000000, "steps/s"),
        FREQ2_MAX("n", 1, 1000000, "steps/s"),
        RAMP_ACCEL(":accel", 1, 3000000, "Hz/s"),
        RAMP_BRAKE(":decel", 0, 3000000, "Hz/s"),
        ROTATION_DIRECTION("d", 0, 1, ""),
        DIR_CHANGE_FOR_REP("t", 0, 1, ""),
        REPETITIONS("W", 0, 254, ""),
        PAUSE_BETW_RECORDS("P", 0, 65535, "ms"),
        CONTINUATION_RECNUM("N", 0, 32, ""),
        JERK_MAX_ACCEL(":b", 1, 100000000, "100/s^3"),
        JERK_MAX_BRAKE(":B", 0, 100000000, "100/s^3");

        private String symbol;
        private int minValue;
        private int maxValue;
        private String units;
        private boolean longFormat;

        private CmndMotion(String symbol, int minValue, int maxValue, String units) {
            this.symbol = symbol;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.units = units;
            this.longFormat = symbol.startsWith(":");
        }

        public String getUnits() {
            return this.units;
        }
    }

    private static enum CmndPrivate {
        MOTOR_TYPE(":CL_motor_type", true, 0, 2),
        DRIVE_ADDRESS("m", true, 1, 254),
        DIGITAL_INPUT1(":port_in_a", true, 0, 13),
        DIGITAL_INPUT2(":port_in_b", true, 0, 13),
        AUTOMATE_STATUS("J", true, 0, 1),
        CLOSED_LOOP(":CL_enable", true, 0, 3),
        USE_CHECKSUM(":crc", true, 0, 1),
        RESET_ERROR("D", true, -100000000, 100000000),
        OUTPUT_LINES("Y", false, 0, 0),
        START_MOTOR("A", false, 0, 0),
        STOP_MOTOR("S", true, 0, 1),
        LOAD_RECORD("y", true, 1, 32),
        SAVE_RECORD(">", true, 1, 32);

        private String symbol;
        private boolean writeAllowed;
        private int minValue;
        private int maxValue;
        private boolean longFormat;

        private CmndPrivate(String symbol, boolean writeAllowed, int minValue, int maxValue) {
            this.symbol = symbol;
            this.writeAllowed = writeAllowed;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.longFormat = symbol.startsWith(":");
        }
    }

    public static enum CmndGeneral {
        PHASE_CURRENT("i", true, 0, 150, "percent"),
        PHASE_CURRENT_STILL("r", true, 0, 150, "percent"),
        STEP_MODE("g", true, 1, 255, ""),
        SWITCH_BEHAVIOR("l", true, 2565, 17442, "(bitcode)"),
        ERRCORR_MODE("U", true, 0, 1, "(0/1 for off/on)"),
        ERRCORR_RECNUM("F", true, 0, 32, ""),
        ENCODER_DIR("q", true, 0, 1, ""),
        ENCODER_SETTLE_TIME("O", true, 0, 250, "10 ms"),
        ENCODER_MAXDEV("X", true, 0, 250, "steps"),
        READ_ERROR_MEMORY("E", false, 0, 32, ""),
        READ_ENCODER("I", false, 0, 0, ""),
        READ_STATUS("$", false, 0, 0, "(bitcode)"),
        FIRMWARE_VERSION("v", false, 0, 0, ""),
        REVERSE_POLARITIES("h", true, 0, 524287, "(bitcode)"),
        INPUT_DEBOUNCE_TIME("K", true, 0, 250, "ms"),
        REVERSE_CLEARANCE("z", true, 0, 9999, "steps"),
        OPERATING_TIME(":optime", false, 0, 0, ""),
        RAMP_TYPE(":ramp_mode", true, 0, 2, ""),
        BAUD_RATE(":baud", true, 1, 12, ""),
        TEMPERATURE(":temp_adc", false, 0, 0, ""),
        QUICKSTOP_RAMP(":decelquick", true, 0, 3000000, "Hz/s");

        private String symbol;
        private boolean writeAllowed;
        private int minValue;
        private int maxValue;
        private String units;
        private boolean longFormat;

        private CmndGeneral(String symbol, boolean writeAllowed, int minValue, int maxValue, String units) {
            this.symbol = symbol;
            this.writeAllowed = writeAllowed;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.units = units;
            this.longFormat = symbol.startsWith(":");
        }

        public String getUnits() {
            return this.units;
        }
    }
}

