/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.dataforth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.drivers.dataforth.Maq20Analog;
import org.lsst.ccs.drivers.dataforth.Maq20AnalogIn;
import org.lsst.ccs.drivers.dataforth.Maq20AnalogOut;
import org.lsst.ccs.drivers.dataforth.Maq20Discrete;
import org.lsst.ccs.drivers.dataforth.Maq20DiscreteFreq;
import org.lsst.ccs.drivers.dataforth.Maq20DiscreteIn;
import org.lsst.ccs.drivers.dataforth.Maq20DiscreteOut;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePWM;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePulse;
import org.lsst.ccs.drivers.modbus.Modbus;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class Maq20Device
extends Device {
    public static final int NUM_CHAN_TC = 8;
    public static final int NUM_CHAN_RTD = 6;
    public static final int NUM_CHAN_IVS = 16;
    public static final int NUM_CHAN_IVD = 8;
    public static final int NUM_CHAN_IVO = 8;
    public static final int NUM_CHAN_DIOL = 5;
    public static final int NUM_CHAN_DIOH = 4;
    public static final int NUM_CHAN_PULSE = 3;
    public static final int NUM_CHAN_PWM = 3;
    public static final int NUM_CHAN_FREQ = 1;
    public static final int NUM_CHAN_DINP = 20;
    public static final int NUM_CHAN_DOUT = 20;
    public static final int CHAN_FREQUENCY = 0;
    public static final int CHAN_PULSE_COUNT = 1;
    public static final int CHAN_PULSE_RPM = 2;
    public static final int CHAN_PWM_PERIOD = 0;
    public static final int CHAN_PWM_LOW1 = 1;
    public static final int CHAN_PWM_LOW2 = 2;
    public static final int DISC_FUNC_NONE = -1;
    public static final int DISC_FUNC_PULSE = 0;
    public static final int DISC_FUNC_PWM = 1;
    public static final int DISC_FUNC_FREQ = 2;
    private static final int CHAN_TYPE_ANAL_IN = 0;
    private static final int CHAN_TYPE_ANAL_OUT = 1;
    private static final int CHAN_TYPE_DISC_IN = 2;
    private static final int CHAN_TYPE_DISC_OUT = 3;
    private static final int CHAN_TYPE_DISC_PULSE = 4;
    private static final int CHAN_TYPE_DISC_PWM = 5;
    private static final int CHAN_TYPE_DISC_FREQ = 6;
    private static final Map<String, Integer> discFuncMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> dummyRangeMap;
    private static final Map<String, Integer> ttcRangeMap;
    private static final Map<String, Integer> jtcRangeMap;
    private static final Map<String, Integer> ktcRangeMap;
    private static final Map<String, Integer> rstcRangeMap;
    private static final Map<String, Integer> rtdRangeMap;
    private static final Map<String, Integer> voltRangeMap;
    private static final Map<String, Integer> mvoltRangeMap;
    private static final Map<String, Integer> ampRangeMap;
    private static final Map<String, Integer> voutRangeMap;
    private static final Map<String, ModuleDef> typeMap;
    private static final List<Maq20.ModuleType> typeList;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final Map<String, Maq20Control> controlMap = new HashMap<String, Maq20Control>();
    @ConfigurationParameter(category="Device", isFinal=true)
    protected volatile String node;
    @ConfigurationParameter(category="Device", maxLength=24, isFinal=true)
    protected volatile String[] serials;
    protected String[] modules;
    private static final Logger LOG;
    protected final Maq20 maq = new Maq20();
    private ModuleData[] modData;

    protected void initDevice() {
        if (this.node == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "node", "is missing");
        }
        if (this.modules == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "modules", "is missing");
        }
        if (this.serials == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "serials", "is missing");
        }
        if (this.modules.length != this.serials.length) {
            ErrorUtils.reportConfigError(LOG, this.name, "modules and serials", "have different lengths");
        }
        this.modData = new ModuleData[this.modules.length];
        for (int j = 0; j < this.modules.length; ++j) {
            ModuleDef mDef;
            ModuleData mData = null;
            String[] words = this.modules[j].split(":");
            if (words.length >= 1 && words.length <= 3 && (mDef = typeMap.get(words[0].toUpperCase())) != null) {
                mData = new ModuleData();
                mData.serial = this.serials[j];
                mData.modDef = mDef;
                if (mDef.opType == 2) {
                    mData.discFunc[0] = -1;
                    mData.discFunc[1] = -1;
                    for (int k = 0; k < words.length - 1; ++k) {
                        Integer func = discFuncMap.get(words[k + 1].trim().toUpperCase());
                        if (func == null) {
                            mData = null;
                            break;
                        }
                        mData.discFunc[k] = func;
                    }
                } else if (words.length != 1) {
                    mData = null;
                }
            }
            if (mData == null) {
                ErrorUtils.reportConfigError(LOG, this.name, "modules", "has invalid item (" + this.modules[j] + ")");
            }
            this.modData[j] = mData;
        }
        this.fullName = "Maq20 system (" + this.node + ")";
    }

    protected void initialize() {
        try {
            this.maq.open(Modbus.ConnType.NET, this.node);
            block9: for (ModuleData mData : this.modData) {
                if (mData == null) continue;
                mData.modId = this.maq.getModuleId(mData.serial);
                if (mData.modId <= 0) {
                    LOG.log(Level.SEVERE, "Module with serial number {0} not found", mData.serial);
                    continue;
                }
                Maq20.ModuleType type = this.maq.getModuleType(mData.modId);
                if (type != mData.modDef.type) {
                    LOG.log(Level.SEVERE, "Module with serial number {0} has the wrong type ({1})", new Object[]{mData.serial, type});
                    mData.modId = -1;
                    continue;
                }
                switch (mData.modDef.opType) {
                    case 0: {
                        mData.maqAnaIn = this.maq.getAnalIn(mData.modId);
                        mData.maqAna = mData.maqAnaIn;
                        continue block9;
                    }
                    case 1: {
                        mData.maqAnaOut = this.maq.getAnalOut(mData.modId);
                        mData.maqAna = mData.maqAnaOut;
                        continue block9;
                    }
                    case 2: {
                        mData.maqDisc = this.maq.getDiscrete(mData.modId);
                        mData.maqDiscPulse = this.maq.getDiscPulse(mData.modId);
                        mData.maqDiscPWM = this.maq.getDiscPWM(mData.modId);
                        mData.maqDiscFreq = this.maq.getDiscFreq(mData.modId);
                        continue block9;
                    }
                    case 3: {
                        mData.maqDisc = this.maq.getDiscIn(mData.modId);
                        mData.maqDiscIn = this.maq.getDiscIn(mData.modId);
                        continue block9;
                    }
                    case 4: {
                        mData.maqDisc = this.maq.getDiscOut(mData.modId);
                        mData.maqDiscIn = this.maq.getDiscOut(mData.modId);
                        mData.maqDiscOut = this.maq.getDiscOut(mData.modId);
                    }
                }
            }
            for (Maq20Control ctrl : this.controlMap.values()) {
                ctrl.initialize();
            }
            this.setOnline(true);
            this.initSensors();
            this.setOutputLines();
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        for (Maq20Control ctrl : this.controlMap.values()) {
            ctrl.close();
        }
        try {
            this.maq.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
        for (ModuleData mData : this.modData) {
            if (mData == null) continue;
            mData.maqAna = null;
            mData.maqAnaIn = null;
            mData.maqAnaOut = null;
            mData.maqDisc = null;
            mData.maqDiscFreq = null;
            mData.maqDiscPWM = null;
            mData.maqDiscPulse = null;
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        int modIx = 0;
        int chanType = -1;
        int funcIx = 0;
        Integer iRange = 0;
        ModuleData mData = null;
        try {
            modIx = Integer.decode(type);
            if (modIx >= 0 && modIx < this.modData.length) {
                mData = this.modData[modIx];
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (mData != null) {
            boolean subtypeOK = true;
            int numChan = mData.modDef.numChan;
            if (mData.modDef.opType == 2) {
                if (subtype.isEmpty()) {
                    chanType = 2;
                } else if (subtype.toUpperCase().equals("OUT")) {
                    chanType = 3;
                } else {
                    int n = subtype.equals("0") ? 0 : (funcIx = subtype.equals("1") ? 1 : -1);
                    if (funcIx >= 0) {
                        int discFunc = mData.discFunc[funcIx];
                        if (discFunc == 0) {
                            chanType = 4;
                            numChan = 3;
                        } else if (discFunc == 1) {
                            chanType = 5;
                            numChan = 3;
                        } else if (discFunc == 2) {
                            chanType = 6;
                            numChan = 1;
                        }
                    } else {
                        subtypeOK = false;
                    }
                }
            } else if (mData.modDef.opType == 0) {
                if (subtype == null || subtype.isEmpty()) {
                    LOG.log(Level.INFO, "No subtype (range) specified for {0}: using default", name);
                } else {
                    Map rMap = mData.modDef.rangeMap;
                    iRange = (Integer)rMap.get(subtype.toUpperCase());
                    subtypeOK = iRange != null;
                }
                chanType = 0;
            } else {
                chanType = 1;
            }
            if (!subtypeOK) {
                ErrorUtils.reportChannelError(LOG, name, "subtype (range)", subtype);
            }
            if (hwChan < 0 || hwChan >= numChan) {
                ErrorUtils.reportChannelError(LOG, name, "hwChan", hwChan);
            }
        }
        if (chanType < 0) {
            ErrorUtils.reportChannelError(LOG, name, "type (index)", type);
        }
        return new int[]{funcIx << 16 | chanType << 8 | modIx, iRange};
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        if (!this.online) {
            return;
        }
        int modIx = type & 0xFF;
        int chanType = type >> 8;
        int range = subtype;
        ModuleData mData = this.modData[modIx];
        try {
            if (mData.modId <= 0) {
                LOG.log(Level.SEVERE, "Channel {0} initialization error: module failed initialization", name);
                this.dropChannel(id);
            } else if (chanType == 0) {
                mData.maqAnaIn.enable(hwChan, true);
                mData.maqAnaIn.setRange(hwChan, range);
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error initializing {0} channel: {1}", new Object[]{name, e});
            this.setOnline(false);
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.online) {
            ModuleData mData = this.modData[type & 0xFF];
            int funcNum = type >> 16;
            try {
                block1 : switch (type >> 8 & 0xFF) {
                    case 0: 
                    case 1: {
                        value = mData.maqAna.readValue(hwChan);
                        break;
                    }
                    case 2: {
                        value = mData.maqDisc.readDiscIn(hwChan);
                        break;
                    }
                    case 3: {
                        value = mData.maqDisc.readDiscOut(hwChan);
                        break;
                    }
                    case 4: {
                        switch (hwChan) {
                            case 0: {
                                value = mData.maqDiscPulse.readFrequency(funcNum);
                                break block1;
                            }
                            case 1: {
                                value = mData.maqDiscPulse.readPulseCount(funcNum);
                                break block1;
                            }
                            case 2: {
                                value = 60.0 * (double)mData.maqDiscPulse.readFrequency(funcNum) / (double)mData.maqDiscPulse.getPulsesPerRevn(funcNum);
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (hwChan) {
                            case 0: {
                                value = mData.maqDiscPWM.getPeriod(funcNum);
                                break block1;
                            }
                            case 1: {
                                value = mData.maqDiscPWM.getLowTime1(funcNum);
                                break block1;
                            }
                            case 2: {
                                value = mData.maqDiscPWM.getLowTime2(funcNum);
                            }
                        }
                        break;
                    }
                    case 6: {
                        value = mData.maqDiscFreq.getFrequency(funcNum);
                    }
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading {0} channel: {1}", new Object[]{this.name, e});
                this.setOnline(false);
            }
        }
        return value;
    }

    public int getModuleCount() {
        return this.modData.length;
    }

    public ModuleData getModuleData(int index) {
        return index >= 0 && index < this.modData.length ? this.modData[index] : null;
    }

    static {
        discFuncMap.put("", -1);
        discFuncMap.put("PULSE", 0);
        discFuncMap.put("PWM", 1);
        discFuncMap.put("FREQ", 2);
        dummyRangeMap = new HashMap<String, Integer>();
        ttcRangeMap = new HashMap<String, Integer>();
        ttcRangeMap.put("T400", 0);
        ttcRangeMap.put("T220", 1);
        jtcRangeMap = new HashMap<String, Integer>();
        jtcRangeMap.put("J760", 0);
        jtcRangeMap.put("J393", 1);
        jtcRangeMap.put("J199", 2);
        ktcRangeMap = new HashMap<String, Integer>();
        ktcRangeMap.put("K1350", 0);
        ktcRangeMap.put("K651", 1);
        ktcRangeMap.put("K332", 2);
        rstcRangeMap = new HashMap<String, Integer>();
        rstcRangeMap.put("R1750", 0);
        rstcRangeMap.put("R990", 1);
        rstcRangeMap.put("S1750", 2);
        rstcRangeMap.put("S970", 3);
        rtdRangeMap = new HashMap<String, Integer>();
        rtdRangeMap.put("R850", 0);
        rtdRangeMap.put("R200", 1);
        rtdRangeMap.put("R100", 2);
        voltRangeMap = new HashMap<String, Integer>();
        voltRangeMap.put("V60", 0);
        voltRangeMap.put("V40", 1);
        voltRangeMap.put("V20", 2);
        voltRangeMap.put("V10", 3);
        voltRangeMap.put("V5", 4);
        mvoltRangeMap = new HashMap<String, Integer>();
        mvoltRangeMap.put("V2", 0);
        mvoltRangeMap.put("V1", 1);
        mvoltRangeMap.put("MV250", 2);
        mvoltRangeMap.put("MV100", 3);
        mvoltRangeMap.put("MV50", 4);
        ampRangeMap = new HashMap<String, Integer>();
        ampRangeMap.put("MA0_20", 0);
        ampRangeMap.put("MA4_20", 1);
        voutRangeMap = new HashMap<String, Integer>();
        voutRangeMap.put("VPM10", 0);
        voutRangeMap.put("VPM5", 1);
        voutRangeMap.put("VPM2", 2);
        voutRangeMap.put("VP10", 3);
        voutRangeMap.put("VP5", 4);
        voutRangeMap.put("VP2", 5);
        typeMap = new HashMap<String, ModuleDef>();
        typeList = new ArrayList<Maq20.ModuleType>();
        Maq20.ModuleType type = Maq20.ModuleType.JTC;
        typeMap.put(type.name(), new ModuleDef(type, 8, jtcRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.KTC;
        typeMap.put(type.name(), new ModuleDef(type, 8, ktcRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.TTC;
        typeMap.put(type.name(), new ModuleDef(type, 8, ttcRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.RSTC;
        typeMap.put(type.name(), new ModuleDef(type, 8, rstcRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.RTD;
        typeMap.put(type.name(), new ModuleDef(type, 6, rtdRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.VD;
        typeMap.put(type.name(), new ModuleDef(type, 8, voltRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.VS;
        typeMap.put(type.name(), new ModuleDef(type, 16, voltRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.VO;
        typeMap.put(type.name(), new ModuleDef(type, 8, voutRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.MVD;
        typeMap.put(type.name(), new ModuleDef(type, 8, mvoltRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.ID;
        typeMap.put(type.name(), new ModuleDef(type, 8, ampRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.IS;
        typeMap.put(type.name(), new ModuleDef(type, 16, ampRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.IO;
        typeMap.put(type.name(), new ModuleDef(type, 8, ampRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.DIOH;
        typeMap.put(type.name(), new ModuleDef(type, 4, dummyRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.DIOL;
        typeMap.put(type.name(), new ModuleDef(type, 5, dummyRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.DINP;
        typeMap.put(type.name(), new ModuleDef(type, 20, dummyRangeMap, typeList.size()));
        typeList.add(type);
        type = Maq20.ModuleType.DOUT;
        typeMap.put(type.name(), new ModuleDef(type, 20, dummyRangeMap, typeList.size()));
        typeList.add(type);
        LOG = Logger.getLogger(Maq20Device.class.getName());
    }

    protected static interface Maq20Control {
        public void initialize() throws DriverException;

        public void close();
    }

    public static class ModuleData {
        public String serial;
        public int modId;
        public int[] discFunc = new int[2];
        public ModuleDef modDef;
        public Maq20Analog maqAna;
        public Maq20AnalogIn maqAnaIn;
        public Maq20AnalogOut maqAnaOut;
        public Maq20Discrete maqDisc;
        public Maq20DiscreteFreq maqDiscFreq;
        public Maq20DiscretePulse maqDiscPulse;
        public Maq20DiscretePWM maqDiscPWM;
        public Maq20DiscreteIn maqDiscIn;
        public Maq20DiscreteOut maqDiscOut;
    }

    public static class ModuleDef {
        final Maq20.ModuleType type;
        final int opType;
        final int numChan;
        final Map rangeMap;
        final int index;

        ModuleDef(Maq20.ModuleType type, int numChan, Map rangeMap, int index) {
            this.type = type;
            this.opType = Maq20.getModuleOpType((Maq20.ModuleType)type);
            this.numChan = numChan;
            this.rangeMap = rangeMap;
            this.index = index;
        }
    }
}

