/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.subsystem.focalplane.data.SequencerType;
import org.lsst.sal.cccamera.event.FocalPlaneSummaryInfoEvent;

public class SummaryInfoConverter {
    Pattern sensorPattern = Pattern.compile("(R..)/(Reb.)/(S..)/(\\w+)");
    Pattern rebPattern = Pattern.compile("(R..)/(Reb.)(?:_hardware)?/(\\w+)");
    Pattern raftPattern = Pattern.compile("(R..)/(.+)");

    public FocalPlaneSummaryInfoEvent convert(ConfigurationInfo data) {
        String raftName;
        String type;
        Matcher raftMatcher;
        TreeSet<String> ccdLocations = new TreeSet<String>();
        HashMap ccdNames = new HashMap();
        HashMap manSerNums = new HashMap();
        HashMap rebNames = new HashMap();
        HashMap rebSerialNums = new HashMap();
        HashMap raftNames = new HashMap();
        HashMap<String, Double> setTemp = new HashMap<String, Double>();
        HashMap seqMap = new HashMap();
        Map seqCheckSum = Collections.EMPTY_MAP;
        Map hardwareMap = data.getCurrentValuesForCategory("HardwareId");
        for (Map.Entry entry : hardwareMap.entrySet()) {
            Matcher matcher = this.sensorPattern.matcher((CharSequence)entry.getKey());
            Matcher matcher2 = this.rebPattern.matcher((CharSequence)entry.getKey());
            raftMatcher = this.raftPattern.matcher((CharSequence)entry.getKey());
            if (matcher.matches()) {
                String ccdName = matcher.group(1) + matcher.group(3);
                ccdLocations.add(ccdName);
                type = matcher.group(4);
                if ("name".equals(type)) {
                    ccdNames.put(ccdName, entry.getValue());
                    continue;
                }
                if (!"manSerNum".equals(type)) continue;
                manSerNums.put(ccdName, entry.getValue());
                continue;
            }
            if (matcher2.matches()) {
                String rebName = matcher2.group(1) + matcher2.group(2);
                type = matcher2.group(3);
                if (!"name".equals(type)) continue;
                rebNames.put(rebName, entry.getValue());
                continue;
            }
            if (!raftMatcher.matches()) continue;
            raftName = raftMatcher.group(1);
            type = raftMatcher.group(2);
            if (!"name".equals(type)) continue;
            raftNames.put(raftName, entry.getValue());
        }
        Map raftsMap = data.getCurrentValuesForCategory("Rafts");
        for (Map.Entry entry : raftsMap.entrySet()) {
            Matcher matcher = this.rebPattern.matcher((CharSequence)entry.getKey());
            if (!matcher.matches()) continue;
            String rebName = matcher.group(1) + matcher.group(2);
            String type2 = matcher.group(3);
            if (!"serialNum".equals(type2)) continue;
            rebSerialNums.put(rebName, entry.getValue());
        }
        Map map = data.getCurrentValuesForCategory("RaftTempControl");
        for (Map.Entry entry : map.entrySet()) {
            raftMatcher = this.raftPattern.matcher((CharSequence)entry.getKey());
            if (!raftMatcher.matches()) continue;
            raftName = raftMatcher.group(1);
            type = raftMatcher.group(2);
            if (!"TempControl/setTemp".equals(type)) continue;
            setTemp.put(raftName, Double.parseDouble((String)entry.getValue()));
        }
        Map map2 = data.getCurrentValuesForCategory("Sequencer");
        List list = data.getAllParameterInfo();
        for (ConfigurationParameterInfo pi : list) {
            if (!"sequencerConfig/sequencer".equals(pi.getPathName())) continue;
            seqMap.putAll((Map)pi.getConfiguredValueObject());
        }
        return FocalPlaneSummaryInfoEvent.builder().ccdLocation(ccdLocations.stream().collect(SummaryInfoConverter.join())).raftBay(ccdLocations.stream().map(SummaryInfoConverter::raftBayForCCDLocation).collect(SummaryInfoConverter.join())).ccdSlot(ccdLocations.stream().map(SummaryInfoConverter::ccdSlotForCCDLocation).collect(SummaryInfoConverter.join())).raftLSSTName(ccdLocations.stream().map(SummaryInfoConverter::raftBayForCCDLocation).map(name -> (String)raftNames.get(name)).collect(SummaryInfoConverter.join())).ccdLSSTName(ccdLocations.stream().map(k -> (String)ccdNames.get(k)).collect(SummaryInfoConverter.join())).ccdManufacturer(ccdLocations.stream().map(k -> ((String)ccdNames.get(k)).substring(0, 3)).collect(SummaryInfoConverter.join())).ccdType((FocalPlaneSummaryInfoEvent.CcdType[])ccdLocations.stream().map(k -> ((String)ccdNames.get(k)).substring(0, 3)).map(k -> FocalPlaneSummaryInfoEvent.CcdType.valueOf((String)k)).toArray(FocalPlaneSummaryInfoEvent.CcdType[]::new)).ccdManSerNum(ccdLocations.stream().map(k -> SummaryInfoConverter.get(manSerNums, k)).collect(SummaryInfoConverter.join())).rebSerialNumber(ccdLocations.stream().map(SummaryInfoConverter::rebSlotForCCDLocation).map(name -> (String)rebSerialNums.get(name)).collect(SummaryInfoConverter.join())).rebLSSTName(ccdLocations.stream().map(SummaryInfoConverter::rebSlotForCCDLocation).map(name -> SummaryInfoConverter.get(rebNames, name)).collect(SummaryInfoConverter.join())).ccdTempSetPoint(ccdLocations.stream().map(SummaryInfoConverter::raftBayForCCDLocation).map(name -> SummaryInfoConverter.get(setTemp, name, -999.0)).mapToDouble(d -> d).toArray()).sequencerKey(ccdLocations.stream().map(k -> ((String)ccdNames.get(k)).substring(0, 3)).map(k -> SequencerType.valueOf((String)k)).map(k -> SummaryInfoConverter.get(seqMap, k)).collect(SummaryInfoConverter.join())).sequencerChecksum(ccdLocations.stream().map(k -> ((String)ccdNames.get(k)).substring(0, 3)).map(k -> SequencerType.valueOf((String)k)).map(k -> SummaryInfoConverter.get(seqCheckSum, k)).collect(SummaryInfoConverter.join())).build();
    }

    private static String raftBayForCCDLocation(String ccdLocation) {
        return ccdLocation.substring(0, 3);
    }

    private static String ccdSlotForCCDLocation(String ccdLocation) {
        return ccdLocation.substring(3, 6);
    }

    private static String rebSlotForCCDLocation(String ccdLocation) {
        return ccdLocation.substring(0, 3) + "Reb" + ccdLocation.substring(5, 6);
    }

    private static <K> String get(Map<K, String> map, K name) {
        return SummaryInfoConverter.get(map, name, "Unknown");
    }

    private static <K, V> V get(Map<K, V> map, K key, V defaultValue) {
        return map.getOrDefault(key, defaultValue);
    }

    private static Collector<CharSequence, ?, String> join() {
        return Collectors.joining(":");
    }
}

