/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera.telemetry;

import java.util.Arrays;
import org.lsst.sal.camera.CameraTelemetry;

public class GasTelemetry
extends CameraTelemetry {
    private final short boardID;
    private final float[] boardCurrent;
    private final float[] boardTemp;
    private final float[] boardVoltage;
    private final int[] cabacMUX;
    private final short ccdID;
    private final int ccdtemp;
    private final int[] fpgaCheckSum;
    private final short rebID;

    public GasTelemetry(short boardID, float[] boardCurrent, float[] boardTemp, float[] boardVoltage, int[] cabacMUX, short ccdID, int ccdtemp, int[] fpgaCheckSum, short rebID) {
        this.boardID = boardID;
        this.boardCurrent = boardCurrent;
        this.boardTemp = boardTemp;
        this.boardVoltage = boardVoltage;
        this.cabacMUX = cabacMUX;
        this.ccdID = ccdID;
        this.ccdtemp = ccdtemp;
        this.fpgaCheckSum = fpgaCheckSum;
        this.rebID = rebID;
    }

    public short getBoardID() {
        return this.boardID;
    }

    public float[] getBoardCurrent() {
        return this.boardCurrent;
    }

    public float[] getBoardTemp() {
        return this.boardTemp;
    }

    public float[] getBoardVoltage() {
        return this.boardVoltage;
    }

    public int[] getCabacMUX() {
        return this.cabacMUX;
    }

    public short getCcdID() {
        return this.ccdID;
    }

    public int getCcdtemp() {
        return this.ccdtemp;
    }

    public int[] getFpgaCheckSum() {
        return this.fpgaCheckSum;
    }

    public short getRebID() {
        return this.rebID;
    }

    public String toString() {
        return "GasTelemetry{boardID=" + this.boardID + ", boardCurrent=" + Arrays.toString(this.boardCurrent) + ", boardTemp=" + Arrays.toString(this.boardTemp) + ", boardVoltage=" + Arrays.toString(this.boardVoltage) + ", cabacMUX=" + Arrays.toString(this.cabacMUX) + ", ccdID=" + this.ccdID + ", ccdtemp=" + this.ccdtemp + ", fpgaCheckSum=" + Arrays.toString(this.fpgaCheckSum) + ", rebID=" + this.rebID + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private short boardID;
        private float[] boardCurrent;
        private float[] boardTemp;
        private float[] boardVoltage;
        private int[] cabacMUX;
        private short ccdID;
        private int ccdtemp;
        private int[] fpgaCheckSum;
        private short rebID;

        private Builder() {
        }

        public Builder boardID(short boardID) {
            this.boardID = boardID;
            return this;
        }

        public Builder boardCurrent(float[] boardCurrent) {
            this.boardCurrent = boardCurrent;
            return this;
        }

        public Builder boardTemp(float[] boardTemp) {
            this.boardTemp = boardTemp;
            return this;
        }

        public Builder boardVoltage(float[] boardVoltage) {
            this.boardVoltage = boardVoltage;
            return this;
        }

        public Builder cabacMUX(int[] cabacMUX) {
            this.cabacMUX = cabacMUX;
            return this;
        }

        public Builder ccdID(short ccdID) {
            this.ccdID = ccdID;
            return this;
        }

        public Builder ccdtemp(int ccdtemp) {
            this.ccdtemp = ccdtemp;
            return this;
        }

        public Builder fpgaCheckSum(int[] fpgaCheckSum) {
            this.fpgaCheckSum = fpgaCheckSum;
            return this;
        }

        public Builder rebID(short rebID) {
            this.rebID = rebID;
            return this;
        }

        public GasTelemetry build() {
            return new GasTelemetry(this.boardID, this.boardCurrent, this.boardTemp, this.boardVoltage, this.cabacMUX, this.ccdID, this.ccdtemp, this.fpgaCheckSum, this.rebID);
        }
    }
}

