/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.comcamvacuum.ComCamVacuumSubsystem;
import org.lsst.ccs.subsystem.comcamvacuum.alerts.ComCamVacuumAlerts;
import org.lsst.ccs.utilities.logging.Logger;

public class ComCamVacuumAlertHandler
implements HasLifecycle,
Monitor.AlarmHandler,
ClearAlertHandler {
    private static final Logger LOG = Logger.getLogger((String)"org.lsst.ccs.subsystem.comcamvacuum.alarms");
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ComCamVacuumSubsystem comcam;

    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        LOG.info((Object)("processing alarms .... alert response enable = " + this.comcam.isAlertResponseEnabled()));
        if (parm == ComCamVacuumAlerts.PRESSURE_TOO_HIGH.ordinal() && this.comcam.isAlertResponseEnabled()) {
            this.alertService.raiseAlert(ComCamVacuumAlerts.PRESSURE_TOO_HIGH.getAlert(), ComCamVacuumAlertHandler.getAlarmStateFromEvent(event), alarmName + ": " + cause);
            switch (event) {
                case 0: {
                    this.comcam.setMonAlertEnabledVATShut(true);
                    LOG.info((Object)"Shutting the vacuum valve!");
                    Thread t = new Thread(new VacuumAlarmResponse());
                    t.start();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private static AlertState getAlarmStateFromEvent(int event) {
        switch (event) {
            case 0: {
                return AlertState.ALARM;
            }
            case 1: {
                return AlertState.WARNING;
            }
            case 2: {
                return AlertState.WARNING;
            }
            case 3: {
                return AlertState.NOMINAL;
            }
        }
        throw new IllegalArgumentException("Unknown event: id " + event);
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
        for (ComCamVacuumAlerts comcamAlert : ComCamVacuumAlerts.values()) {
            Alarm a;
            if (!comcamAlert.getId().equals(alert.getAlertId()) || (a = this.getAlarmById(comcamAlert.ordinal())) == null) continue;
            a.clearState();
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    class VacuumAlarmResponse
    implements Runnable {
        VacuumAlarmResponse() {
        }

        @Override
        public void run() {
        }
    }
}

