/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.FitsFilesWrittenEvent;
import org.lsst.ccs.utilities.location.LocationSet;

public class ImageEventSender
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ImageEventSender.class.getName());
    private final Future<FileList> futureFileList;
    private final Agent agent;
    private final String imageName;
    private final LocationSet locations;

    public ImageEventSender(Future<FileList> futureFileList, Agent agent, LocationSet locations, String imageName) {
        this.futureFileList = futureFileList;
        this.agent = agent;
        this.imageName = imageName;
        this.locations = locations;
    }

    @Override
    public void run() {
        FitsFilesWrittenEvent event;
        block5: {
            event = null;
            try {
                FileList fileList = this.futureFileList.get(30L, TimeUnit.SECONDS);
                if (fileList == null) {
                    LOG.log(Level.WARNING, "Timeout waiting for file list");
                    break block5;
                }
                LOG.log(Level.INFO, "File list received {0}", fileList);
                event = new FitsFilesWrittenEvent(this.imageName, fileList, this.locations);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                try {
                    LOG.log(Level.SEVERE, "Unexpected exception waiting for file list", ex);
                    event = new FitsFilesWrittenEvent(this.imageName, ex);
                }
                catch (Throwable throwable) {
                    KeyValueData kvd = new KeyValueData("fitsFilesWrittenEvent", event);
                    this.agent.publishSubsystemDataOnStatusBus(kvd);
                    throw throwable;
                }
                KeyValueData kvd = new KeyValueData("fitsFilesWrittenEvent", (Serializable)event);
                this.agent.publishSubsystemDataOnStatusBus(kvd);
            }
        }
        KeyValueData kvd = new KeyValueData("fitsFilesWrittenEvent", (Serializable)event);
        this.agent.publishSubsystemDataOnStatusBus(kvd);
    }
}

