/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.subsystem.focalplane.Sequencers;
import org.lsst.ccs.subsystem.focalplane.data.SequencerType;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.utilities.readout.ReadOutParametersNew;

public class SequencerConfig
implements ConfigurationBulkChangeHandler {
    private static final int UNDEFINED = -1;
    @ConfigurationParameter(category="Sequencer")
    private Map<SequencerType, String> sequencer = new HashMap<SequencerType, String>();
    @ConfigurationParameter(category="Sequencer", description="Names of meta-data related registers which must be in the sequencer")
    private String[] metaDataRegisters = ReadOutParametersNew.DEFAULT_NAMES;
    @ConfigurationParameter(category="Sequencer")
    private int preCols = -1;
    @ConfigurationParameter(category="Sequencer")
    private int underCols = -1;
    @ConfigurationParameter(category="Sequencer")
    private int readCols = -1;
    @ConfigurationParameter(category="Sequencer")
    private int postCols = -1;
    @ConfigurationParameter(category="Sequencer")
    private int readCols2 = -1;
    @ConfigurationParameter(category="Sequencer")
    private int overCols = -1;
    @ConfigurationParameter(category="Sequencer")
    private int preRows = -1;
    @ConfigurationParameter(category="Sequencer")
    private int readRows = -1;
    @ConfigurationParameter(category="Sequencer")
    private int postRows = -1;
    @ConfigurationParameter(category="Sequencer")
    private int overRows = -1;
    @ConfigurationParameter(category="Sequencer", description="True if the sequencer is in scan mode", units="unitless")
    private boolean scanMode = false;
    @ConfigurationParameter(category="DAQ", description="Folder in 2-day store where images will be created", units="unitless")
    private String daqFolder = "raw";
    @ConfigurationParameter(category="DAQ", description="True when using an emulated DAQ", units="unitless")
    private boolean emulatedDAQ = false;

    public SequencerConfig() {
        this.sequencer.put(SequencerType.ITL, "FP_ITL_2s_ir2_v1.seq");
        this.sequencer.put(SequencerType.E2V, "FP_E2V_2s_ir2_v1.seq");
    }

    public Map<SequencerType, String> getSequencers() {
        return this.sequencer;
    }

    public String[] getMetaDataRegisters() {
        return this.metaDataRegisters;
    }

    void setSequencer(String sequencer) {
        this.sequencer.put(SequencerType.ITL, sequencer);
    }

    public String getDAQFolder() {
        return this.daqFolder;
    }

    public void validateBulkChange(Map<String, Object> parametersView) {
        Map sequencerMap = (Map)parametersView.get("sequencer");
        if (sequencerMap.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty sequencer map");
        }
        for (String sequencerFile : sequencerMap.values()) {
            try {
                Sequencers.validate(sequencerFile);
            }
            catch (IOException | REBException | RaftException ex) {
                throw new IllegalArgumentException("Invalid sequencer file " + sequencerFile, ex);
            }
        }
    }

    void loadParameters(FPGA2Model model, SequencerProc seq) throws REBException, RaftException {
        this.setParameter(seq, model, "PreCols", this.preCols);
        this.setParameter(seq, model, "UnderCols", this.underCols);
        this.setParameter(seq, model, "ReadCols", this.readCols);
        this.setParameter(seq, model, "PostCols", this.postCols);
        this.setParameter(seq, model, "ReadCols2", this.readCols2);
        this.setParameter(seq, model, "OverCols", this.overCols);
        this.setParameter(seq, model, "PreRows", this.preRows);
        this.setParameter(seq, model, "ReadRows", this.readRows);
        this.setParameter(seq, model, "PostRows", this.postRows);
        this.setParameter(seq, model, "OverRows", this.overRows);
        seq.enableScan(this.scanMode);
    }

    private void setParameter(SequencerProc seq, FPGA2Model model, String name, int value) throws REBException, RaftException {
        FPGA2Model.PointerInfo pi = (FPGA2Model.PointerInfo)model.getPointerMap().get(name);
        if (pi == null) {
            throw new RaftException("Invalid pointer " + name);
        }
        seq.setParameter(name, value != -1 ? value : pi.getValue());
    }

    boolean hasEmulatedDAQ() {
        return this.emulatedDAQ;
    }
}

