/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.Serializable;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.data.ImageMetaDataEvent;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ImageMetaDataEventSender {
    private ImageName imageName;
    private double darkTime;
    private String daqTag = "";
    private CCSTimeStamp lastClearTime;
    private CCSTimeStamp integrationStartTime;
    private CCSTimeStamp integrationEndTime;
    private final FocalPlaneSubsystem subsys;

    ImageMetaDataEventSender(FocalPlaneSubsystem subsys) {
        this.subsys = subsys;
    }

    void start(ImageName imageName) {
        this.imageName = imageName;
    }

    void send() {
        ImageMetaDataEvent event = new ImageMetaDataEvent(this.imageName, this.darkTime, this.daqTag, this.lastClearTime, this.integrationStartTime, this.integrationEndTime);
        this.subsys.sendEvent(ImageMetaDataEvent.EVENT_KEY, (Serializable)event);
    }

    void setDarkTime(double darkTime) {
        this.darkTime = darkTime;
    }

    void setClearTime(CCSTimeStamp lastClear) {
        this.lastClearTime = lastClear;
    }

    void setIntegrationStartTime(CCSTimeStamp startTime) {
        this.integrationStartTime = startTime;
    }

    void setObservationEndTime(CCSTimeStamp endTime) {
        this.integrationEndTime = endTime;
    }
}

