/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.focalplane.AbortableCountDownLatch;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.ImageDatabase;
import org.lsst.ccs.subsystem.focalplane.ImageDatabaseService;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.FitsFilesWrittenEvent;
import org.lsst.ccs.subsystem.imagehandling.data.ImageReceivedEvent;

class ImageMessageHandling
implements AgentPresenceListener,
StatusMessageListener,
HasLifecycle {
    private static final Logger LOG = Logger.getLogger(ImageMessageHandling.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private FocalPlaneSubsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ImageDatabaseService idbs;
    private final Set<AgentInfo> imageHandlers = new CopyOnWriteArraySet<AgentInfo>();
    private String currentImageName;
    private AbortableCountDownLatch fitsFileCountDown;
    private AbortableCountDownLatch imageCountDown;
    private final FileList fitsFiles = new FileList();
    private final RuntimeException integrationStartException = new RuntimeException("Starting new acquisition");
    private ImageDatabase imageDatabase;

    ImageMessageHandling() {
    }

    public void start() {
        this.subsys.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.subsys.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
        this.imageDatabase = this.idbs.getImageDatabase();
    }

    public void shutdown() {
        this.subsys.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
        this.subsys.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
    }

    void clearWait(ImageName currentImage) {
        this.currentImageName = currentImage.toString();
        LOG.log(Level.INFO, "Resetting counters used to wait on images and fits files for image {0}.", this.currentImageName);
        this.resetVariablesForCurrentIntegration();
        if (this.imageDatabase != null) {
            this.imageDatabase.ingest(currentImage, this.fitsFiles, this.fitsFileCountDown);
        }
    }

    private void resetVariablesForCurrentIntegration() {
        if (this.fitsFileCountDown != null) {
            this.fitsFileCountDown.abort(this.integrationStartException);
        }
        if (this.imageCountDown != null) {
            this.imageCountDown.abort(this.integrationStartException);
        }
        int countdownSize = this.imageHandlers.size();
        this.fitsFileCountDown = new AbortableCountDownLatch(countdownSize);
        this.imageCountDown = new AbortableCountDownLatch(countdownSize);
        this.fitsFiles.clear();
    }

    FileList waitForFITSFiles(Duration timeout) throws InterruptedException, TimeoutException {
        if (this.fitsFileCountDown.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
            return this.fitsFiles;
        }
        throw new TimeoutException("Timed out while waiting for FITS files");
    }

    void waitForImages(Duration timeout) throws TimeoutException, InterruptedException {
        if (!this.imageCountDown.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Timed out while waiting for images");
        }
    }

    private static boolean isAgentAnImageHandler(AgentInfo agentInfo) {
        return AgentCategory.IMAGE_HANDLER.name().equals(agentInfo.getAgentProperty("agentCategory"));
    }

    public void connected(AgentInfo ... agents) {
        KeyValueDataList sequencerKeyValueData;
        boolean imageHandlerConnected = false;
        for (AgentInfo a : agents) {
            if (!ImageMessageHandling.isAgentAnImageHandler(a)) continue;
            this.imageHandlers.add(a);
            imageHandlerConnected = true;
        }
        if (imageHandlerConnected && (sequencerKeyValueData = this.subsys.getSequencers().getSequencerKeyValueData()) != null) {
            this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)sequencerKeyValueData);
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo a : agents) {
            if (!ImageMessageHandling.isAgentAnImageHandler(a)) continue;
            this.imageHandlers.remove(a);
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        AgentInfo agentInfo = msg.getOriginAgentInfo();
        if (ImageMessageHandling.isAgentAnImageHandler(agentInfo)) {
            String key;
            StatusSubsystemData statusData = (StatusSubsystemData)msg;
            switch (key = statusData.getDataKey()) {
                case "imageReceivedEvent": {
                    ImageReceivedEvent imageEvent = (ImageReceivedEvent)statusData.getSubsystemData().getValue();
                    if (!imageEvent.getImageName().equals(this.currentImageName)) break;
                    if (this.imageDatabase != null) {
                        this.imageDatabase.setMetaData(imageEvent.getImageMetaData());
                    }
                    this.imageCountDown.countDown();
                    LOG.log(Level.INFO, "Received imageReceivedEvent for {0} from {1}", new Object[]{this.currentImageName, agentInfo.getName()});
                    break;
                }
                case "fitsFilesWrittenEvent": {
                    FitsFilesWrittenEvent fitsFileEvent = (FitsFilesWrittenEvent)statusData.getSubsystemData().getValue();
                    if (!fitsFileEvent.getImageName().equals(this.currentImageName)) break;
                    FileList fileList = fitsFileEvent.getFileList();
                    if (fileList == null) {
                        this.fitsFileCountDown.abort(fitsFileEvent.getException());
                        break;
                    }
                    if (this.imageDatabase != null) {
                        this.imageDatabase.addLocations(fitsFileEvent.getLocations());
                    }
                    this.fitsFiles.addAll((Collection)fitsFileEvent.getFileList());
                    this.fitsFileCountDown.countDown();
                    LOG.log(Level.INFO, "Received fitsFilesWrittenEvent for {0} from {1} with {2} files", new Object[]{this.currentImageName, agentInfo.getName(), fitsFileEvent.getFileList().size()});
                }
            }
        }
    }

    void handleMetaData(Map<String, Serializable> headersMap) {
        if (this.imageDatabase != null) {
            this.imageDatabase.addMetaData(headersMap);
        }
    }
}

