/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.sal.camera.CameraTelemetry;

public class GenericConverter {
    private static final Logger LOG = Logger.getLogger(GenericConverter.class.getName());
    private final Map<Class, String> subSystemClasses;

    public GenericConverter(Map<Class, String> subSystemClasses) {
        this.subSystemClasses = subSystemClasses;
    }

    public List<CameraTelemetry> telemetryConverter(StatusSubsystemData statusInfo) throws ReflectiveOperationException {
        ArrayList<CameraTelemetry> salTelemetry = new ArrayList<CameraTelemetry>();
        HashMap<String, Object> receivedInfo = new HashMap<String, Object>();
        KeyValueData subsystemData = statusInfo.getSubsystemData();
        List values = (List)((Object)subsystemData.getValue());
        for (KeyValueData keyValueData : values) {
            int lastDot;
            String key = keyValueData.getKey();
            if (key.contains("/state")) continue;
            Serializable thisValue = keyValueData.getValue();
            if (thisValue instanceof Double) {
                thisValue = Float.valueOf(((Double)thisValue).floatValue());
            }
            if ((lastDot = key.lastIndexOf(46)) >= 0) {
                key = key.substring(lastDot + 1);
            }
            String pathFromBus = keyValueData.getKey().replace("/", "");
            pathFromBus = pathFromBus.replace("main", "");
            pathFromBus = pathFromBus.replace("_", "");
            pathFromBus = pathFromBus.toLowerCase().trim();
            receivedInfo.put(pathFromBus + ":" + keyValueData.getValue().getClass().getTypeName(), thisValue);
        }
        for (Map.Entry entry : this.subSystemClasses.entrySet()) {
            Parameter[] parameters = ((Class)entry.getKey()).getConstructors()[0].getParameters();
            CameraTelemetry ct = (CameraTelemetry)((Object)GenericConverter.reflectedClass((Class)entry.getKey(), parameters, receivedInfo));
            Parameter[] thisClassParameters = ((Object)((Object)ct)).getClass().getConstructors()[0].getParameters();
            Method[] methods = ((Object)((Object)ct)).getClass().getDeclaredMethods();
            ArrayList<Method> getMethods = new ArrayList<Method>();
            int numMissingValues = 0;
            int numGetMethods = 0;
            double badValue = -111111.0;
            for (int i = 0; i < methods.length; ++i) {
                String methodName = methods[i].getName();
                String[] parts = methodName.split("\\s");
                if (parts[parts.length - 1].contains("toString") || !parts[parts.length - 1].contains("get")) continue;
                getMethods.add(methods[i]);
                ++numGetMethods;
            }
            for (Method method : getMethods) {
                if (!method.invoke((Object)ct, new Object[0]).equals(badValue)) continue;
                ++numMissingValues;
            }
            if (numMissingValues == numGetMethods) continue;
            salTelemetry.add(ct);
        }
        return salTelemetry;
    }

    private static Object reflectedClass(Class cls, Parameter[] parameters, Map<String, Object> receivedInfo) throws ReflectiveOperationException {
        String cleanedCurrentClassName = cls.getName().split("\\.")[cls.getName().split("\\.").length - 1];
        System.out.println(cleanedCurrentClassName);
        cleanedCurrentClassName = cleanedCurrentClassName.replace("Telemetry", "");
        cleanedCurrentClassName = cleanedCurrentClassName.split("_")[cleanedCurrentClassName.split("_").length - 1];
        System.out.println("Preliminary Cleaning " + cleanedCurrentClassName);
        cleanedCurrentClassName = cleanedCurrentClassName.toLowerCase().trim();
        ArrayList<Object> constructorArgs = new ArrayList<Object>();
        if (cls.getName().contains("Setting")) {
            System.out.println(cls.getConstructors()[0].toString());
            for (Map.Entry entry : receivedInfo.entrySet()) {
                System.out.println((String)entry.getKey() + " " + entry.getValue());
            }
        }
        for (Parameter parameter : parameters) {
            if (parameter.getName().trim().equals("priority")) {
                constructorArgs.add(1);
                continue;
            }
            boolean found = false;
            for (Map.Entry<String, Object> data : receivedInfo.entrySet()) {
                String[] splitAndGetData = data.getKey().split(":");
                String keyName = splitAndGetData[0].toLowerCase().trim();
                String varType = splitAndGetData[1];
                String parameterFromClass = "";
                if (parameter.toString().length() > 1) {
                    String[] lastBit = parameter.toString().split(" ");
                    parameterFromClass = lastBit[lastBit.length - 1].toLowerCase().trim();
                    parameterFromClass = parameterFromClass.replace("_", "");
                    parameterFromClass = parameterFromClass.trim();
                }
                if (!keyName.contains((cleanedCurrentClassName + parameterFromClass).trim())) continue;
                boolean isAnArrayList = varType.trim().contains("List");
                boolean isAnArray = !isAnArrayList && varType.trim().contains("[");
                boolean isAString = varType.trim().contains("String");
                if (!isAnArrayList && !isAnArray) {
                    constructorArgs.add(data.getValue());
                }
                if (!isAnArray && isAnArrayList) {
                    ArrayList arr = (ArrayList)data.getValue();
                    if (!isAString) {
                        constructorArgs.add(arr.toArray());
                    } else {
                        String joinedArrayL = "";
                        ArrayList arrl = new ArrayList();
                        arrl = (ArrayList)data.getValue();
                        for (int i = 0; i < arrl.size(); ++i) {
                            joinedArrayL = joinedArrayL + (String)arrl.get(i) + ":";
                        }
                        constructorArgs.add(joinedArrayL);
                    }
                }
                if (!isAnArrayList && !isAString && isAnArray) {
                    constructorArgs.add(data.getValue());
                }
                if (isAString && isAnArray && !isAnArrayList) {
                    String joinedArray = "";
                    for (Object o : (Object[])data.getValue()) {
                        joinedArray = joinedArray + (String)o + ":";
                    }
                    constructorArgs.add(joinedArray);
                }
                found = true;
                break;
            }
            if (found) continue;
            LOG.log(Level.WARNING, "No value found for parameter {0} in {1}", new Object[]{parameter.getName(), receivedInfo});
            constructorArgs.add(-111111);
        }
        return cls.getConstructors()[0].newInstance(constructorArgs.toArray());
    }
}

