/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.DATAREADERVIEW_QOS_DEFAULT;
import DDS.DATAREADER_QOS_DEFAULT;
import DDS.DATAREADER_QOS_USE_TOPIC_QOS;
import DDS.DATAWRITER_QOS_DEFAULT;
import DDS.DATAWRITER_QOS_USE_TOPIC_QOS;
import DDS.DataReaderQos;
import DDS.DataReaderViewQos;
import DDS.DataWriterQos;
import DDS.DeadlineQosPolicy;
import DDS.DestinationOrderQosPolicy;
import DDS.DestinationOrderQosPolicyKind;
import DDS.DomainParticipantFactoryQos;
import DDS.DomainParticipantQos;
import DDS.DurabilityQosPolicy;
import DDS.DurabilityQosPolicyKind;
import DDS.DurabilityServiceQosPolicy;
import DDS.Duration_t;
import DDS.EntityFactoryQosPolicy;
import DDS.GroupDataQosPolicy;
import DDS.HistoryQosPolicy;
import DDS.HistoryQosPolicyKind;
import DDS.InvalidSampleVisibilityQosPolicy;
import DDS.InvalidSampleVisibilityQosPolicyKind;
import DDS.LatencyBudgetQosPolicy;
import DDS.LifespanQosPolicy;
import DDS.LivelinessQosPolicy;
import DDS.LivelinessQosPolicyKind;
import DDS.OwnershipQosPolicy;
import DDS.OwnershipQosPolicyKind;
import DDS.OwnershipStrengthQosPolicy;
import DDS.PARTICIPANTFACTORY_QOS_DEFAULT;
import DDS.PARTICIPANT_QOS_DEFAULT;
import DDS.PUBLISHER_QOS_DEFAULT;
import DDS.PartitionQosPolicy;
import DDS.PresentationQosPolicy;
import DDS.PresentationQosPolicyAccessScopeKind;
import DDS.PublisherQos;
import DDS.ReaderDataLifecycleQosPolicy;
import DDS.ReaderLifespanQosPolicy;
import DDS.ReliabilityQosPolicy;
import DDS.ReliabilityQosPolicyKind;
import DDS.ResourceLimitsQosPolicy;
import DDS.SUBSCRIBER_QOS_DEFAULT;
import DDS.SchedulingClassQosPolicy;
import DDS.SchedulingClassQosPolicyKind;
import DDS.SchedulingPriorityQosPolicy;
import DDS.SchedulingPriorityQosPolicyKind;
import DDS.SchedulingQosPolicy;
import DDS.ShareQosPolicy;
import DDS.SubscriberQos;
import DDS.SubscriptionKeyQosPolicy;
import DDS.TOPIC_QOS_DEFAULT;
import DDS.TimeBasedFilterQosPolicy;
import DDS.Time_t;
import DDS.TopicDataQosPolicy;
import DDS.TopicQos;
import DDS.TransportPriorityQosPolicy;
import DDS.UserDataQosPolicy;
import DDS.ViewKeyQosPolicy;
import DDS.WriterDataLifecycleQosPolicy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_MEMORY;
import org.opensplice.dds.dcps.ReportStack;

public class Utilities {
    public static final int EXCEPTION_TYPE_BAD_PARAM = 0;
    public static final int EXCEPTION_TYPE_NO_MEMORY = 1;
    public static final int EXCEPTION_TYPE_MARSHAL = 2;
    public static final int EXCEPTION_TYPE_BAD_OPERATION = 3;
    public static final Time_t DDS_TIMESTAMP_CURRENT = new Time_t(-1, -2);
    public static final boolean USE_OLD_ReaderDataLifecycleQosPolicy = true;
    public static final Duration_t ZeroDuration = new Duration_t(0, 0);
    public static final Duration_t InfiniteDuration = new Duration_t(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final EntityFactoryQosPolicy defaultEntityFactoryQosPolicy = new EntityFactoryQosPolicy(true);
    public static final UserDataQosPolicy defaultUserDataQosPolicy = new UserDataQosPolicy(new byte[0]);
    public static final SchedulingClassQosPolicy defaultSchedulingClassQosPolicy = new SchedulingClassQosPolicy(SchedulingClassQosPolicyKind.SCHEDULE_DEFAULT);
    public static final SchedulingPriorityQosPolicy defaultSchedulingPriorityQosPolicy = new SchedulingPriorityQosPolicy(SchedulingPriorityQosPolicyKind.PRIORITY_RELATIVE);
    public static final SchedulingQosPolicy defaultSchedulingQosPolicy = new SchedulingQosPolicy(defaultSchedulingClassQosPolicy, defaultSchedulingPriorityQosPolicy, 0);
    public static final PresentationQosPolicy defaultPresentationQosPolicy = new PresentationQosPolicy(PresentationQosPolicyAccessScopeKind.INSTANCE_PRESENTATION_QOS, false, false);
    public static final PartitionQosPolicy defaultPartitionQosPolicy = new PartitionQosPolicy(new String[0]);
    public static final GroupDataQosPolicy defaultGroupDataQosPolicy = new GroupDataQosPolicy(new byte[0]);
    public static final TopicDataQosPolicy defaultTopicDataQosPolicy = new TopicDataQosPolicy(new byte[0]);
    public static final DurabilityQosPolicy defaultDurabilityQosPolicy = new DurabilityQosPolicy(DurabilityQosPolicyKind.VOLATILE_DURABILITY_QOS);
    public static final DurabilityServiceQosPolicy defaultDurabilityServiceQosPolicy = new DurabilityServiceQosPolicy(ZeroDuration, HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS, 1, -1, -1, -1);
    public static final DeadlineQosPolicy defaultDeadlineQosPolicy = new DeadlineQosPolicy(InfiniteDuration);
    public static final LatencyBudgetQosPolicy defaultLatencyBudgetQosPolicy = new LatencyBudgetQosPolicy(ZeroDuration);
    public static final LivelinessQosPolicy defaultLivelinessQosPolicy = new LivelinessQosPolicy(LivelinessQosPolicyKind.AUTOMATIC_LIVELINESS_QOS, InfiniteDuration);
    public static final ReliabilityQosPolicy defaultDataReaderReliabilityQosPolicy = new ReliabilityQosPolicy(ReliabilityQosPolicyKind.BEST_EFFORT_RELIABILITY_QOS, new Duration_t(0, 100000000), false);
    public static final ReliabilityQosPolicy defaultDataWriterReliabilityQosPolicy = new ReliabilityQosPolicy(ReliabilityQosPolicyKind.RELIABLE_RELIABILITY_QOS, new Duration_t(0, 100000000), false);
    public static final DestinationOrderQosPolicy defaultDestinationOrderQosPolicy = new DestinationOrderQosPolicy(DestinationOrderQosPolicyKind.BY_RECEPTION_TIMESTAMP_DESTINATIONORDER_QOS);
    public static final HistoryQosPolicy defaultHistoryQosPolicy = new HistoryQosPolicy(HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS, 1);
    public static final ResourceLimitsQosPolicy defaultResourceLimitsQosPolicy = new ResourceLimitsQosPolicy(-1, -1, -1);
    public static final TransportPriorityQosPolicy defaultTransportPriorityQosPolicy = new TransportPriorityQosPolicy(0);
    public static final LifespanQosPolicy defaultLifespanQosPolicy = new LifespanQosPolicy(InfiniteDuration);
    public static final OwnershipQosPolicy defaultOwnershipQosPolicy = new OwnershipQosPolicy(OwnershipQosPolicyKind.SHARED_OWNERSHIP_QOS);
    public static final OwnershipStrengthQosPolicy defaultOwnershipStrengthQosPolicy = new OwnershipStrengthQosPolicy(0);
    public static final WriterDataLifecycleQosPolicy defaultWriterDataLifecycleQosPolicy = new WriterDataLifecycleQosPolicy(true, InfiniteDuration, InfiniteDuration);
    public static final TimeBasedFilterQosPolicy defaultTimeBasedFilterQosPolicy = new TimeBasedFilterQosPolicy(ZeroDuration);
    public static final InvalidSampleVisibilityQosPolicy defaultInvalidSampleVisibilityQosPolicy = new InvalidSampleVisibilityQosPolicy(InvalidSampleVisibilityQosPolicyKind.MINIMUM_INVALID_SAMPLES);
    public static final ReaderDataLifecycleQosPolicy defaultReaderDataLifecycleQosPolicy = new ReaderDataLifecycleQosPolicy(InfiniteDuration, InfiniteDuration, false, true, defaultInvalidSampleVisibilityQosPolicy);
    public static final ShareQosPolicy defaultShareQosPolicy = new ShareQosPolicy("", false);
    public static final ReaderLifespanQosPolicy defaultReaderLifespanQosPolicy = new ReaderLifespanQosPolicy(false, InfiniteDuration);
    public static final SubscriptionKeyQosPolicy defaultSubscriptionKeyQosPolicy = new SubscriptionKeyQosPolicy(false, new String[0]);
    public static final ViewKeyQosPolicy defaultViewKeyQosPolicy = new ViewKeyQosPolicy(false, new String[0]);
    public static final DomainParticipantFactoryQos defaultDomainParticipantFactoryQos = new DomainParticipantFactoryQos(defaultEntityFactoryQosPolicy);
    public static final DomainParticipantQos defaultDomainParticipantQos = new DomainParticipantQos(defaultUserDataQosPolicy, defaultEntityFactoryQosPolicy, defaultSchedulingQosPolicy, defaultSchedulingQosPolicy);
    public static final SubscriberQos defaultSubscriberQos = new SubscriberQos(defaultPresentationQosPolicy, defaultPartitionQosPolicy, defaultGroupDataQosPolicy, defaultEntityFactoryQosPolicy, defaultShareQosPolicy);
    public static final PublisherQos defaultPublisherQos = new PublisherQos(defaultPresentationQosPolicy, defaultPartitionQosPolicy, defaultGroupDataQosPolicy, defaultEntityFactoryQosPolicy);
    public static final TopicQos defaultTopicQos = new TopicQos(defaultTopicDataQosPolicy, defaultDurabilityQosPolicy, defaultDurabilityServiceQosPolicy, defaultDeadlineQosPolicy, defaultLatencyBudgetQosPolicy, defaultLivelinessQosPolicy, defaultDataReaderReliabilityQosPolicy, defaultDestinationOrderQosPolicy, defaultHistoryQosPolicy, defaultResourceLimitsQosPolicy, defaultTransportPriorityQosPolicy, defaultLifespanQosPolicy, defaultOwnershipQosPolicy);
    public static final DataWriterQos defaultDataWriterQos = new DataWriterQos(defaultDurabilityQosPolicy, defaultDeadlineQosPolicy, defaultLatencyBudgetQosPolicy, defaultLivelinessQosPolicy, defaultDataWriterReliabilityQosPolicy, defaultDestinationOrderQosPolicy, defaultHistoryQosPolicy, defaultResourceLimitsQosPolicy, defaultTransportPriorityQosPolicy, defaultLifespanQosPolicy, defaultUserDataQosPolicy, defaultOwnershipQosPolicy, defaultOwnershipStrengthQosPolicy, defaultWriterDataLifecycleQosPolicy);
    public static final DataReaderQos defaultDataReaderQos = new DataReaderQos(defaultDurabilityQosPolicy, defaultDeadlineQosPolicy, defaultLatencyBudgetQosPolicy, defaultLivelinessQosPolicy, defaultDataReaderReliabilityQosPolicy, defaultDestinationOrderQosPolicy, defaultHistoryQosPolicy, defaultResourceLimitsQosPolicy, defaultUserDataQosPolicy, defaultOwnershipQosPolicy, defaultTimeBasedFilterQosPolicy, defaultReaderDataLifecycleQosPolicy, defaultSubscriptionKeyQosPolicy, defaultReaderLifespanQosPolicy, defaultShareQosPolicy);
    public static final DataReaderViewQos defaultDataReaderViewQos = new DataReaderViewQos(defaultViewKeyQosPolicy);

    protected static OwnershipQosPolicy deepCopy(OwnershipQosPolicy o) {
        return new OwnershipQosPolicy(o.kind);
    }

    protected static byte[] deepCopy(byte[] o) {
        byte[] n = new byte[o.length];
        for (int i = 0; i < o.length; ++i) {
            n[i] = o[i];
        }
        return n;
    }

    protected static String[] deepCopy(String[] o) {
        String[] name = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            name[i] = new String(o[i]);
        }
        return name;
    }

    protected static Duration_t deepCopy(Duration_t o) {
        return new Duration_t(o.sec, o.nanosec);
    }

    protected static EntityFactoryQosPolicy deepCopy(EntityFactoryQosPolicy o) {
        return new EntityFactoryQosPolicy(o.autoenable_created_entities);
    }

    protected static UserDataQosPolicy deepCopy(UserDataQosPolicy o) {
        return new UserDataQosPolicy(Utilities.deepCopy(o.value));
    }

    protected static SchedulingClassQosPolicy deepCopy(SchedulingClassQosPolicy o) {
        return new SchedulingClassQosPolicy(o.kind);
    }

    protected static SchedulingPriorityQosPolicy deepCopy(SchedulingPriorityQosPolicy o) {
        return new SchedulingPriorityQosPolicy(o.kind);
    }

    protected static SchedulingQosPolicy deepCopy(SchedulingQosPolicy o) {
        return new SchedulingQosPolicy(Utilities.deepCopy(o.scheduling_class), Utilities.deepCopy(o.scheduling_priority_kind), o.scheduling_priority);
    }

    protected static PresentationQosPolicy deepCopy(PresentationQosPolicy o) {
        return new PresentationQosPolicy(o.access_scope, o.coherent_access, o.ordered_access);
    }

    protected static PartitionQosPolicy deepCopy(PartitionQosPolicy o) {
        return new PartitionQosPolicy(Utilities.deepCopy(o.name));
    }

    protected static GroupDataQosPolicy deepCopy(GroupDataQosPolicy o) {
        return new GroupDataQosPolicy(Utilities.deepCopy(o.value));
    }

    protected static TopicDataQosPolicy deepCopy(TopicDataQosPolicy o) {
        return new TopicDataQosPolicy(Utilities.deepCopy(o.value));
    }

    protected static DurabilityQosPolicy deepCopy(DurabilityQosPolicy o) {
        return new DurabilityQosPolicy(o.kind);
    }

    protected static DurabilityServiceQosPolicy deepCopy(DurabilityServiceQosPolicy o) {
        return new DurabilityServiceQosPolicy(Utilities.deepCopy(o.service_cleanup_delay), o.history_kind, o.history_depth, o.max_samples, o.max_instances, o.max_samples_per_instance);
    }

    protected static DeadlineQosPolicy deepCopy(DeadlineQosPolicy o) {
        return new DeadlineQosPolicy(Utilities.deepCopy(o.period));
    }

    protected static LatencyBudgetQosPolicy deepCopy(LatencyBudgetQosPolicy o) {
        return new LatencyBudgetQosPolicy(Utilities.deepCopy(o.duration));
    }

    protected static LivelinessQosPolicy deepCopy(LivelinessQosPolicy o) {
        return new LivelinessQosPolicy(o.kind, Utilities.deepCopy(o.lease_duration));
    }

    protected static ReliabilityQosPolicy deepCopy(ReliabilityQosPolicy o) {
        return new ReliabilityQosPolicy(o.kind, Utilities.deepCopy(o.max_blocking_time), o.synchronous);
    }

    protected static DestinationOrderQosPolicy deepCopy(DestinationOrderQosPolicy o) {
        return new DestinationOrderQosPolicy(o.kind);
    }

    protected static HistoryQosPolicy deepCopy(HistoryQosPolicy o) {
        return new HistoryQosPolicy(o.kind, o.depth);
    }

    protected static ResourceLimitsQosPolicy deepCopy(ResourceLimitsQosPolicy o) {
        return new ResourceLimitsQosPolicy(o.max_samples, o.max_instances, o.max_samples_per_instance);
    }

    protected static TransportPriorityQosPolicy deepCopy(TransportPriorityQosPolicy o) {
        return new TransportPriorityQosPolicy(o.value);
    }

    protected static LifespanQosPolicy deepCopy(LifespanQosPolicy o) {
        return new LifespanQosPolicy(Utilities.deepCopy(o.duration));
    }

    protected static OwnershipStrengthQosPolicy deepCopy(OwnershipStrengthQosPolicy o) {
        return new OwnershipStrengthQosPolicy(o.value);
    }

    protected static WriterDataLifecycleQosPolicy deepCopy(WriterDataLifecycleQosPolicy o) {
        return new WriterDataLifecycleQosPolicy(o.autodispose_unregistered_instances, Utilities.deepCopy(o.autopurge_suspended_samples_delay), Utilities.deepCopy(o.autounregister_instance_delay));
    }

    protected static TimeBasedFilterQosPolicy deepCopy(TimeBasedFilterQosPolicy o) {
        return new TimeBasedFilterQosPolicy(Utilities.deepCopy(o.minimum_separation));
    }

    protected static InvalidSampleVisibilityQosPolicy deepCopy(InvalidSampleVisibilityQosPolicy o) {
        return new InvalidSampleVisibilityQosPolicy(o.kind);
    }

    protected static ReaderDataLifecycleQosPolicy deepCopy(ReaderDataLifecycleQosPolicy o) {
        return new ReaderDataLifecycleQosPolicy(Utilities.deepCopy(o.autopurge_nowriter_samples_delay), Utilities.deepCopy(o.autopurge_disposed_samples_delay), o.autopurge_dispose_all, o.enable_invalid_samples, o.invalid_sample_visibility);
    }

    protected static ShareQosPolicy deepCopy(ShareQosPolicy o) {
        return new ShareQosPolicy(o.name, o.enable);
    }

    protected static ReaderLifespanQosPolicy deepCopy(ReaderLifespanQosPolicy o) {
        return new ReaderLifespanQosPolicy(o.use_lifespan, Utilities.deepCopy(o.duration));
    }

    protected static SubscriptionKeyQosPolicy deepCopy(SubscriptionKeyQosPolicy o) {
        return new SubscriptionKeyQosPolicy(o.use_key_list, Utilities.deepCopy(o.key_list));
    }

    protected static DomainParticipantFactoryQos deepCopy(DomainParticipantFactoryQos o) {
        return new DomainParticipantFactoryQos(Utilities.deepCopy(o.entity_factory));
    }

    protected static DomainParticipantQos deepCopy(DomainParticipantQos o) {
        return new DomainParticipantQos(Utilities.deepCopy(o.user_data), Utilities.deepCopy(o.entity_factory), Utilities.deepCopy(o.watchdog_scheduling), Utilities.deepCopy(o.listener_scheduling));
    }

    protected static TopicQos deepCopy(TopicQos o) {
        return new TopicQos(Utilities.deepCopy(o.topic_data), Utilities.deepCopy(o.durability), Utilities.deepCopy(o.durability_service), Utilities.deepCopy(o.deadline), Utilities.deepCopy(o.latency_budget), Utilities.deepCopy(o.liveliness), Utilities.deepCopy(o.reliability), Utilities.deepCopy(o.destination_order), Utilities.deepCopy(o.history), Utilities.deepCopy(o.resource_limits), Utilities.deepCopy(o.transport_priority), Utilities.deepCopy(o.lifespan), Utilities.deepCopy(o.ownership));
    }

    public static PublisherQos deepCopy(PublisherQos o) {
        return new PublisherQos(Utilities.deepCopy(o.presentation), Utilities.deepCopy(o.partition), Utilities.deepCopy(o.group_data), Utilities.deepCopy(o.entity_factory));
    }

    public static SubscriberQos deepCopy(SubscriberQos o) {
        return new SubscriberQos(Utilities.deepCopy(o.presentation), Utilities.deepCopy(o.partition), Utilities.deepCopy(o.group_data), Utilities.deepCopy(o.entity_factory), Utilities.deepCopy(o.share));
    }

    public static DataWriterQos deepCopy(DataWriterQos o) {
        return new DataWriterQos(Utilities.deepCopy(o.durability), Utilities.deepCopy(o.deadline), Utilities.deepCopy(o.latency_budget), Utilities.deepCopy(o.liveliness), Utilities.deepCopy(o.reliability), Utilities.deepCopy(o.destination_order), Utilities.deepCopy(o.history), Utilities.deepCopy(o.resource_limits), Utilities.deepCopy(o.transport_priority), Utilities.deepCopy(o.lifespan), Utilities.deepCopy(o.user_data), Utilities.deepCopy(o.ownership), Utilities.deepCopy(o.ownership_strength), Utilities.deepCopy(o.writer_data_lifecycle));
    }

    public static DataReaderQos deepCopy(DataReaderQos o) {
        return new DataReaderQos(Utilities.deepCopy(o.durability), Utilities.deepCopy(o.deadline), Utilities.deepCopy(o.latency_budget), Utilities.deepCopy(o.liveliness), Utilities.deepCopy(o.reliability), Utilities.deepCopy(o.destination_order), Utilities.deepCopy(o.history), Utilities.deepCopy(o.resource_limits), Utilities.deepCopy(o.user_data), Utilities.deepCopy(o.ownership), Utilities.deepCopy(o.time_based_filter), Utilities.deepCopy(o.reader_data_lifecycle), Utilities.deepCopy(o.subscription_keys), Utilities.deepCopy(o.reader_lifespan), Utilities.deepCopy(o.share));
    }

    public static DataReaderViewQos deepCopy(DataReaderViewQos o) {
        return new DataReaderViewQos(Utilities.deepCopy(o.view_keys));
    }

    protected static ViewKeyQosPolicy deepCopy(ViewKeyQosPolicy o) {
        return new ViewKeyQosPolicy(o.use_key_list, Utilities.deepCopy(o.key_list));
    }

    protected static int checkDuration(Duration_t o) {
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, "Duration_t 'null' is invalid");
        } else if (!(o.sec == Integer.MAX_VALUE && o.nanosec == Integer.MAX_VALUE || o.sec != Integer.MAX_VALUE && o.nanosec < 1000000000)) {
            result = 3;
            ReportStack.report(result, "Duration_t is invalid, seconds '" + o.sec + "', nanoseconds '" + o.nanosec + "'.");
        } else if (o.sec != Integer.MAX_VALUE && o.sec < 0) {
            result = 3;
            ReportStack.report(result, "Negative Duration_t seconds is not allowed");
        }
        return result;
    }

    public static int checkTime(Time_t o) {
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, "Time_t 'null' is invalid.");
        } else {
            try {
                long max_value = Long.MAX_VALUE;
                if (o.getClass().getField("sec").getType() != Long.TYPE) {
                    max_value = Integer.MAX_VALUE;
                }
                if (!((long)o.sec == max_value && o.nanosec == Integer.MAX_VALUE || (long)o.sec != max_value && o.nanosec < 1000000000)) {
                    result = 3;
                    ReportStack.report(result, "Time_t is invalid, seconds '" + o.sec + "', nanoseconds '" + o.nanosec + "'.");
                }
            }
            catch (NoSuchFieldException e) {
                result = 3;
                ReportStack.report(result, "Time_t is invalid.");
            }
            catch (SecurityException e) {
                result = 3;
                ReportStack.report(result, "Time_t is invalid.");
            }
        }
        return result;
    }

    protected static int checkPolicy(EntityFactoryQosPolicy o) {
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, "EntityFactoryQosPolicy 'null' is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(UserDataQosPolicy o) {
        String policy = "UserDataQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.value == null) {
            result = 3;
            ReportStack.report(result, policy + ".value 'null' is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(SchedulingClassQosPolicy o) {
        String policy = "SchedulingClassQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.kind != SchedulingClassQosPolicyKind.SCHEDULE_DEFAULT && o.kind != SchedulingClassQosPolicyKind.SCHEDULE_TIMESHARING && o.kind != SchedulingClassQosPolicyKind.SCHEDULE_REALTIME) {
            result = 3;
            ReportStack.report(result, policy + ".kind is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(SchedulingPriorityQosPolicy o) {
        String policy = "SchedulingPriorityQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.kind != SchedulingPriorityQosPolicyKind.PRIORITY_RELATIVE && o.kind != SchedulingPriorityQosPolicyKind.PRIORITY_ABSOLUTE) {
            result = 3;
            ReportStack.report(result, policy + ".kind is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(SchedulingQosPolicy o) {
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, "SchedulingQosPolicy 'null' is invalid.");
        } else {
            result = Utilities.checkPolicy(o.scheduling_class);
            if (result == 0) {
                result = Utilities.checkPolicy(o.scheduling_priority_kind);
            }
        }
        return result;
    }

    protected static int checkPolicy(PresentationQosPolicy o) {
        String policy = "PresentationQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.access_scope != PresentationQosPolicyAccessScopeKind.TOPIC_PRESENTATION_QOS && o.access_scope != PresentationQosPolicyAccessScopeKind.GROUP_PRESENTATION_QOS && o.access_scope != PresentationQosPolicyAccessScopeKind.INSTANCE_PRESENTATION_QOS) {
            result = 3;
            ReportStack.report(result, policy + ".access_scope is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(PartitionQosPolicy o) {
        String policy = "PartitionQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.name == null) {
            result = 3;
            ReportStack.report(result, policy + ".name 'null' is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(GroupDataQosPolicy o) {
        String policy = "GroupDataQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.value == null) {
            result = 3;
            ReportStack.report(result, policy + ".value 'null' is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(TopicDataQosPolicy o) {
        String policy = "TopicDataQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.value == null) {
            result = 3;
            ReportStack.report(result, policy + ".value 'null' is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(DurabilityQosPolicy o) {
        String policy = "DurabilityQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.kind != DurabilityQosPolicyKind.VOLATILE_DURABILITY_QOS && o.kind != DurabilityQosPolicyKind.TRANSIENT_LOCAL_DURABILITY_QOS && o.kind != DurabilityQosPolicyKind.TRANSIENT_DURABILITY_QOS && o.kind != DurabilityQosPolicyKind.PERSISTENT_DURABILITY_QOS) {
            result = 3;
            ReportStack.report(result, policy + ".kind is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(DurabilityServiceQosPolicy o) {
        String policy = "DurabilityServiceQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.history_kind == null) {
            result = 3;
            ReportStack.report(result, policy + ".history_kind 'null' is invalid.");
        } else if (o.history_kind.value() != HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS.value() && o.history_kind.value() != HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS.value()) {
            result = 3;
            ReportStack.report(result, policy + ".history_kind is invalid.");
        } else if (o.history_kind.value() == HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS.value() && o.history_depth <= 0) {
            result = 3;
            ReportStack.report(result, policy + ".history_depth '" + o.history_depth + "' is invalid.");
        } else {
            result = Utilities.checkDuration(o.service_cleanup_delay);
            if (result == 0) {
                if (o.max_samples < 0 && o.max_samples != -1) {
                    result = 3;
                    ReportStack.report(result, policy + ".max_samples '" + o.max_samples + "' is invalid.");
                } else if (o.max_instances < 0 && o.max_instances != -1) {
                    result = 3;
                    ReportStack.report(result, policy + ".max_instances '" + o.max_instances + "' is invalid.");
                } else if (o.max_samples_per_instance < 0 && o.max_samples_per_instance != -1) {
                    result = 3;
                    ReportStack.report(result, policy + ".max_samples_per_instance '" + o.max_samples_per_instance + "' is invalid.");
                } else if (o.history_depth > o.max_samples_per_instance && o.max_samples_per_instance != -1) {
                    result = 8;
                    ReportStack.report(result, policy + ".history_depth is greater than " + policy + ".max_samples_per_instance.");
                }
            }
        }
        return result;
    }

    protected static int checkPolicy(DeadlineQosPolicy o) {
        String policy = "DeadlineQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else {
            result = Utilities.checkDuration(o.period);
        }
        return result;
    }

    protected static int checkPolicy(LatencyBudgetQosPolicy o) {
        String policy = "LatencyBudgetQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else {
            result = Utilities.checkDuration(o.duration);
        }
        return result;
    }

    protected static int checkPolicy(LivelinessQosPolicy o) {
        String policy = "LivelinessQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.kind != LivelinessQosPolicyKind.AUTOMATIC_LIVELINESS_QOS && o.kind != LivelinessQosPolicyKind.MANUAL_BY_PARTICIPANT_LIVELINESS_QOS && o.kind != LivelinessQosPolicyKind.MANUAL_BY_TOPIC_LIVELINESS_QOS) {
            result = 3;
            ReportStack.report(result, policy + ".kind is invalid.");
        } else {
            result = Utilities.checkDuration(o.lease_duration);
        }
        return result;
    }

    protected static int checkPolicy(ReliabilityQosPolicy o) {
        String policy = "ReliabilityQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.kind == null) {
            result = 3;
            ReportStack.report(result, policy + ".kind 'null' is invalid.");
        } else if (o.synchronous) {
            result = Utilities.checkDuration(o.max_blocking_time);
        }
        return result;
    }

    protected static int checkPolicy(DestinationOrderQosPolicy o) {
        String policy = "DestinationOrderQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.kind != DestinationOrderQosPolicyKind.BY_RECEPTION_TIMESTAMP_DESTINATIONORDER_QOS && o.kind != DestinationOrderQosPolicyKind.BY_SOURCE_TIMESTAMP_DESTINATIONORDER_QOS) {
            result = 3;
            ReportStack.report(result, policy + ".kind is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(OwnershipQosPolicy o) {
        String policy = "OwnershipQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.kind != OwnershipQosPolicyKind.SHARED_OWNERSHIP_QOS && o.kind != OwnershipQosPolicyKind.EXCLUSIVE_OWNERSHIP_QOS) {
            result = 3;
            ReportStack.report(result, policy + ".kind is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(HistoryQosPolicy o) {
        String policy = "HistoryQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.kind == HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS) {
            if (o.depth <= 0) {
                result = 3;
                ReportStack.report(result, policy + ".depth '" + o.depth + "' is invalid.");
            }
        } else if (o.kind != HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS) {
            result = 3;
            ReportStack.report(result, policy + ".kind is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(ResourceLimitsQosPolicy o) {
        String policy = "ResourceLimitsQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.max_samples < 0 && o.max_samples != -1) {
            result = 3;
            ReportStack.report(result, policy + ".max_samples '" + o.max_samples + "' is invalid.");
        } else if (o.max_instances < 0 && o.max_instances != -1) {
            result = 3;
            ReportStack.report(result, policy + ".max_instances '" + o.max_instances + "' is invalid.");
        } else if (o.max_samples_per_instance < 0 && o.max_samples_per_instance != -1) {
            result = 3;
            ReportStack.report(result, policy + ".max_samples_per_instance '" + o.max_samples_per_instance + "' is invalid.");
        } else if (o.max_samples != -1 && o.max_samples_per_instance != -1 && o.max_samples < o.max_samples_per_instance) {
            result = 3;
            ReportStack.report(result, policy + ".max_samples(" + o.max_samples + ") < " + policy + ".max_samples_per_instance(" + o.max_samples_per_instance + ") is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(TransportPriorityQosPolicy o) {
        String policy = "TransportPriorityQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(LifespanQosPolicy o) {
        String policy = "LifespanQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else {
            result = Utilities.checkDuration(o.duration);
        }
        return result;
    }

    protected static int checkPolicy(OwnershipStrengthQosPolicy o) {
        String policy = "OwnershipStrengthQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(WriterDataLifecycleQosPolicy o) {
        String policy = "WriterDataLifecycleQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(TimeBasedFilterQosPolicy o) {
        String policy = "TimeBasedFilterQosPolicy";
        int result = 0;
        if (o == null) {
            result = 0;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else {
            result = Utilities.checkDuration(o.minimum_separation);
        }
        return result;
    }

    protected static int checkPolicy(InvalidSampleVisibilityQosPolicy o) {
        String policy = "InvalidSampleVisibilityQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.kind == InvalidSampleVisibilityQosPolicyKind.ALL_INVALID_SAMPLES) {
            result = 2;
            ReportStack.report(result, policy + ".kind 'ALL_INVALID_SAMPLES' is unsupported.");
        } else if (o.kind != InvalidSampleVisibilityQosPolicyKind.NO_INVALID_SAMPLES && o.kind != InvalidSampleVisibilityQosPolicyKind.MINIMUM_INVALID_SAMPLES) {
            result = 3;
            ReportStack.report(result, policy + ".kind is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(ReaderDataLifecycleQosPolicy o) {
        String policy = "ReaderDataLifecycleQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else {
            result = Utilities.checkDuration(o.autopurge_nowriter_samples_delay);
            if (result == 0 && (result = Utilities.checkDuration(o.autopurge_disposed_samples_delay)) == 0 && (result = Utilities.checkPolicy(o.invalid_sample_visibility)) == 0 && !o.enable_invalid_samples) {
                ReportStack.deprecated("DataReaderQos.ReaderDataLifecycle.enable_invalid_samples is deprecated and will be replaced by DataReaderQos.ReaderDataLifecycle.invalid_sample_visibility.");
                if (o.invalid_sample_visibility.kind != InvalidSampleVisibilityQosPolicyKind.MINIMUM_INVALID_SAMPLES) {
                    result = 8;
                    ReportStack.report(result, policy + " invalid, " + policy + ".enable_invalid_samples inconsistent with " + policy + ".invalid_sample_visibility.");
                }
            }
        }
        return result;
    }

    protected static int checkPolicy(ShareQosPolicy o) {
        String policy = "ShareQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.enable && o.name == null) {
            result = 3;
            ReportStack.report(result, policy + ".name 'null' is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(ReaderLifespanQosPolicy o) {
        String policy = "ReaderLifespanQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.use_lifespan) {
            result = Utilities.checkDuration(o.duration);
        }
        return result;
    }

    protected static int checkPolicy(SubscriptionKeyQosPolicy o) {
        String policy = "SubscriptionKeyQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.use_key_list && o.key_list == null) {
            result = 3;
            ReportStack.report(result, policy + ".key_list 'null' is invalid.");
        }
        return result;
    }

    protected static int checkPolicy(ViewKeyQosPolicy o) {
        String policy = "ViewKeyQosPolicy";
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, policy + " 'null' is invalid.");
        } else if (o.use_key_list && o.key_list == null) {
            result = 3;
            ReportStack.report(result, policy + ".key_list 'null' is invalid.");
        }
        return result;
    }

    protected static int checkPolicyConsistency(HistoryQosPolicy history, ResourceLimitsQosPolicy resource_limits) {
        int result = 0;
        if (history == null) {
            result = 3;
            ReportStack.report(result, "HistoryQosPolicy 'null' is invalid.");
        } else if (resource_limits == null) {
            result = 3;
            ReportStack.report(result, "ResourceLimitsQosPolicy 'null' is invalid.");
        } else if (history.kind == HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS && resource_limits.max_samples_per_instance != -1 && history.depth > resource_limits.max_samples_per_instance) {
            result = 8;
            ReportStack.report(result, "HistoryQosPolicy.depth is greater than ResourceLimitsQosPolicy.max_samples_per_instance.");
        }
        return result;
    }

    protected static int checkPolicyConsistency(DeadlineQosPolicy deadline, TimeBasedFilterQosPolicy time_based_filter) {
        int result = 0;
        if (deadline == null) {
            result = 3;
            ReportStack.report(result, "DeadlineQosPolicy 'null' is invalid.");
        } else if (time_based_filter == null) {
            result = 3;
            ReportStack.report(result, "TimeBasedFilterQosPolicy 'null' is invalid.");
        } else if (deadline.period.sec < time_based_filter.minimum_separation.sec || deadline.period.sec == time_based_filter.minimum_separation.sec && deadline.period.nanosec < time_based_filter.minimum_separation.nanosec) {
            result = 8;
            ReportStack.report(result, "DeadlineQosPolicy.period is less than TimeBasedFilterQosPolicy.separation");
        }
        return result;
    }

    protected static int checkQos(DomainParticipantFactoryQos o) {
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, "DomainParticipantFactoryQos 'null' is invalid.");
        } else if (o != PARTICIPANTFACTORY_QOS_DEFAULT.value) {
            result = Utilities.checkPolicy(o.entity_factory);
        }
        return result;
    }

    protected static int checkQos(DomainParticipantQos o) {
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, "DomainParticipantQos 'null' is invalid.");
        } else if (o != PARTICIPANT_QOS_DEFAULT.value && (result = Utilities.checkPolicy(o.user_data)) == 0 && (result = Utilities.checkPolicy(o.entity_factory)) == 0 && (result = Utilities.checkPolicy(o.watchdog_scheduling)) == 0) {
            result = Utilities.checkPolicy(o.listener_scheduling);
        }
        return result;
    }

    protected static int checkQos(TopicQos o) {
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, "TopicQos 'null' is invalid.");
        } else if (o != TOPIC_QOS_DEFAULT.value && (result = Utilities.checkPolicy(o.topic_data)) == 0 && (result = Utilities.checkPolicy(o.durability)) == 0 && (result = Utilities.checkPolicy(o.durability_service)) == 0 && (result = Utilities.checkPolicy(o.deadline)) == 0 && (result = Utilities.checkPolicy(o.latency_budget)) == 0 && (result = Utilities.checkPolicy(o.liveliness)) == 0 && (result = Utilities.checkPolicy(o.reliability)) == 0 && (result = Utilities.checkPolicy(o.destination_order)) == 0 && (result = Utilities.checkPolicy(o.history)) == 0 && (result = Utilities.checkPolicy(o.resource_limits)) == 0 && (result = Utilities.checkPolicy(o.transport_priority)) == 0 && (result = Utilities.checkPolicy(o.lifespan)) == 0 && (result = Utilities.checkPolicy(o.ownership)) == 0) {
            result = Utilities.checkPolicyConsistency(o.history, o.resource_limits);
        }
        return result;
    }

    protected static int checkQos(PublisherQos o) {
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, "PublisherQos 'null' is invalid.");
        } else if (o != PUBLISHER_QOS_DEFAULT.value && (result = Utilities.checkPolicy(o.presentation)) == 0 && (result = Utilities.checkPolicy(o.partition)) == 0 && (result = Utilities.checkPolicy(o.group_data)) == 0) {
            result = Utilities.checkPolicy(o.entity_factory);
        }
        return result;
    }

    protected static int checkQos(SubscriberQos o) {
        int result = 0;
        if (o == null) {
            result = 0;
            ReportStack.report(result, "SubscriberQos 'null' is invalid.");
        } else if (o != SUBSCRIBER_QOS_DEFAULT.value && (result = Utilities.checkPolicy(o.presentation)) == 0 && (result = Utilities.checkPolicy(o.partition)) == 0 && (result = Utilities.checkPolicy(o.group_data)) == 0 && (result = Utilities.checkPolicy(o.share)) == 0) {
            result = Utilities.checkPolicy(o.entity_factory);
        }
        return result;
    }

    protected static int checkQos(DataWriterQos o) {
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, "DataWriterQos 'null' is invalid.");
        } else if (o != DATAWRITER_QOS_DEFAULT.value && o != DATAWRITER_QOS_USE_TOPIC_QOS.value && (result = Utilities.checkPolicy(o.durability)) == 0 && (result = Utilities.checkPolicy(o.deadline)) == 0 && (result = Utilities.checkPolicy(o.latency_budget)) == 0 && (result = Utilities.checkPolicy(o.liveliness)) == 0 && (result = Utilities.checkPolicy(o.reliability)) == 0 && (result = Utilities.checkPolicy(o.destination_order)) == 0 && (result = Utilities.checkPolicy(o.history)) == 0 && (result = Utilities.checkPolicy(o.resource_limits)) == 0 && (result = Utilities.checkPolicy(o.transport_priority)) == 0 && (result = Utilities.checkPolicy(o.lifespan)) == 0 && (result = Utilities.checkPolicy(o.user_data)) == 0 && (result = Utilities.checkPolicy(o.ownership)) == 0 && (result = Utilities.checkPolicy(o.ownership_strength)) == 0 && (result = Utilities.checkPolicy(o.writer_data_lifecycle)) == 0) {
            result = Utilities.checkPolicyConsistency(o.history, o.resource_limits);
        }
        return result;
    }

    protected static int checkQos(DataReaderQos o) {
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, "DataReaderQos 'null' is invalid.");
        } else if (o != DATAREADER_QOS_DEFAULT.value && o != DATAREADER_QOS_USE_TOPIC_QOS.value && (result = Utilities.checkPolicy(o.durability)) == 0 && (result = Utilities.checkPolicy(o.deadline)) == 0 && (result = Utilities.checkPolicy(o.latency_budget)) == 0 && (result = Utilities.checkPolicy(o.liveliness)) == 0 && (result = Utilities.checkPolicy(o.reliability)) == 0 && (result = Utilities.checkPolicy(o.destination_order)) == 0 && (result = Utilities.checkPolicy(o.history)) == 0 && (result = Utilities.checkPolicy(o.resource_limits)) == 0 && (result = Utilities.checkPolicy(o.user_data)) == 0 && (result = Utilities.checkPolicy(o.ownership)) == 0 && (result = Utilities.checkPolicy(o.time_based_filter)) == 0 && (result = Utilities.checkPolicy(o.reader_data_lifecycle)) == 0 && (result = Utilities.checkPolicy(o.subscription_keys)) == 0 && (result = Utilities.checkPolicy(o.reader_lifespan)) == 0 && (result = Utilities.checkPolicy(o.share)) == 0 && (result = Utilities.checkPolicyConsistency(o.history, o.resource_limits)) == 0) {
            result = Utilities.checkPolicyConsistency(o.deadline, o.time_based_filter);
        }
        return result;
    }

    protected static int checkQos(DataReaderViewQos o) {
        int result = 0;
        if (o == null) {
            result = 3;
            ReportStack.report(result, "DataReaderViewQos 'null' is invalid.");
        } else if (o != DATAREADERVIEW_QOS_DEFAULT.value) {
            result = Utilities.checkPolicy(o.view_keys);
        }
        return result;
    }

    private Utilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object deepCopy(Object oldObj) {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(oldObj);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bin);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            System.out.println("Exception in Utilities.deepCopy = " + e + "Object = " + oldObj);
            Object var4_6 = null;
            return var4_6;
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception e) {
                System.out.println("Exception in Utilities.deepCopy = " + e);
            }
        }
    }

    public static RuntimeException createException(int errorCode, String errorMessage) {
        BAD_PARAM exc = null;
        switch (errorCode) {
            case 0: {
                exc = new BAD_PARAM(errorMessage);
                break;
            }
            case 1: {
                exc = new NO_MEMORY(errorMessage);
                break;
            }
            case 2: {
                exc = new MARSHAL(errorMessage);
                break;
            }
            case 3: {
                exc = new BAD_OPERATION(errorMessage);
                break;
            }
            default: {
                assert (false) : "Unknown error code.";
                break;
            }
        }
        return exc;
    }

    protected static int checkSampleStateMask(int sample_states) {
        int result = 0;
        int mask = 3;
        if (sample_states != 65535 && ((sample_states & mask) == 0 || (sample_states & ~mask) > 0)) {
            result = 3;
            ReportStack.report(result, "SampleStateMask '" + Integer.toString(sample_states, 2) + "' is invalid.");
        }
        return result;
    }

    protected static int checkViewStateMask(int view_states) {
        int result = 0;
        int mask = 3;
        if (view_states != 65535 && ((view_states & mask) == 0 || (view_states & ~mask) > 0)) {
            result = 3;
            ReportStack.report(result, "ViewStateMask '" + Integer.toString(view_states, 2) + "' is invalid.");
        }
        return result;
    }

    protected static int checkInstanceStateMask(int instance_states) {
        int result = 0;
        int mask = 7;
        if (instance_states != 65535 && ((instance_states & mask) == 0 || (instance_states & ~mask) > 0)) {
            result = 3;
            ReportStack.report(result, "InstanceStateMask '" + Integer.toString(instance_states, 2) + "' is invalid.");
        }
        return result;
    }
}

