import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.subsystem.comcam.filterchanger.ComCamFilterChanger;
import org.lsst.ccs.subsystem.comcam.filterchanger.NanotecPD4NDevice;
import org.lsst.ccs.subsystem.comcam.filterchanger.MotronaIV251Device;
import org.lsst.ccs.subsystem.comcam.filterchanger.alerts.ComCamFCAlerts;

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;

CCSBuilder builder = ["comcam-fcs"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()

Class nanotecClass = Class.forName("org.lsst.ccs.subsystem.comcam.filterchanger.NanotecPD4NDevice");
Class motronaClass = Class.forName("org.lsst.ccs.subsystem.comcam.filterchanger.MotronaIV251Device");

builder.fcs (ComCamFilterChanger)
{
    AlarmMotorTemp (Alarm, description:"Motor over-temperatur", 
                    eventParm:ComCamFCAlerts.MOTOR_OVERTEMP.ordinal())

    StepperMotor(nanotecClass, devcId:"/dev/ttyUSB0",
        iPhase:50, iPhaseStill:25, stepMode:2, backOff:false,
        reverseClearance:17, rampType:0, quickRamp:3000,
        stepFreq:1000, minStepFreq:400, accelRamp:1000, brakeRamp:1000,
        maxJerkAccel:1, maxJerkBrake:0)
    {
        MotorTemperature (Channel, description:"motor temperature, degrees C",
                          devcName:"StepperMotor", type:"TEMPERATURE",
                          format:"%.2f", checkLo:"none", checkHi:"alarm",
                          limitHi:60.0, dbandHi:15.0, alarmHi:"AlarmMotorTemp")

        MotorEncoder (Channel, description:"motor encoder reading in steps",
                      devcName:"StepperMotor", type:"READ_ENCODER",
                      format:"%.0f", checkLo:"none", checkHi:"none")
    }

    LinearEncoder(motronaClass, devcId:"/dev/ttyUSB1")
    {
        LinearPosition(Channel, 
                       description:"linear encoder value, 5-micron unit",
                       devcName:"LinearEncoder", type:"POSITION",
                      format:"%.0f", checkLo:"none", checkHi:"none")
    }

}
