/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.PIController;
import org.lsst.ccs.subsystem.utility.BfrDevice;
import org.lsst.ccs.subsystem.utility.PurgeMaq20Device;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class VpcPIControl
implements HasLifecycle {
    private static final String PIC = "Pic";
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskServices;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PurgeMaq20Device maqDevc;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private BfrDevice bfrDevc;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private Double gain = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private Double timeConst = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private Double smoothTime = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private Double awGain = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private Double baseDuty = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private Double tolerance = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private double minInput = -10.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private double maxInput = 10.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private double minOutput = -500.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private Double maxOutput = 500.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private Integer updateTime = Integer.MAX_VALUE;
    private String[] refTempChans;
    private String[] ctrlTempChans;
    private double coolCapacity = 220.0;
    private double heatCapacity = 150.0;
    private final List<Channel> refTempChanList = new ArrayList<Channel>();
    private final List<Channel> ctrlTempChanList = new ArrayList<Channel>();
    private static final Logger LOG = Logger.getLogger(VpcPIControl.class.getName());
    private PIController pic;
    private double lastPower;
    private boolean active = false;
    private double setTemp;
    private boolean loopFailed = false;
    private int numHeaters = 0;
    private long lastLoopTime;

    public void build() {
        AgentPeriodicTask apt = new AgentPeriodicTask("vpc-loop-" + this.name, () -> this.iterateLoop()).withPeriod(Duration.ofMillis(500L));
        this.periodicTaskServices.scheduleAgentPeriodicTask(apt);
    }

    public void init() {
        Channel cmpt;
        if (this.maqDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"PurgeMaq20Device component", (String)"is missing");
        }
        if (this.bfrDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"BfrDevice component", (String)"is missing");
        }
        if (this.refTempChans == null || this.refTempChans.length == 0) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"refTempChans", (String)"is missing or empty");
        } else {
            for (String cName : this.refTempChans) {
                cmpt = this.allChannels.get(cName);
                if (cmpt != null) {
                    this.refTempChanList.add(cmpt);
                    continue;
                }
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"refTempChans", (String)"contains non-Channel item");
            }
        }
        if (this.ctrlTempChans == null || this.ctrlTempChans.length == 0) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"ctrlTempChans", (String)"is missing or empty");
        } else {
            for (String cName : this.ctrlTempChans) {
                cmpt = this.allChannels.get(cName);
                if (cmpt != null) {
                    this.ctrlTempChanList.add(cmpt);
                    continue;
                }
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"ctrlTempChans", (String)"contains non-Channel item");
            }
        }
        if (this.gain == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"gain", (String)"is missing");
        }
        if (this.timeConst.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"timeConst", (String)"is missing");
        }
        if (this.smoothTime.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"smoothTime", (String)"is missing");
        }
        if (this.awGain.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"awGain", (String)"is missing");
        }
        if (this.baseDuty.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"baseDuty", (String)"is missing");
        }
        if (this.tolerance.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tolerance", (String)"is missing");
        }
        if (this.updateTime == Integer.MAX_VALUE) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"updateTime", (String)"is missing");
        }
        this.pic = new PIController(this.gain.doubleValue(), this.timeConst.doubleValue());
        this.pic.setSmoothTime(this.smoothTime.doubleValue());
        this.pic.setAwGain(this.awGain.doubleValue());
        this.pic.setBaseOutput(this.baseDuty.doubleValue());
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minOutput, this.maxOutput.doubleValue());
        this.pic.setTolerance(this.tolerance.doubleValue());
    }

    public void postStart() {
        Boolean heater1On = this.bfrDevc.isSwitchOn(0);
        Boolean heater2On = this.bfrDevc.isSwitchOn(1);
        if (heater1On == Boolean.TRUE && heater2On == Boolean.TRUE) {
            this.numHeaters = 2;
        } else {
            if (heater2On == Boolean.TRUE) {
                this.bfrDevc.switchOff(1);
                this.bfrDevc.switchOn(0);
                heater1On = true;
            }
            this.numHeaters = heater1On == Boolean.TRUE ? 1 : 0;
        }
    }

    public void setPower(double power) {
        if (this.numHeaters > 0 && power < -((double)this.numHeaters + 0.5) * this.heatCapacity) {
            this.bfrDevc.switchOff(this.numHeaters == 1 ? 0 : 1);
            --this.numHeaters;
        } else if (this.numHeaters < 2 && power > (double)this.numHeaters * this.heatCapacity) {
            this.bfrDevc.switchOn(this.numHeaters == 0 ? 0 : 1);
            ++this.numHeaters;
        }
        try {
            this.maqDevc.setVpcValve((-power + (double)this.numHeaters * this.heatCapacity) / this.coolCapacity);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error setting VPC valve position: {0}", ex.getMessage());
        }
    }

    public void setTemperature(double temp) throws UtilityException {
        this.setTemp = temp;
        this.pic.setSetpoint(this.setTemp);
    }

    public double getTemperature() {
        return this.setTemp;
    }

    public void setGain(double gain) throws UtilityException {
        this.gain = gain;
        if (this.pic != null) {
            this.pic.setPID(gain, this.timeConst.doubleValue());
        }
    }

    public double getGain() {
        return this.gain;
    }

    public void setTimeConstant(double time) throws UtilityException {
        this.timeConst = time;
        this.pic.setPID(this.gain.doubleValue(), this.timeConst.doubleValue());
    }

    public double getTimeConstant() {
        return this.timeConst;
    }

    public void startLoop(double power) throws UtilityException {
        if (this.active) {
            return;
        }
        this.lastPower = power;
        this.startLoop();
    }

    public void startLoop() throws UtilityException {
        if (this.active) {
            return;
        }
        this.pic.reset();
        this.pic.setIntegral(this.lastPower - this.baseDuty);
        this.active = true;
    }

    public void stopLoop() throws UtilityException {
        if (!this.active) {
            return;
        }
        this.active = false;
    }

    public boolean isLoopActive() {
        return this.active;
    }

    public void reset() throws UtilityException {
        this.pic.reset();
    }

    private void iterateLoop() {
        double value;
        if (!this.active) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time < this.lastLoopTime + (long)this.updateTime.intValue()) {
            return;
        }
        this.lastLoopTime = time;
        double refTemp = 0.0;
        double ctrlTemp = 0.0;
        int count = 0;
        for (Channel tempChan : this.refTempChanList) {
            value = tempChan.getValue();
            if (Double.isNaN(value)) continue;
            refTemp += value;
            ++count;
        }
        if (count > 0) {
            refTemp /= (double)count;
        } else {
            if (!this.loopFailed) {
                LOG.severe("Control loop iteration failed: no valid reference temperature values available");
                this.loopFailed = true;
            }
            return;
        }
        count = 0;
        for (Channel tempChan : this.ctrlTempChanList) {
            value = tempChan.getValue();
            if (Double.isNaN(value)) continue;
            ctrlTemp += value;
            ++count;
        }
        if (count <= 0) {
            if (!this.loopFailed) {
                LOG.severe("Control loop iteration failed: no valid control temperature values available");
                this.loopFailed = true;
            }
            return;
        }
        this.lastPower = this.pic.performPI(new double[]{(ctrlTemp /= (double)count) - refTemp}, (double)time / 1000.0);
        this.setPower(this.lastPower);
        this.loopFailed = false;
    }
}

