/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.ocsbridge.sim.Filter;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.utilities.structs.Pair;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;

public class OCSStateChangeToEventConverter {
    private final Map<Pair<Class<? extends Enum>, Class<? extends Enum>>, Class<? extends CameraEvent>> oldStateNewStateMap = new HashMap<Pair<Class<? extends Enum>, Class<? extends Enum>>, Class<? extends CameraEvent>>();

    public OCSStateChangeToEventConverter() {
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)Shutter.ShutterState.CLOSED, (Object)Shutter.ShutterState.OPENING), StartShutterOpenEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)Shutter.ShutterState.OPENING, (Object)Shutter.ShutterState.OPEN), EndShutterOpenEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)Shutter.ShutterState.CLOSED, (Object)Shutter.ShutterState.OPEN), EndShutterOpenEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)Shutter.ShutterState.OPEN, (Object)Shutter.ShutterState.CLOSING), StartShutterCloseEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)Shutter.ShutterState.OPEN, (Object)Shutter.ShutterState.CLOSED), EndShutterCloseEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)Shutter.ShutterState.CLOSING, (Object)Shutter.ShutterState.CLOSED), EndShutterCloseEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)Filter.FilterState.UNLOADED, (Object)Filter.FilterState.ROTATING), StartRotateCarouselEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)Filter.FilterState.ROTATING, (Object)Filter.FilterState.UNLOADED), EndRotateCarouselEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)Filter.FilterState.UNLOADED, (Object)Filter.FilterState.LOADING), StartLoadFilterEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)Filter.FilterState.LOADING, (Object)Filter.FilterState.LOADED), EndLoadFilterEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)Filter.FilterState.LOADED, (Object)Filter.FilterState.UNLOADING), StartUnloadFilterEvent.class);
        this.oldStateNewStateMap.put((Pair<Class<? extends Enum>, Class<? extends Enum>>)new Pair((Object)Filter.FilterState.UNLOADING, (Object)Filter.FilterState.UNLOADED), EndUnloadFilterEvent.class);
    }

    public CameraEvent convert(Enum oldState, Enum newState, int eventPriority) {
        if (oldState == null || newState == null) {
            return null;
        }
        Pair statePair = new Pair((Object)oldState, (Object)newState);
        Class<? extends CameraEvent> aa = this.oldStateNewStateMap.get(statePair);
        if (aa == null) {
            return null;
        }
        try {
            Constructor<? extends CameraEvent> bbc = this.oldStateNewStateMap.get(statePair).getConstructor(Integer.TYPE);
            return bbc.newInstance(eventPriority);
        }
        catch (ReflectiveOperationException x) {
            throw new RuntimeException("Error converting state change : " + statePair, x);
        }
    }
}

