/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.sal.cccamera.event.FocalPlaneHardwareIdSettingsAppliedEvent;

public class FocalPlaneHardwareIdConverter {
    Pattern sensorPattern = Pattern.compile("(R..)/(Reb.)/(S..)/(\\w+)");
    Pattern rebPattern = Pattern.compile("(R..)/(Reb.)(?:_hardware)?/(\\w+)");
    Pattern raftPattern = Pattern.compile("(R..)/(.+)");

    public FocalPlaneHardwareIdSettingsAppliedEvent convert(ConfigurationInfo data) {
        TreeSet<String> ccdLocations = new TreeSet<String>();
        TreeSet<String> rebLocations = new TreeSet<String>();
        TreeSet<String> raftLocations = new TreeSet<String>();
        HashMap ccdNames = new HashMap();
        HashMap manSerNums = new HashMap();
        HashMap rebNames = new HashMap();
        HashMap raftNames = new HashMap();
        Map hardwareMap = data.getCurrentValuesForCategory("HardwareId");
        for (Map.Entry entry : hardwareMap.entrySet()) {
            String type;
            Matcher sensorMatcher = this.sensorPattern.matcher((CharSequence)entry.getKey());
            Matcher rebMatcher = this.rebPattern.matcher((CharSequence)entry.getKey());
            Matcher raftMatcher = this.raftPattern.matcher((CharSequence)entry.getKey());
            if (sensorMatcher.matches()) {
                String ccdName = sensorMatcher.group(1) + sensorMatcher.group(3);
                ccdLocations.add(ccdName);
                type = sensorMatcher.group(4);
                if ("name".equals(type)) {
                    ccdNames.put(ccdName, entry.getValue());
                    continue;
                }
                if (!"manSerNum".equals(type)) continue;
                manSerNums.put(ccdName, entry.getValue());
                continue;
            }
            if (rebMatcher.matches()) {
                String rebName = rebMatcher.group(1) + rebMatcher.group(2);
                rebLocations.add(rebName);
                type = rebMatcher.group(3);
                if (!"name".equals(type)) continue;
                rebNames.put(rebName, entry.getValue());
                continue;
            }
            if (!raftMatcher.matches()) continue;
            String raftName = raftMatcher.group(1);
            raftLocations.add(raftName);
            type = raftMatcher.group(2);
            if (!"name".equals(type)) continue;
            raftNames.put(raftName, entry.getValue());
        }
        return FocalPlaneHardwareIdSettingsAppliedEvent.builder().version(data.getConfigVersion("HardwareId").intValue()).ccdLocation(ccdLocations.stream().collect(FocalPlaneHardwareIdConverter.join())).ccdLSSTNum(ccdLocations.stream().map(k -> (String)ccdNames.get(k)).collect(FocalPlaneHardwareIdConverter.join())).ccdManSerNum(ccdLocations.stream().map(k -> FocalPlaneHardwareIdConverter.get(manSerNums, k)).collect(FocalPlaneHardwareIdConverter.join())).rebLocation(rebLocations.stream().collect(FocalPlaneHardwareIdConverter.join())).rebLSSTName(rebLocations.stream().map(name -> FocalPlaneHardwareIdConverter.get(rebNames, name)).collect(FocalPlaneHardwareIdConverter.join())).rebSerialNumber("Will be removed in xml 5.2").build();
    }

    private static <K> String get(Map<K, String> map, K name) {
        return FocalPlaneHardwareIdConverter.get(map, name, "Unknown");
    }

    private static <K, V> V get(Map<K, V> map, K key, V defaultValue) {
        return map.getOrDefault(key, defaultValue);
    }

    private static Collector<CharSequence, ?, String> join() {
        return Collectors.joining(":");
    }
}

