/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;

public class MCMConfig {
    @ConfigurationParameter
    private boolean hasFilterChanger = true;
    @ConfigurationParameter
    private int maxImagesPerSequence = 10;
    @ConfigurationParameter
    private double minExposeTime = 1.0;
    @ConfigurationParameter
    private double maxExposeTime = 30.0;
    @ConfigurationParameter
    private String sequencerFile;
    @ConfigurationParameter
    private String fitsDir = "/tmp";
    @ConfigurationParameter
    private String raftsSubsystemName;
    @ConfigurationParameter
    private String focalPlaneSubsystemName;
    @ConfigurationParameter
    private String raftsConfig = "Limits: Rafts: RaftsLimits:";
    @ConfigurationParameter
    private String shutterSubsystemName;
    @ConfigurationParameter
    private Camera cameraType = Camera.MAIN_CAMERA;
    @ConfigurationParameter
    private Set<String> requiredKeywords = new HashSet<String>(Arrays.asList("imageType", "groupId"));
    @ConfigurationParameter
    private Set<String> allowedKeywords = new HashSet<String>(Arrays.asList("testType"));

    MCMConfig() {
    }

    public MCMConfig(Camera cameraType) {
        this.cameraType = cameraType;
    }

    public boolean hasFilterChanger() {
        return this.hasFilterChanger;
    }

    public String getSequencerFile() {
        return this.sequencerFile;
    }

    public String getFitsDir() {
        return this.fitsDir;
    }

    public String getRaftsSubsystemName() {
        return this.raftsSubsystemName;
    }

    public String getFocalPlaneSubsystemName() {
        return this.focalPlaneSubsystemName;
    }

    boolean hasFocalPlaneSubsystem() {
        return this.getFocalPlaneSubsystemName() != null && !this.getFocalPlaneSubsystemName().trim().isEmpty();
    }

    boolean hasRaftsSubsystem() {
        return this.getRaftsSubsystemName() != null && !this.getRaftsSubsystemName().trim().isEmpty();
    }

    public String getShutterSubsystemName() {
        return this.shutterSubsystemName;
    }

    public int getMaxImagesPerSequence() {
        return this.maxImagesPerSequence;
    }

    public double getMinExposeTime() {
        return this.minExposeTime;
    }

    public double getMaxExposeTime() {
        return this.maxExposeTime;
    }

    public Camera getCameraType() {
        return this.cameraType;
    }

    String getRaftsConfiguration() {
        return this.raftsConfig;
    }

    Set<String> getRequiredKeys() {
        return this.requiredKeywords;
    }

    Set<String> getAllowedKeys() {
        return new HashSet<String>(){
            {
                this.addAll(MCMConfig.this.requiredKeywords);
                this.addAll(MCMConfig.this.allowedKeywords);
            }
        };
    }

    public static MCMConfig createDefaultConfig() {
        return new MCMConfig();
    }

    public static enum Camera {
        MAIN_CAMERA,
        COMCAM,
        AUXTEL;

    }
}

