/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.util.List;
import org.lsst.ccs.rest.file.server.client.implementation.RestClient;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileSystem;
import org.lsst.ccs.rest.file.server.client.implementation.VersionedPathCheck;
import org.lsst.ccs.rest.file.server.client.implementation.unixlike.AbstractPath;
import org.lsst.ccs.web.rest.file.server.data.RestFileInfo;

class RestPath
extends AbstractPath {
    private final boolean isReadOnly;
    private final RestFileInfo presetInfo;
    private Boolean isVersionedFile;
    private RestFileSystem fileSystem;
    private String version;
    private String pathWithoutVersion;

    RestPath(RestFileSystem fileSystem, String path) {
        this(fileSystem, new VersionedPathCheck(path));
    }

    private RestPath(RestFileSystem fileSystem, VersionedPathCheck path) {
        super(fileSystem, path.getOriginalPath());
        this.version = path.getVersion();
        this.pathWithoutVersion = path.getPathWithVersionRemoved();
        this.fileSystem = fileSystem;
        this.isReadOnly = false;
        this.presetInfo = null;
    }

    RestPath(RestFileSystem fileSystem, boolean absolute, List<String> path) {
        this(fileSystem, RestPath.fullPath(path, absolute));
    }

    private static String fullPath(List<String> path, boolean absolute) {
        Object result = "";
        int count = 0;
        for (String p : path) {
            result = (String)result + p;
            if (++count >= path.size()) continue;
            result = (String)result + "/";
        }
        return absolute ? "/" + (String)result : result;
    }

    synchronized boolean isVersionedFile() throws IOException {
        if (this.isVersionedFile == null) {
            if (this.version != null) {
                this.isVersionedFile = true;
            } else {
                RestFileInfo info = this.getClient().getRestFileInfo(this);
                this.isVersionedFile = info.isVersionedFile();
            }
        }
        return this.isVersionedFile != null && this.isVersionedFile != false;
    }

    String getVersion() {
        return this.version;
    }

    String getRestPath() {
        return this.isAbsolute() ? this.pathWithoutVersion.substring(1) : this.pathWithoutVersion;
    }

    RestClient getClient() {
        return ((RestFileSystem)this.getFileSystem()).getClient();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public URI toUri() {
        return this.fileSystem.getURI(this.toAbsolutePath().toString().substring(1));
    }
}

