/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.basic;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.freehep.application.ApplicationEvent;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.application.studio.StudioListener;
import org.freehep.jas.JAS3FileOpener;
import org.freehep.jas.plugin.basic.FileHelper;
import org.freehep.jas.plugin.basic.FileOpenPreferences;
import org.freehep.jas.services.FileHandler;
import org.freehep.jas.services.PreferencesTopic;
import org.freehep.jas.services.TextEditorService;
import org.freehep.swing.AllSupportedFileFilter;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.openide.util.Lookup;
import org.xml.sax.SAXException;

public class FileOpener
extends Plugin
implements StudioListener,
ActionListener,
PreferencesTopic {
    private RecentFileList recentFiles = new RecentFileList("recentFiles");
    private RecentFilesMenu recentFilesMenu = new RecentFilesMenu("Recent Files", this.recentFiles);
    private FileHelper fileHelper;
    private boolean restoreLastDirectoryUsed;
    private String defaultDirectory;

    public void init() throws SAXException, IOException {
        Studio app = this.getApplication();
        this.recentFiles.load(app.getUserProperties());
        this.recentFilesMenu.setEnabled();
        app.getLookup().add((Object)this);
        XMLMenuBuilder builder = app.getXMLMenuBuilder();
        URL xml = this.getClass().getResource("FileOpener.menus");
        builder.build(xml);
        this.addMenu(this.recentFilesMenu, 100910L);
        app.getCommandTargetManager().add((CommandGroup)new Commands());
        app.getEventSender().addEventListener((StudioListener)this, ApplicationEvent.class);
        Object dropTarget = app;
        while (dropTarget.getParent() != null) {
            dropTarget = dropTarget.getParent();
        }
        this.addDropTargetFileOpener((Component)dropTarget);
        this.fileHelper = new FileHelper(JAS3FileOpener.class);
        this.fileHelper.addActionListener(this);
        this.fileHelper.start();
    }

    public void addDropTargetFileOpener(Component c) {
        new DropTarget(c, new FileDropper());
    }

    public void handleEvent(EventObject event) {
        if (event instanceof ApplicationEvent) {
            ApplicationEvent ae = (ApplicationEvent)event;
            if (ae.getID() == ApplicationEvent.INITIALIZATION_COMPLETE) {
                String[] files = ae.getApplication().getCommandLine().getArguments();
                for (int i = 0; i < files.length; ++i) {
                    try {
                        this.openFile(this.getFileHandlers(), new File(files[i]));
                        continue;
                    }
                    catch (Throwable x) {
                        x.printStackTrace();
                        this.getApplication().error("Could not open file: " + files[i], x);
                    }
                }
                String file = ae.getApplication().getCommandLine().getOption("open");
                if (file != null) {
                    try {
                        this.openFile(this.getFileHandlers(), new File(file));
                    }
                    catch (Throwable x) {
                        x.printStackTrace();
                        this.getApplication().error("Could not open file: " + file, x);
                    }
                }
            } else if (ae.getID() == ApplicationEvent.APPLICATION_EXITING) {
                this.fileHelper.stop();
                this.recentFiles.save(ae.getApplication().getUserProperties());
            }
        }
    }

    private Lookup.Result getFileHandlers() {
        Lookup.Template template = new Lookup.Template(FileHandler.class);
        return this.getApplication().getLookup().lookup(template);
    }

    private void openFile(Lookup.Result result, File file) throws IOException {
        ArrayList<Lookup.Item> acceptable = new ArrayList<Lookup.Item>();
        for (Lookup.Item item : result.allItems()) {
            FileHandler s = (FileHandler)item.getInstance();
            if (!s.accept(file)) continue;
            acceptable.add(item);
        }
        if (acceptable.size() == 1) {
            ((FileHandler)((Lookup.Item)acceptable.get(0)).getInstance()).openFile(file);
            this.recentFiles.add(file);
            this.recentFilesMenu.setEnabled();
        } else if (acceptable.size() > 1) {
            Object selectedValue = JOptionPane.showInputDialog((Component)this.getApplication(), "Select plugin to open file", "Select Plugin", 3, null, acceptable.toArray(), acceptable.get(0));
            if (selectedValue != null) {
                ((FileHandler)((Lookup.Item)selectedValue).getInstance()).openFile(file);
                this.recentFiles.add(file);
                this.recentFilesMenu.setEnabled();
            }
        } else {
            throw new IllegalArgumentException("No file handler found for " + file);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String fileName = e.getActionCommand();
        File f = new File(fileName);
        try {
            this.openFile(this.getFileHandlers(), f);
        }
        catch (IOException x) {
            this.getApplication().error("Error opening " + fileName, (Throwable)x);
        }
    }

    boolean isRestoreLastDirectoryUsed() {
        return PropertyUtilities.getBoolean((Properties)this.getApplication().getUserProperties(), (String)"fileOpener.restoreLastDirectoryUsed", (boolean)true);
    }

    void setRestoreLastDirectoryUsed(boolean restoreLastDirectoryUsed) {
        this.getApplication().getUserProperties().setProperty("fileOpener.restoreLastDirectoryUsed", String.valueOf(restoreLastDirectoryUsed));
    }

    String getDefaultDirectory() {
        return this.getApplication().getUserProperties().getProperty("fileOpener.defaultDirectory", "{user.home}");
    }

    void setDefaultDirectory(String defaultDirectory) {
        this.getApplication().getUserProperties().setProperty("fileOpener.defaultDirectory", defaultDirectory);
    }

    @Override
    public boolean apply(JComponent panel) {
        return ((FileOpenPreferences)panel).apply();
    }

    @Override
    public JComponent component() {
        return new FileOpenPreferences(this);
    }

    @Override
    public String[] path() {
        return "General/Files".split("/");
    }

    private class RecentFilesMenu
    extends JMenu
    implements ActionListener {
        private RecentFileList list;

        public RecentFilesMenu(String name, RecentFileList list) {
            super(name);
            this.list = list;
        }

        public final void setEnabled() {
            this.setEnabled(this.list.size() > 0);
        }

        @Override
        protected void fireMenuSelected() {
            Iterator iter = this.list.iterator();
            int i = 0;
            while (iter.hasNext()) {
                File file = (File)iter.next();
                JMenuItem item = new JMenuItem(String.valueOf(i) + " " + file.getAbsolutePath());
                item.setActionCommand(file.getAbsolutePath());
                item.setMnemonic(48 + (char)i);
                item.addActionListener(this);
                this.add(item);
                ++i;
            }
            super.fireMenuSelected();
        }

        @Override
        protected void fireMenuDeselected() {
            super.fireMenuDeselected();
            this.removeAll();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            File file = new File(item.getActionCommand());
            try {
                FileOpener.this.openFile(FileOpener.this.getFileHandlers(), file);
            }
            catch (Throwable x) {
                FileOpener.this.getApplication().error("Error opening " + file, x);
            }
        }
    }

    private static class RecentFileList {
        private List list = new LinkedList();
        private int maxLength = 8;
        private String key;

        RecentFileList(String key) {
            this.key = key;
        }

        void add(File file) {
            int pos = this.list.indexOf(file);
            if (pos == 0) {
                return;
            }
            if (pos > 0) {
                this.list.remove(pos);
                this.list.add(0, file);
            } else {
                this.list.add(0, file);
            }
            if (this.list.size() > this.maxLength) {
                ListIterator i = this.list.listIterator(this.maxLength);
                while (i.hasNext()) {
                    i.next();
                    i.remove();
                }
            }
        }

        void load(Properties props) {
            int len = PropertyUtilities.getInteger((Properties)props, (String)(this.key + "-length"), (int)0);
            for (int i = 0; i < len; ++i) {
                this.list.add(new File(props.getProperty(this.key + "-" + i)));
            }
        }

        void save(Properties props) {
            props.setProperty(this.key + "-length", String.valueOf(this.list.size()));
            int i = 0;
            for (File file : this.list) {
                props.put(this.key + "-" + i, file.getAbsolutePath());
                ++i;
            }
        }

        int size() {
            return this.list.size();
        }

        Iterator iterator() {
            return this.list.iterator();
        }
    }

    class FileDropper
    extends DropTargetAdapter {
        FileDropper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent e) {
            block11: {
                Lookup.Result result = FileOpener.this.getFileHandlers();
                DropTargetContext context = e.getDropTargetContext();
                try {
                    e.acceptDrop(3);
                    Transferable t = e.getTransferable();
                    DataFlavor uriList = new DataFlavor("text/uri-list; class=java.io.Reader; charset=Unicode");
                    if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        Object data = t.getTransferData(DataFlavor.javaFileListFlavor);
                        if (data instanceof List) {
                            List list = (List)data;
                            for (int k = 0; k < list.size(); ++k) {
                                Object dataLine = list.get(k);
                                if (!(dataLine instanceof File)) continue;
                                FileOpener.this.openFile(result, (File)dataLine);
                            }
                        }
                        context.dropComplete(true);
                        break block11;
                    }
                    if (t.isDataFlavorSupported(uriList)) {
                        try (BufferedReader reader = new BufferedReader(uriList.getReaderForText(t));){
                            String uri;
                            while ((uri = reader.readLine()) != null) {
                                FileOpener.this.openFile(result, new File(new URI(uri)));
                            }
                        }
                        context.dropComplete(true);
                        break block11;
                    }
                    context.dropComplete(false);
                    FileOpener.this.getApplication().error("Unsupported drop type");
                }
                catch (Exception ex) {
                    context.dropComplete(false);
                    FileOpener.this.getApplication().error("Error during Drag and Drop", (Throwable)ex);
                }
            }
        }
    }

    public class Commands
    extends CommandProcessor {
        public void onOpenFile() throws IOException {
            block9: {
                String last;
                Studio app = FileOpener.this.getApplication();
                String path = FileOpener.this.getDefaultDirectory();
                if (FileOpener.this.isRestoreLastDirectoryUsed() && (last = app.getUserProperties().getProperty("fileOpener.lastDirectoryUsed")) != null) {
                    path = last;
                }
                JFileChooser dlg = new JFileChooser(path);
                dlg.setDialogTitle("Open File...");
                AllSupportedFileFilter all = new AllSupportedFileFilter();
                Lookup.Result result = FileOpener.this.getFileHandlers();
                for (FileHandler s : result.allInstances()) {
                    FileFilter ff = s.getFileFilter();
                    all.add(ff);
                    dlg.addChoosableFileFilter(ff);
                }
                dlg.setFileFilter((FileFilter)all);
                if (dlg.showOpenDialog((Component)app) == 0) {
                    File f = dlg.getSelectedFile();
                    try {
                        try {
                            FileOpener.this.openFile(result, f);
                            app.getUserProperties().setProperty("fileOpener.lastDirectoryUsed", f.getParent());
                        }
                        catch (IllegalArgumentException t) {
                            Object[] options = new String[]{"Yes", "No, open with Text Editor", "Cancel"};
                            int rc = JOptionPane.showOptionDialog((Component)app, t.getMessage() + "\nSearch on web for plugin to support this file?", "Open File...", 1, 3, null, options, options[0]);
                            if (rc == 0) {
                                JOptionPane.showMessageDialog((Component)app, "Feature not implemented");
                                break block9;
                            }
                            if (rc != 1) break block9;
                            TextEditorService te = (TextEditorService)app.getLookup().lookup(TextEditorService.class);
                            if (te == null) {
                                app.error("No text editor installed");
                                break block9;
                            }
                            te.show(f, "text/plain");
                            app.getUserProperties().setProperty("fileOpener.lastDirectoryUsed", f.getParent());
                        }
                    }
                    catch (IOException x) {
                        app.error("Error opening file", (Throwable)x);
                    }
                }
            }
        }
    }
}

