/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.comcamvacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.LatchState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.PLCState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.comcamvacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.comcamvacuum.data.VacSysState;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;

public class ComCamVacControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    static final Font FONT = new Font("Tahoma", 1, 12);
    static final Color RED = new Color(175, 0, 0);
    static final Color GREEN = new Color(0, 175, 0);
    static final Color BLUE = new Color(0, 75, 175);
    static final Color PURPLE = new Color(175, 0, 175);
    static final int SWTP_PUMP = 0;
    static final int SWTP_VALVE = 1;
    static final int SWTP_CRYOTEL = 4;
    static final String[] switchNames = new String[9];
    static final int[] switchTypes;
    private static final String[] latchNames;
    private static final String[] conditionNames;
    private static final int sysStateWidth;
    private static final int plcStateWidth;
    private static final int switchStatusWidth;
    private static final int latchStatusWidth;
    private static final int condStatusWidth;
    private final CommandSender sender;
    private String subsys;
    private double mainPeriod = 5.0;
    private int switchMask = 0;
    private int latchMask = 0;
    private int conditionMask = 0;
    private final UiUtilities uiUtils;
    private final JPanel mainPanel = new JPanel();
    private final JPanel headPanel = new JPanel();
    private JLabel sysStateValue;
    private JLabel plcStateValue;
    private TextFieldX periodTextField;
    private final JLabel stateLabel = new JLabel("System State:  ");
    private final JLabel stateStatus = new JLabel("STOPPED");
    private final JPanel periodPanel = new JPanel();
    private final JLabel periodLabel = new JLabel("Update Period: ");
    private final JLabel periodUnitsLabel = new JLabel("sec");
    private final JPanel switchPanel = new JPanel();
    private final JLabel[] switchLabel = new JLabel[9];
    private final JLabel[] switchStatus = new JLabel[9];
    private final ButtonGroup[] switchBG = new ButtonGroup[9];
    private final JRadioButton[] switchOffRB = new JRadioButton[9];
    private final JRadioButton[] switchOnRB = new JRadioButton[9];
    private JPanel latchPanel;
    private final JLabel[] latchLabel = new JLabel[4];
    private final JLabel[] latchStatus = new JLabel[4];
    private final JButton[] latchResetBtn = new JButton[4];
    private JPanel conditionPanel;
    private final JLabel[] conditionLabel = new JLabel[5];
    private final JLabel[] conditionStatus = new JLabel[5];
    private final JButton[] conditionResetBtn = new JButton[5];
    private static final long serialVersionUID = 1L;

    public ComCamVacControlPanel(String subsys) {
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.sender = new CommandSender(subsys, (CommandSender.ReplyHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void setSubsystem(String name) {
        this.subsys = name;
    }

    private void initComponents() {
        int cond;
        JLabel label;
        this.sysStateValue = UiUtilities.newLabel((String)"X", (int)sysStateWidth);
        this.plcStateValue = UiUtilities.newLabel((String)"X", (int)plcStateWidth);
        this.periodTextField = this.uiUtils.newTextFieldX("00000.0", "U", 2);
        this.stateLabel.setFont(FONT);
        this.stateStatus.setFont(FONT);
        Dimension d = this.stateStatus.getPreferredSize();
        d.width = 150;
        this.stateStatus.setMinimumSize(d);
        this.stateStatus.setPreferredSize(d);
        this.periodLabel.setFont(FONT);
        d = this.periodTextField.getPreferredSize();
        d.width = 45;
        this.periodTextField.setMinimumSize(d);
        this.periodTextField.setPreferredSize(d);
        this.periodTextField.setHorizontalAlignment(0);
        this.periodTextField.setText("...");
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComCamVacControlPanel.this.setUpdatePeriod();
            }
        });
        this.periodUnitsLabel.setFont(FONT);
        for (int sw = 0; sw < 9; ++sw) {
            label = this.switchLabel[sw] = new JLabel(switchNames[sw]);
            label.setFont(FONT);
            d = label.getPreferredSize();
            d.width = 130;
            label.setMinimumSize(d);
            label.setPreferredSize(d);
            label = this.switchStatus[sw] = new JLabel("XXX");
            label.setFont(FONT);
            d = label.getPreferredSize();
            d.width = 80;
            label.setMinimumSize(d);
            label.setPreferredSize(d);
            int swType = switchTypes[sw];
            JRadioButton buttonOff = this.switchOffRB[sw] = new JRadioButton(swType == 0 || swType == 4 ? "Off" : "Shut");
            buttonOff.setFont(FONT);
            buttonOff.setFocusable(false);
            buttonOff.setName(Integer.toString(sw));
            buttonOff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    ComCamVacControlPanel.this.setSwitchOn(Integer.valueOf(name), false);
                }
            });
            JRadioButton buttonOn = null;
            if (switchTypes[sw] == 1) {
                this.switchLabel[sw].setForeground(Color.RED);
                buttonOn = this.switchOnRB[sw] = new JRadioButton("Open", true);
            } else {
                buttonOn = this.switchOnRB[sw] = new JRadioButton(swType == 0 || swType == 4 ? "On" : "Open");
            }
            buttonOn.setFont(FONT);
            buttonOn.setFocusable(false);
            buttonOn.setName(Integer.toString(sw));
            buttonOn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    int rbsw = Integer.valueOf(name);
                    if (ComCamVacControlPanel.this.switchOnRB[rbsw].isEnabled()) {
                        ComCamVacControlPanel.this.setSwitchOn(rbsw, true);
                    } else {
                        ComCamVacControlPanel.this.switchOnRB[rbsw].setEnabled(true);
                    }
                }
            });
            ButtonGroup bg = this.switchBG[sw] = new ButtonGroup();
            bg.add(buttonOff);
            bg.add(buttonOn);
        }
        for (cond = 0; cond < 4; ++cond) {
            this.latchLabel[cond] = UiUtilities.newLabel((String)(latchNames[cond] + ":"), (int)0);
            this.latchStatus[cond] = UiUtilities.newLabel((String)"X", (int)latchStatusWidth);
            this.latchResetBtn[cond] = this.uiUtils.newButton("Reset", "R" + cond, true);
            JButton button = this.latchResetBtn[cond];
            Insets i = button.getMargin();
            i.left -= 3;
            i.right -= 3;
            button.setMargin(i);
            d = button.getPreferredSize();
            button.setPreferredSize(d);
            button.setFont(UiConstants.FONT);
            button.setFocusable(false);
            button.setName(Integer.toString(cond));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JButton)evt.getSource()).getName();
                    ComCamVacControlPanel.this.clearLatch(Integer.valueOf(name));
                }
            });
        }
        for (cond = 0; cond < 5; ++cond) {
            label = this.conditionLabel[cond] = new JLabel(conditionNames[cond]);
            label.setFont(FONT);
            d = label.getPreferredSize();
            d.width = 170;
            label.setMinimumSize(d);
            label.setPreferredSize(d);
            label = this.conditionStatus[cond] = new JLabel("XXX");
            label.setFont(FONT);
            d = label.getPreferredSize();
            d.width = 80;
            label.setMinimumSize(d);
            label.setPreferredSize(d);
            JButton button = this.conditionResetBtn[cond] = new JButton("Reset");
            Insets i = button.getMargin();
            i.left -= 3;
            i.right -= 3;
            button.setMargin(i);
            d = button.getPreferredSize();
            d.height -= 9;
            button.setPreferredSize(d);
            button.setFont(FONT);
            button.setFocusable(false);
            button.setName(Integer.toString(cond));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JButton)evt.getSource()).getName();
                    ComCamVacControlPanel.this.clearCondition(Integer.valueOf(name));
                }
            });
        }
        this.periodPanel.add((Component)this.periodTextField);
        this.periodPanel.add(this.periodUnitsLabel);
        this.headPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 0, 5, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = 17;
        gbh.insets.left = 5;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"System State: ", (int)0), gbh);
        ++gbh.gridx;
        this.headPanel.add((Component)this.sysStateValue, gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"PLC State: ", (int)0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        this.headPanel.add((Component)this.plcStateValue, gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"Update Period: ", (int)0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        this.headPanel.add((Component)this.periodTextField, gbh);
        ++gbh.gridx;
        gbh.insets.right = 5;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"sec", (int)0), gbh);
        TitledBorder border = BorderFactory.createTitledBorder("Switches");
        border.setTitleJustification(2);
        this.switchPanel.setBorder(border);
        this.switchPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.gridx = 0;
        gbs.gridy = 0;
        gbs.insets.bottom = -8;
        this.switchPanel.add((Component)new JLabel(" "), gbs);
        this.latchPanel = UiUtilities.newBorderedPanel((String)"PLC Error Conditions");
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.gridx = 0;
        gbl.gridy = 0;
        gbl.insets.bottom = -8;
        this.latchPanel.add((Component)new JLabel(" "), gbl);
        this.conditionPanel = UiUtilities.newBorderedPanel((String)"PLC Running Conditions");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.bottom = -8;
        this.conditionPanel.add((Component)new JLabel(" "), gbc);
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(0, 0, 0, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.mainPanel.add((Component)this.headPanel, gbm);
        ++gbm.gridy;
        this.mainPanel.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        this.mainPanel.add((Component)this.latchPanel, gbm);
        ++gbm.gridy;
        this.mainPanel.add((Component)this.conditionPanel, gbm);
        this.add(this.mainPanel);
    }

    private void updateSwitchLayout(int switches) {
        for (int sw = 0; sw < 9; ++sw) {
            if ((this.switchMask & 1 << sw) == 0) continue;
            this.switchPanel.remove(this.switchLabel[sw]);
            this.switchPanel.remove(this.switchStatus[sw]);
            this.switchPanel.remove(this.switchOffRB[sw]);
            this.switchPanel.remove(this.switchOnRB[sw]);
        }
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 18;
        gbs.gridy = 0;
        gbs.ipady = 10;
        int colm = 0;
        for (int sw = 0; sw < 9; ++sw) {
            if ((switches & 1 << sw) == 0) continue;
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = 0;
            gbs.insets.left = colm == 0 ? 4 : 50;
            this.switchPanel.add((Component)this.switchLabel[sw], gbs);
            gbs.insets.left = 0;
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchStatus[sw], gbs);
            ++gbs.gridx;
            gbs.insets.top = -4;
            this.switchPanel.add((Component)this.switchOffRB[sw], gbs);
            ++gbs.gridx;
            gbs.insets.left = 6;
            gbs.insets.right = 3;
            this.switchPanel.add((Component)this.switchOnRB[sw], gbs);
            gbs.insets.right = 0;
            ++gbs.gridx;
            colm = (colm + 1) % 2;
        }
        this.switchMask = switches;
    }

    private void updateLatchLayout(int conditions) {
        for (int cond = 0; cond < 4; ++cond) {
            if ((this.latchMask & 1 << cond) == 0) continue;
            this.latchPanel.remove(this.latchLabel[cond]);
            this.latchPanel.remove(this.latchStatus[cond]);
            this.latchPanel.remove(this.latchResetBtn[cond]);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.gridy = -1;
        int colm = 0;
        for (int cond = 0; cond < 4; ++cond) {
            if ((conditions & 1 << cond) == 0) continue;
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
            gbc.insets.left = colm == 0 ? 4 : 40;
            this.latchPanel.add((Component)this.latchLabel[cond], gbc);
            gbc.insets.left = 4;
            ++gbc.gridx;
            this.latchPanel.add((Component)this.latchStatus[cond], gbc);
            ++gbc.gridx;
            this.latchPanel.add((Component)this.latchResetBtn[cond], gbc);
            ++gbc.gridx;
            colm = (colm + 1) % 2;
        }
        this.latchMask = conditions;
    }

    private void updateConditionLayout(int conditions) {
        for (int cond = 0; cond < 4; ++cond) {
            if ((this.conditionMask & 1 << cond) == 0) continue;
            this.conditionPanel.remove(this.conditionLabel[cond]);
            this.conditionPanel.remove(this.conditionStatus[cond]);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.gridy = -1;
        int colm = 0;
        for (int cond = 0; cond < 5; ++cond) {
            if ((conditions & 1 << cond) == 0) continue;
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
            gbc.insets.left = colm == 0 ? 4 : 40;
            this.conditionPanel.add((Component)this.conditionLabel[cond], gbc);
            ++gbc.gridx;
            gbc.insets.left = 4;
            this.conditionPanel.add((Component)this.conditionStatus[cond], gbc);
            ++gbc.gridx;
            colm = (colm + 1) % 2;
        }
        this.conditionMask = conditions;
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.sender.sendCommand(this.subsys, "setUpdatePeriod", new Object[]{(int)(1000.0 * value)});
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.periodTextField.setText(String.valueOf(this.mainPeriod));
        }
    }

    private void setSwitchOn(int sw, boolean value) {
        this.switchOffRB[sw].setEnabled(false);
        this.switchOnRB[sw].setEnabled(false);
        this.sender.sendCommand(this.subsys, "setSwitchOn", new Object[]{sw, value});
    }

    public void clearLatch(int cond) {
        this.latchResetBtn[cond].setEnabled(false);
        this.sender.sendCommand(null, "clearLatch", new Object[]{cond});
    }

    private void clearCondition(int cond) {
        this.conditionResetBtn[cond].setEnabled(false);
        this.sender.sendCommand(this.subsys, "clearCondition", new Object[]{cond});
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getVacuumState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((VacSysState)reply);
    }

    public void updatePanel(VacSysState rs) {
        SwingUtilities.invokeLater(new UpdateVacStatus(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    static {
        ComCamVacControlPanel.switchNames[0] = "Cryo Turbo Pump";
        ComCamVacControlPanel.switchNames[1] = "Cryo Ion Pump 1";
        ComCamVacControlPanel.switchNames[2] = "VAT Valve Request";
        ComCamVacControlPanel.switchNames[6] = "CryoTel Cryo";
        ComCamVacControlPanel.switchNames[7] = "CryoTel Cold1";
        ComCamVacControlPanel.switchNames[8] = "CryoTel Cold2";
        switchTypes = new int[9];
        ComCamVacControlPanel.switchTypes[0] = 0;
        ComCamVacControlPanel.switchTypes[1] = 0;
        ComCamVacControlPanel.switchTypes[2] = 1;
        ComCamVacControlPanel.switchTypes[6] = 4;
        ComCamVacControlPanel.switchTypes[7] = 4;
        ComCamVacControlPanel.switchTypes[8] = 4;
        latchNames = new String[4];
        ComCamVacControlPanel.latchNames[2] = "Cryo Gate Can't Open";
        ComCamVacControlPanel.latchNames[1] = "Cryo Gate Forced Shut";
        ComCamVacControlPanel.latchNames[0] = "Cryo Vacuum Bad";
        ComCamVacControlPanel.latchNames[3] = "Cryo Turbo Pump Bad";
        conditionNames = new String[5];
        ComCamVacControlPanel.conditionNames[0] = "Cryo Foreline OK";
        ComCamVacControlPanel.conditionNames[2] = "Cryo Turbo Pr < 10";
        ComCamVacControlPanel.conditionNames[1] = "Cryo Turbo Pump Off";
        ComCamVacControlPanel.conditionNames[4] = "Cryo Vacuum < 0.001";
        ComCamVacControlPanel.conditionNames[3] = "Cryo Vacuum < 0.1";
        sysStateWidth = UiUtilities.maxLabelWidth((String[])new String[]{"RUNNING", "STOPPED"}, (String)"");
        plcStateWidth = UiUtilities.maxEnumLabelWidth(PLCState.class);
        switchStatusWidth = Math.max(UiUtilities.maxEnumLabelWidth(SwitchState.class), UiUtilities.maxEnumLabelWidth(DeviceState.class));
        latchStatusWidth = UiUtilities.maxEnumLabelWidth(LatchState.class);
        condStatusWidth = UiUtilities.maxEnumLabelWidth(ConditionState.class);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            int cond;
            ComCamVacControlPanel.this.sysStateValue.setText("STOPPED");
            ComCamVacControlPanel.this.sysStateValue.setForeground(UiConstants.RED);
            ComCamVacControlPanel.this.plcStateValue.setEnabled(false);
            ComCamVacControlPanel.this.periodTextField.setDisabled();
            for (int sw = 0; sw < 9; ++sw) {
                ComCamVacControlPanel.this.switchStatus[sw].setEnabled(false);
                ComCamVacControlPanel.this.switchOffRB[sw].setEnabled(false);
                ComCamVacControlPanel.this.switchOnRB[sw].setEnabled(false);
            }
            for (cond = 0; cond < 4; ++cond) {
                try {
                    ComCamVacControlPanel.this.latchStatus[cond].setEnabled(false);
                    ComCamVacControlPanel.this.latchResetBtn[cond].setEnabled(false);
                    continue;
                }
                catch (NullPointerException npe) {
                    break;
                }
            }
            for (cond = 0; cond < 5; ++cond) {
                try {
                    ComCamVacControlPanel.this.conditionStatus[cond].setEnabled(false);
                    continue;
                }
                catch (NullPointerException npe) {
                    break;
                }
            }
        }
    }

    class UpdateVacStatus
    implements Runnable {
        private final VacSysState vs;
        private final Logger sLog = Logger.getLogger("org.lsst.ccs.subsystem.comcamvacuum.ui.ComCamVacControlPanel");

        UpdateVacStatus(VacSysState vs) {
            this.vs = vs;
        }

        @Override
        public void run() {
            Enum state;
            int cond;
            ComCamVacControlPanel.this.sysStateValue.setText("RUNNING");
            ComCamVacControlPanel.this.sysStateValue.setForeground(UiConstants.GREEN);
            PLCState plcState = this.vs.getPlcState();
            ComCamVacControlPanel.this.plcStateValue.setText(plcState.name());
            ComCamVacControlPanel.this.plcStateValue.setForeground(plcState == PLCState.ALIVE ? UiConstants.GREEN : (plcState == PLCState.OFFLINE ? UiConstants.BLUE : UiConstants.RED));
            ComCamVacControlPanel.this.plcStateValue.setEnabled(true);
            ComCamVacControlPanel.this.periodTextField.update((Object)((double)this.vs.getTickMillis() / 1000.0), true);
            int switches = 0;
            for (int sw = 0; sw < 9; ++sw) {
                Color color;
                String text;
                if (!this.vs.hasSwitch(sw)) continue;
                switches |= 1 << sw;
                SwitchState state2 = this.vs.getSwitchState(sw);
                SwitchEnable enable = this.vs.getSwitchEnable(sw);
                if (enable == SwitchEnable.OFF || enable == SwitchEnable.WAS_OFF) {
                    text = "DISABLD";
                    color = RED;
                } else {
                    text = state2.name();
                    if (switchTypes[sw] == 1) {
                        String string = state2 == SwitchState.OFF ? "SHUT" : (text = state2 == SwitchState.ON ? "OPEN" : text);
                    }
                    color = state2 == SwitchState.OFF ? Color.black : (state2 == SwitchState.ON ? GREEN : BLUE);
                    DeviceState devState = this.vs.getDeviceState(sw);
                    if (devState != null && state2 != SwitchState.OFFLINE) {
                        text = devState.name();
                        if (devState == DeviceState.FAILED) {
                            color = RED;
                        }
                    }
                }
                ComCamVacControlPanel.this.switchStatus[sw].setText(text);
                ComCamVacControlPanel.this.switchStatus[sw].setForeground(color);
                JRadioButton selButton = state2 == SwitchState.ON ? ComCamVacControlPanel.this.switchOnRB[sw] : ComCamVacControlPanel.this.switchOffRB[sw];
                selButton.setSelected(true);
                ComCamVacControlPanel.this.switchStatus[sw].setEnabled(true);
                ComCamVacControlPanel.this.switchOffRB[sw].setEnabled(true);
                ComCamVacControlPanel.this.switchOnRB[sw].setEnabled(true);
            }
            if (switches != ComCamVacControlPanel.this.switchMask) {
                ComCamVacControlPanel.this.updateSwitchLayout(switches);
            }
            int conditions = 0;
            for (cond = 0; cond < 4; ++cond) {
                if (!this.vs.hasLatch(cond)) continue;
                conditions |= 1 << cond;
                state = this.vs.getLatch(cond);
                this.sLog.info("ComCamVacControlPanel: cond = " + cond + " name = " + state.name() + " length of latchStatus is " + ComCamVacControlPanel.this.latchStatus.length);
                this.sLog.info("ComCamVacControlPanel: latchStatus = " + ComCamVacControlPanel.this.latchStatus);
                ComCamVacControlPanel.this.latchStatus[cond].setText(state.name());
                ComCamVacControlPanel.this.latchStatus[cond].setForeground(state == LatchState.OFFLINE ? UiConstants.BLUE : (state == LatchState.CLEAR ? UiConstants.GREEN : (state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE)));
                ComCamVacControlPanel.this.latchStatus[cond].setEnabled(true);
                ComCamVacControlPanel.this.latchResetBtn[cond].setEnabled(true);
            }
            if (conditions != ComCamVacControlPanel.this.latchMask) {
                ComCamVacControlPanel.this.updateLatchLayout(conditions);
            }
            conditions = 0;
            for (cond = 0; cond < 5; ++cond) {
                if (!this.vs.hasCondition(cond)) continue;
                conditions |= 1 << cond;
                state = this.vs.getCondition(cond);
                ComCamVacControlPanel.this.conditionStatus[cond].setText(state.name());
                ComCamVacControlPanel.this.conditionStatus[cond].setForeground(state == ConditionState.OFF ? UiConstants.BLUE : (state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN));
                ComCamVacControlPanel.this.conditionStatus[cond].setEnabled(true);
            }
            if (conditions != ComCamVacControlPanel.this.conditionMask) {
                ComCamVacControlPanel.this.updateConditionLayout(conditions);
            }
        }
    }
}

