/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.idl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.idl.DocCommentHelper;
import org.apache.avro.compiler.idl.IdlConstants;
import org.apache.avro.compiler.idl.IdlTokenManager;
import org.apache.avro.compiler.idl.JavaCharStream;
import org.apache.avro.compiler.idl.ParseException;
import org.apache.avro.compiler.idl.SchemaResolver;
import org.apache.avro.compiler.idl.Token;
import org.apache.avro.util.internal.Accessor;
import org.apache.commons.text.StringEscapeUtils;

public class Idl
implements Closeable,
IdlConstants {
    static JsonNodeFactory FACTORY = JsonNodeFactory.instance;
    private static final String OPTIONAL_NULLABLE_TYPE_PROPERTY = "org.apache.avro.compiler.idl.Idl.NullableType.optional";
    URI inputDir;
    ClassLoader resourceLoader = null;
    String namespace;
    Map<String, Schema> names = new LinkedHashMap<String, Schema>();
    private List<String> parserWarnings = Collections.emptyList();
    public IdlTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[41];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private boolean trace_enabled;

    public List<String> getWarningsAfterParsing() {
        return this.parserWarnings;
    }

    public Idl(File inputFile) throws IOException {
        this(new FileInputStream(inputFile), "UTF-8");
        this.inputDir = inputFile.getParentFile().toURI();
    }

    public Idl(File inputFile, ClassLoader resourceLoader) throws IOException {
        this(inputFile);
        this.resourceLoader = resourceLoader;
    }

    private static URI resourceParent(URL jar) throws IOException {
        String path = jar.toExternalForm();
        String name = path.substring(path.indexOf("!/") + 1);
        try {
            URI uri = new URI("classpath", null, name, null);
            return uri.resolve(".");
        }
        catch (URISyntaxException e) {
            throw new IOException("Could not handle resource import in " + jar, e);
        }
    }

    private Idl(URL input, Idl parent) throws IOException {
        this(input.openStream(), "UTF-8");
        this.inputDir = "file".equals(input.getProtocol()) ? new File(input.getPath()).getParentFile().toURI() : ("jar".equals(input.getProtocol()) ? Idl.resourceParent(input) : parent.inputDir);
        this.resourceLoader = parent.resourceLoader;
    }

    @Override
    public void close() throws IOException {
        this.jj_input_stream.inputStream.close();
    }

    private ParseException error(String message, Token token) {
        return new ParseException(message + ", at line " + token.beginLine + ", column " + token.beginColumn);
    }

    private String getTextProp(String key, Map<String, JsonNode> props, Token token) throws ParseException {
        JsonNode value = props.get(key);
        if (value.isTextual()) {
            return value.textValue();
        }
        throw this.error(key + " property must be textual: " + value, token);
    }

    private List<String> getTextProps(String key, Map<String, JsonNode> props, Token token) throws ParseException {
        JsonNode value = props.get(key);
        if (!value.isArray()) {
            throw this.error(key + " property must be array: " + value, token);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (JsonNode n : value) {
            if (n.isTextual()) {
                values.add(n.textValue());
                continue;
            }
            throw this.error(key + " values must be textual: " + n, token);
        }
        return values;
    }

    private URL findFile(String importFile) throws IOException {
        URI uri = this.inputDir.resolve(importFile);
        File file = "file".equals(uri.getScheme()) ? new File(uri.getPath()) : null;
        URL result = null;
        if (file != null && file.exists()) {
            result = file.toURI().toURL();
        } else if (this.resourceLoader != null) {
            result = "classpath".equals(uri.getScheme()) ? this.resourceLoader.getResource(uri.getPath().substring(1)) : this.resourceLoader.getResource(importFile);
        }
        if (result == null) {
            throw new FileNotFoundException(importFile);
        }
        return result;
    }

    private static Schema fixOptionalSchema(Schema schema, JsonNode defaultValue) {
        Object optionalType = schema.getObjectProp(OPTIONAL_NULLABLE_TYPE_PROPERTY);
        if (optionalType != null) {
            boolean nonNullDefault;
            Schema nullSchema = (Schema)schema.getTypes().get(0);
            Schema nonNullSchema = (Schema)schema.getTypes().get(1);
            boolean bl = nonNullDefault = defaultValue != null && !defaultValue.isNull();
            if (nonNullDefault) {
                return Schema.createUnion((Schema[])new Schema[]{nonNullSchema, nullSchema});
            }
            return Schema.createUnion((Schema[])new Schema[]{nullSchema, nonNullSchema});
        }
        return schema;
    }

    public final Protocol CompilationUnit() throws ParseException {
        DocCommentHelper.getAndClearWarnings();
        Protocol p = this.ProtocolDeclaration();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 73: {
                this.jj_consume_token(73);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
        this.parserWarnings = DocCommentHelper.getAndClearWarnings();
        if ("" != null) {
            return SchemaResolver.resolve(p);
        }
        throw new Error("Missing return statement in function");
    }

    private final Schema NamedSchemaDeclaration(String doc, Map<String, JsonNode> props) throws ParseException {
        Schema s;
        String savedSpace = this.namespace;
        if (props.containsKey("namespace")) {
            this.namespace = this.getTextProp("namespace", props, this.token);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: {
                s = this.FixedDeclaration(doc);
                break;
            }
            case 15: {
                s = this.EnumDeclaration(doc);
                break;
            }
            case 16: 
            case 31: {
                s = this.RecordDeclaration(doc);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.namespace = savedSpace;
        for (String key : props.keySet()) {
            if ("namespace".equals(key)) continue;
            if ("aliases".equals(key)) {
                for (String alias : this.getTextProps("aliases", props, this.token)) {
                    s.addAlias(alias);
                }
                continue;
            }
            Accessor.addProp((JsonProperties)s, (String)key, (JsonNode)props.get(key));
        }
        LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)s);
        if (logicalType != null) {
            logicalType.addToSchema(s);
        }
        if ("" != null) {
            return s;
        }
        throw new Error("Missing return statement in function");
    }

    public final Schema UnionDefinition() throws ParseException {
        ArrayList<Schema> schemata = new ArrayList<Schema>();
        this.jj_consume_token(34);
        this.jj_consume_token(58);
        Schema s = this.Type();
        schemata.add(s);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 64: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(64);
            s = this.Type();
            schemata.add(s);
        }
        this.jj_consume_token(59);
        if ("" != null) {
            return Schema.createUnion(schemata);
        }
        throw new Error("Missing return statement in function");
    }

    public final Protocol ProtocolDeclaration() throws ParseException {
        LinkedHashMap<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
        String doc = this.Documentation();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.SchemaProperty(props);
        }
        if (props.containsKey("namespace")) {
            this.namespace = this.getTextProp("namespace", props, this.token);
        }
        this.jj_consume_token(30);
        String name = this.Identifier();
        Protocol p = new Protocol(name, doc, this.namespace);
        for (String key : props.keySet()) {
            if ("namespace".equals(key)) continue;
            Accessor.addProp((JsonProperties)p, (String)key, (JsonNode)((JsonNode)props.get(key)));
        }
        this.ProtocolBody(p);
        if ("" != null) {
            return p;
        }
        throw new Error("Missing return statement in function");
    }

    public final String Documentation() throws ParseException {
        this.getToken(1);
        if ("" != null) {
            return DocCommentHelper.getDoc();
        }
        throw new Error("Missing return statement in function");
    }

    public final Schema EnumDeclaration(String doc) throws ParseException {
        String defaultSymbol = null;
        this.jj_consume_token(15);
        String name = this.Identifier();
        List<String> symbols = this.EnumBody();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 66: {
                this.jj_consume_token(66);
                defaultSymbol = this.Identifier();
                this.jj_consume_token(63);
                DocCommentHelper.clearDoc();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        Schema s = Schema.createEnum((String)name, (String)doc, (String)this.namespace, symbols, (String)defaultSymbol);
        this.names.put(s.getFullName(), s);
        if ("" != null) {
            return s;
        }
        throw new Error("Missing return statement in function");
    }

    public final List<String> EnumBody() throws ParseException {
        ArrayList<String> symbols = new ArrayList<String>();
        this.jj_consume_token(58);
        DocCommentHelper.clearDoc();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 53: 
            case 72: {
                this.EnumConstant(symbols);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 64: {
                            break;
                        }
                        default: {
                            this.jj_la1[6] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(64);
                    this.EnumConstant(symbols);
                }
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        this.jj_consume_token(59);
        DocCommentHelper.clearDoc();
        if ("" != null) {
            return symbols;
        }
        throw new Error("Missing return statement in function");
    }

    public final void EnumConstant(List<String> symbols) throws ParseException {
        String sym = this.Identifier();
        symbols.add(sym);
    }

    public final void ProtocolBody(Protocol p) throws ParseException {
        block25: {
            LinkedHashMap<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
            this.jj_consume_token(58);
            DocCommentHelper.clearDoc();
            block22: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 26: 
                    case 28: 
                    case 29: 
                    case 31: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 53: 
                    case 65: 
                    case 72: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block25;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        Schema schema;
                        this.jj_consume_token(21);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 20: 
                            case 30: {
                                Protocol importProtocol;
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 20: {
                                        importProtocol = this.ImportIdl();
                                        break;
                                    }
                                    case 30: {
                                        importProtocol = this.ImportProtocol();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[9] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                for (Schema s : importProtocol.getTypes()) {
                                    this.names.put(s.getFullName(), s);
                                }
                                p.getMessages().putAll(importProtocol.getMessages());
                                break;
                            }
                            case 27: {
                                schema = this.ImportSchema();
                                break;
                            }
                            default: {
                                this.jj_la1[10] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        DocCommentHelper.clearDoc();
                        continue block22;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 26: 
                    case 28: 
                    case 29: 
                    case 31: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 53: 
                    case 65: 
                    case 72: {
                        Schema schema;
                        String doc = this.Documentation();
                        block24: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 65: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[11] = this.jj_gen;
                                    break block24;
                                }
                            }
                            this.SchemaProperty(props);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 15: 
                            case 16: 
                            case 18: 
                            case 31: {
                                schema = this.NamedSchemaDeclaration(doc, props);
                                break;
                            }
                            case 12: 
                            case 13: 
                            case 14: 
                            case 19: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 26: 
                            case 28: 
                            case 29: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 53: 
                            case 72: {
                                Protocol.Message message = this.MessageDeclaration(p, doc, props);
                                p.getMessages().put(message.getName(), message);
                                break;
                            }
                            default: {
                                this.jj_la1[12] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        props.clear();
                        continue block22;
                    }
                }
                break;
            }
            this.jj_la1[13] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(59);
        p.setTypes(this.names.values());
        DocCommentHelper.clearDoc();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Protocol ImportIdl() throws ParseException {
        this.jj_consume_token(20);
        String importFile = this.JsonString();
        this.jj_consume_token(63);
        try (Idl idl = new Idl(this.findFile(importFile), this);){
            Protocol protocol = idl.CompilationUnit();
            return protocol;
        }
        catch (IOException e) {
            throw this.error("Error importing " + importFile + ": " + e, this.token);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Protocol ImportProtocol() throws ParseException {
        this.jj_consume_token(30);
        String importFile = this.JsonString();
        this.jj_consume_token(63);
        try (InputStream stream = this.findFile(importFile).openStream();){
            Protocol protocol = Protocol.parse((InputStream)stream);
            return protocol;
        }
        catch (IOException e) {
            throw this.error("Error importing " + importFile + ": " + e, this.token);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Schema ImportSchema() throws ParseException {
        this.jj_consume_token(27);
        String importFile = this.JsonString();
        this.jj_consume_token(63);
        try (InputStream stream = this.findFile(importFile).openStream();){
            Schema.Parser parser = new Schema.Parser();
            parser.addTypes(this.names);
            Schema value = parser.parse(stream);
            this.names = parser.getTypes();
            Schema schema = value;
            return schema;
        }
        catch (IOException e) {
            throw this.error("Error importing " + importFile + ": " + e, this.token);
        }
    }

    public final Schema FixedDeclaration(String doc) throws ParseException {
        this.jj_consume_token(18);
        String name = this.Identifier();
        this.jj_consume_token(56);
        Token sizeTok = this.jj_consume_token(42);
        this.jj_consume_token(57);
        this.jj_consume_token(63);
        DocCommentHelper.clearDoc();
        Schema s = Schema.createFixed((String)name, (String)doc, (String)this.namespace, (int)Integer.parseInt(sizeTok.image));
        this.names.put(s.getFullName(), s);
        if ("" != null) {
            return s;
        }
        throw new Error("Missing return statement in function");
    }

    public final Schema RecordDeclaration(String doc) throws ParseException {
        boolean isError;
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                isError = false;
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                isError = true;
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String name = this.Identifier();
        Schema result = Schema.createRecord((String)name, (String)doc, (String)this.namespace, (boolean)isError);
        this.names.put(result.getFullName(), result);
        this.jj_consume_token(58);
        DocCommentHelper.clearDoc();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 12: 
                case 13: 
                case 14: 
                case 19: 
                case 22: 
                case 23: 
                case 24: 
                case 26: 
                case 28: 
                case 29: 
                case 34: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 53: 
                case 65: 
                case 72: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block7;
                }
            }
            this.FieldDeclaration(fields);
        }
        this.jj_consume_token(59);
        DocCommentHelper.clearDoc();
        result.setFields(fields);
        if ("" != null) {
            return result;
        }
        throw new Error("Missing return statement in function");
    }

    private final void SchemaProperty(Map<String, JsonNode> properties) throws ParseException {
        this.jj_consume_token(65);
        String key = this.PropertyName();
        this.jj_consume_token(56);
        JsonNode val = this.Json();
        this.jj_consume_token(57);
        if (properties.containsKey(key)) {
            throw this.error("Property '" + key + "' already specified", this.token);
        }
        properties.put(key, val);
    }

    public final void FieldDeclaration(List<Schema.Field> fields) throws ParseException {
        String defaultDoc = this.Documentation();
        Schema type = this.Type();
        this.VariableDeclarator(type, defaultDoc, fields);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 64: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(64);
            this.VariableDeclarator(type, defaultDoc, fields);
        }
        this.jj_consume_token(63);
        DocCommentHelper.clearDoc();
    }

    public final void VariableDeclarator(Schema type, String defaultDoc, List<Schema.Field> fields) throws ParseException {
        JsonNode defaultValue = null;
        LinkedHashMap<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
        String doc = this.Documentation();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block6;
                }
            }
            this.SchemaProperty(props);
        }
        String name = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 66: {
                this.jj_consume_token(66);
                defaultValue = this.Json();
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        Schema.Field.Order order = Schema.Field.Order.ASCENDING;
        for (String key : props.keySet()) {
            if (!"order".equals(key)) continue;
            order = Schema.Field.Order.valueOf((String)this.getTextProp(key, props, this.token).toUpperCase());
        }
        boolean validate = SchemaResolver.isFullyResolvedSchema(type);
        Schema fieldType = Idl.fixOptionalSchema(type, defaultValue);
        Schema.Field field = Accessor.createField((String)name, (Schema)fieldType, (String)(doc == null ? defaultDoc : doc), (JsonNode)defaultValue, (boolean)validate, (Schema.Field.Order)order);
        for (String key : props.keySet()) {
            if ("order".equals(key)) continue;
            if ("aliases".equals(key)) {
                for (String alias : this.getTextProps("aliases", props, this.token)) {
                    field.addAlias(alias);
                }
                continue;
            }
            Accessor.addProp((JsonProperties)field, (String)key, (JsonNode)((JsonNode)props.get(key)));
        }
        fields.add(field);
        DocCommentHelper.clearDoc();
    }

    private final Protocol.Message MessageDeclaration(Protocol p, String msgDoc, Map<String, JsonNode> props) throws ParseException {
        boolean oneWay = false;
        ArrayList<Schema> errorSchemata = new ArrayList<Schema>();
        errorSchemata.add(Protocol.SYSTEM_ERROR);
        Schema response = this.ResultType();
        String name = this.Identifier();
        Schema request = this.FormalParameters();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 25: 
            case 32: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 25: {
                        this.jj_consume_token(25);
                        oneWay = true;
                        break block0;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        this.ErrorList(errorSchemata);
                        break block0;
                    }
                }
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        this.jj_consume_token(63);
        DocCommentHelper.clearDoc();
        Schema errors = Schema.createUnion(errorSchemata);
        if (oneWay && response.getType() != Schema.Type.NULL) {
            throw this.error("One-way message'" + name + "' must return void", this.token);
        }
        if ("" != null) {
            return oneWay ? p.createMessage(name, msgDoc, props, request) : p.createMessage(name, msgDoc, props, request, response, errors);
        }
        throw new Error("Missing return statement in function");
    }

    public final void ErrorList(List<Schema> errors) throws ParseException {
        Schema s = this.ReferenceType();
        errors.add(s);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 64: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(64);
            s = this.ReferenceType();
            errors.add(s);
        }
    }

    public final Schema FormalParameters() throws ParseException {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        this.jj_consume_token(56);
        DocCommentHelper.clearDoc();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 53: 
            case 65: 
            case 72: {
                this.FormalParameter(fields);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 64: {
                            break;
                        }
                        default: {
                            this.jj_la1[22] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(64);
                    this.FormalParameter(fields);
                }
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        this.jj_consume_token(57);
        DocCommentHelper.clearDoc();
        if ("" != null) {
            return Schema.createRecord(null, null, null, (boolean)false, fields);
        }
        throw new Error("Missing return statement in function");
    }

    public final void FormalParameter(List<Schema.Field> fields) throws ParseException {
        String doc = this.Documentation();
        Schema type = this.Type();
        this.VariableDeclarator(type, doc, fields);
    }

    public final Schema Type() throws ParseException {
        LinkedHashMap<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block3;
                }
            }
            this.SchemaProperty(props);
        }
        Schema s = this.UnannotatedType(props);
        if ("" != null) {
            return s;
        }
        throw new Error("Missing return statement in function");
    }

    public final Schema UnannotatedType(Map<String, JsonNode> props) throws ParseException {
        Schema s;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 53: 
            case 72: {
                s = this.NullableType(props);
                break;
            }
            case 12: 
            case 24: 
            case 34: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 34: {
                        s = this.UnionDefinition();
                        break;
                    }
                    case 12: {
                        s = this.ArrayType();
                        break;
                    }
                    case 24: {
                        s = this.MapType();
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                for (String key : props.keySet()) {
                    Accessor.addProp((JsonProperties)s, (String)key, (JsonNode)props.get(key));
                }
                LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)s);
                if (logicalType == null) break;
                logicalType.addToSchema(s);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return s;
        }
        throw new Error("Missing return statement in function");
    }

    public final Schema NullableType(Map<String, JsonNode> props) throws ParseException {
        Schema s;
        boolean optional = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 53: 
            case 72: {
                s = this.ReferenceType();
                if (props.isEmpty()) break;
                throw this.error("Type references may not be annotated", this.token);
            }
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                s = this.PrimitiveType();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 69: {
                this.jj_consume_token(69);
                optional = true;
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        for (String key : props.keySet()) {
            Accessor.addProp((JsonProperties)s, (String)key, (JsonNode)props.get(key));
        }
        LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)s);
        if (logicalType != null) {
            logicalType.addToSchema(s);
        }
        if (optional) {
            s = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), s});
            Accessor.addProp((JsonProperties)s, (String)OPTIONAL_NULLABLE_TYPE_PROPERTY, (JsonNode)BooleanNode.TRUE);
        }
        if ("" != null) {
            return s;
        }
        throw new Error("Missing return statement in function");
    }

    public final Schema ArrayType() throws ParseException {
        this.jj_consume_token(12);
        this.jj_consume_token(70);
        Schema elemSchema = this.Type();
        this.jj_consume_token(71);
        if ("" != null) {
            return Schema.createArray((Schema)elemSchema);
        }
        throw new Error("Missing return statement in function");
    }

    public final Schema MapType() throws ParseException {
        this.jj_consume_token(24);
        this.jj_consume_token(70);
        Schema elemSchema = this.Type();
        this.jj_consume_token(71);
        if ("" != null) {
            return Schema.createMap((Schema)elemSchema);
        }
        throw new Error("Missing return statement in function");
    }

    public final Schema ReferenceType() throws ParseException {
        Schema type;
        StringBuilder sb = new StringBuilder();
        String part = this.Identifier();
        sb.append(part);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 67: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(67);
            Token tok = this.AnyIdentifier();
            sb.append(".").append(tok.image);
        }
        String name = sb.toString();
        if (name.indexOf(46) == -1 && this.namespace != null) {
            name = this.namespace + "." + name;
        }
        if ((type = this.names.get(name)) == null) {
            type = SchemaResolver.unresolvedSchema(name);
        }
        if ("" != null) {
            return type;
        }
        throw new Error("Missing return statement in function");
    }

    public final Schema PrimitiveType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                if ("" == null) break;
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case 26: {
                this.jj_consume_token(26);
                if ("" == null) break;
                return Schema.create((Schema.Type)Schema.Type.BYTES);
            }
            case 22: {
                this.jj_consume_token(22);
                if ("" == null) break;
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case 28: {
                this.jj_consume_token(28);
                if ("" == null) break;
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case 19: {
                this.jj_consume_token(19);
                if ("" == null) break;
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case 14: {
                this.jj_consume_token(14);
                if ("" == null) break;
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case 23: {
                this.jj_consume_token(23);
                if ("" == null) break;
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case 29: {
                this.jj_consume_token(29);
                if ("" == null) break;
                return Schema.create((Schema.Type)Schema.Type.NULL);
            }
            case 36: {
                this.jj_consume_token(36);
                if ("" == null) break;
                return LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
            }
            case 37: {
                this.jj_consume_token(37);
                if ("" == null) break;
                return LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
            }
            case 38: {
                this.jj_consume_token(38);
                if ("" == null) break;
                return LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
            }
            case 40: {
                this.jj_consume_token(40);
                if ("" == null) break;
                return LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
            }
            case 39: {
                this.jj_consume_token(39);
                Schema s = this.DecimalTypeProperties();
                if ("" == null) break;
                return s;
            }
            case 41: {
                this.jj_consume_token(41);
                if ("" == null) break;
                return LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING));
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Schema DecimalTypeProperties() throws ParseException {
        this.jj_consume_token(56);
        int precision = this.Json().asInt();
        this.jj_consume_token(64);
        int scale = this.Json().asInt();
        this.jj_consume_token(57);
        if ("" != null) {
            return LogicalTypes.decimal((int)precision, (int)scale).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        }
        throw new Error("Missing return statement in function");
    }

    public final Schema ResultType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                if ("" == null) break;
                return Schema.create((Schema.Type)Schema.Type.NULL);
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 53: 
            case 72: {
                Schema schema = this.UnannotatedType(Collections.emptyMap());
                if ("" == null) break;
                return schema;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final String PropertyName() throws ParseException {
        StringBuilder name;
        block9: {
            name = new StringBuilder();
            String s = this.Identifier();
            name.append(s);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 67: 
                    case 68: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 68: {
                        Token t = this.jj_consume_token(68);
                        name.append(t.image);
                        s = this.Identifier();
                        name.append(s);
                        continue block7;
                    }
                    case 67: {
                        Token t = this.jj_consume_token(67);
                        name.append(t.image);
                        s = this.Identifier();
                        name.append(s);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[33] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if ("" != null) {
            return name.toString();
        }
        throw new Error("Missing return statement in function");
    }

    public final String Identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 53: {
                Token t = this.jj_consume_token(53);
                if ("" == null) break;
                return t.image;
            }
            case 72: {
                this.jj_consume_token(72);
                Token t = this.AnyIdentifier();
                this.jj_consume_token(72);
                if ("" == null) break;
                return t.image;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Token AnyIdentifier() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: {
                t = this.jj_consume_token(12);
                break;
            }
            case 13: {
                t = this.jj_consume_token(13);
                break;
            }
            case 14: {
                t = this.jj_consume_token(14);
                break;
            }
            case 15: {
                t = this.jj_consume_token(15);
                break;
            }
            case 16: {
                t = this.jj_consume_token(16);
                break;
            }
            case 17: {
                t = this.jj_consume_token(17);
                break;
            }
            case 18: {
                t = this.jj_consume_token(18);
                break;
            }
            case 19: {
                t = this.jj_consume_token(19);
                break;
            }
            case 20: {
                t = this.jj_consume_token(20);
                break;
            }
            case 21: {
                t = this.jj_consume_token(21);
                break;
            }
            case 22: {
                t = this.jj_consume_token(22);
                break;
            }
            case 23: {
                t = this.jj_consume_token(23);
                break;
            }
            case 24: {
                t = this.jj_consume_token(24);
                break;
            }
            case 25: {
                t = this.jj_consume_token(25);
                break;
            }
            case 26: {
                t = this.jj_consume_token(26);
                break;
            }
            case 28: {
                t = this.jj_consume_token(28);
                break;
            }
            case 29: {
                t = this.jj_consume_token(29);
                break;
            }
            case 30: {
                t = this.jj_consume_token(30);
                break;
            }
            case 31: {
                t = this.jj_consume_token(31);
                break;
            }
            case 27: {
                t = this.jj_consume_token(27);
                break;
            }
            case 32: {
                t = this.jj_consume_token(32);
                break;
            }
            case 33: {
                t = this.jj_consume_token(33);
                break;
            }
            case 34: {
                t = this.jj_consume_token(34);
                break;
            }
            case 41: {
                t = this.jj_consume_token(41);
                break;
            }
            case 35: {
                t = this.jj_consume_token(35);
                break;
            }
            case 36: {
                t = this.jj_consume_token(36);
                break;
            }
            case 37: {
                t = this.jj_consume_token(37);
                break;
            }
            case 38: {
                t = this.jj_consume_token(38);
                break;
            }
            case 40: {
                t = this.jj_consume_token(40);
                break;
            }
            case 39: {
                t = this.jj_consume_token(39);
                break;
            }
            case 53: {
                t = this.jj_consume_token(53);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return t;
        }
        throw new Error("Missing return statement in function");
    }

    private final JsonNode Json() throws ParseException {
        JsonNode n;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 52: {
                String s = this.JsonString();
                n = new TextNode(s);
                break;
            }
            case 42: {
                Token t = this.jj_consume_token(42);
                long longValue = Long.parseLong(t.image);
                int intValue = (int)longValue;
                if ((long)intValue == longValue) {
                    n = new IntNode(intValue);
                    break;
                }
                n = new LongNode(longValue);
                break;
            }
            case 46: {
                Token t = this.jj_consume_token(46);
                n = new DoubleNode(Double.parseDouble(t.image));
                break;
            }
            case 58: {
                n = this.JsonObject();
                break;
            }
            case 60: {
                n = this.JsonArray();
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                n = BooleanNode.TRUE;
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                n = BooleanNode.FALSE;
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                n = NullNode.instance;
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return n;
        }
        throw new Error("Missing return statement in function");
    }

    public final String JsonString() throws ParseException {
        Token t = this.jj_consume_token(52);
        String betweenQuotes = t.image.substring(1, t.image.length() - 1);
        if ("" != null) {
            return StringEscapeUtils.unescapeJava((String)betweenQuotes);
        }
        throw new Error("Missing return statement in function");
    }

    private final JsonNode JsonObject() throws ParseException {
        ObjectNode o = FACTORY.objectNode();
        this.jj_consume_token(58);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 52: {
                this.JsonFields(o);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        this.jj_consume_token(59);
        if ("" != null) {
            return o;
        }
        throw new Error("Missing return statement in function");
    }

    private final void JsonFields(ObjectNode o) throws ParseException {
        this.JsonPair(o);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                this.JsonFields(o);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
    }

    private final void JsonPair(ObjectNode o) throws ParseException {
        String name = this.JsonString();
        this.jj_consume_token(62);
        JsonNode value = this.Json();
        o.set(name, value);
    }

    private final JsonNode JsonArray() throws ParseException {
        ArrayNode a = FACTORY.arrayNode();
        this.jj_consume_token(60);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: 
            case 29: 
            case 33: 
            case 42: 
            case 46: 
            case 52: 
            case 58: 
            case 60: {
                this.JsonElements(a);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        this.jj_consume_token(61);
        if ("" != null) {
            return a;
        }
        throw new Error("Missing return statement in function");
    }

    private final void JsonElements(ArrayNode a) throws ParseException {
        JsonNode element = this.Json();
        a.add(element);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                this.JsonElements(a);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, -2147123200, 0, 0, 0, 0, 0, -1242697728, 0x40100000, 1209008128, 0, -1244794880, -1242697728, -2147418112, 902328320, 0, 0, 0, 0x2000000, 0x2000000, 0, 0, 902328320, 0, 0x1001000, 902328320, 885547008, 0, 0, 885547008, 902328320, 0, 0, 0, -4096, 0x20020000, 0, 0, 0x20020000, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0x200000, 2098172, 0, 0, 0, 2098172, 2098172, 0, 2098164, 0, 0, 0, 1, 1, 0, 0, 2098164, 0, 4, 2098164, 2098160, 0, 0, 1008, 2098172, 0, 0, 0x200000, 2098175, 336610306, 0x100000, 0, 336610306, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{512, 1024, 0, 1, 2, 4, 1, 256, 258, 0, 0, 2, 256, 258, 0, 258, 1, 2, 4, 0, 0, 1, 1, 258, 2, 0, 256, 256, 32, 8, 0, 256, 24, 24, 256, 0, 0, 0, 1, 0, 1};
    }

    public Idl(InputStream stream) {
        this(stream, null);
    }

    public Idl(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new IdlTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public Idl(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new IdlTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new IdlTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public Idl(IdlTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(IdlTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 41; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[75];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 41; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 75; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        Idl.jj_la1_init_0();
        Idl.jj_la1_init_1();
        Idl.jj_la1_init_2();
    }
}

