/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.tree.DefaultFTree;
import org.freehep.jas.plugin.tree.DefaultFTreeNode;
import org.freehep.jas.plugin.tree.DefaultJTree;
import org.freehep.jas.plugin.tree.FTreeSortingChooser;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;

class FTreeNodeCommands
extends CommandProcessor {
    private DefaultJTree jTree;

    public FTreeNodeCommands(DefaultJTree jTree) {
        this.jTree = jTree;
    }

    public void onRename() {
        this.jTree.startEditingAtPath(this.jTree.getLeadSelectionPath());
    }

    public void enableRename(CommandState state) {
        boolean enabled = false;
        if (this.jTree.getSelectionCount() == 1) {
            DefaultFTreeNode node = this.jTree.selectedNodes()[0];
            enabled = node.isEditable();
        }
        state.setEnabled(enabled);
    }

    public void onSorting() {
        DefaultFTreeNode[] nodes = this.jTree.selectedNodes();
        String sortingString = nodes[0].sortingString();
        Application app = Studio.getApplication();
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)app);
        JDialog dlg = new JDialog(frame, true);
        FTreeSortingChooser sortingChooser = new FTreeSortingChooser((DefaultFTree)this.jTree.getModel(), sortingString, dlg);
        dlg.getContentPane().add(sortingChooser);
        dlg.setLocationRelativeTo((Component)app);
        dlg.pack();
        dlg.setVisible(true);
    }

    public void enableSorting(CommandState state) {
        boolean enabled = false;
        DefaultFTreeNode[] nodes = this.jTree.selectedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            if (!nodes[i].getAllowsChildren()) continue;
            enabled = true;
            break;
        }
        state.setEnabled(enabled);
    }
}

