/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extensions.jconsole;

import com.wittams.gritty.Questioner;
import com.wittams.gritty.RequestOrigin;
import com.wittams.gritty.Tty;
import com.wittams.gritty.swing.GrittyTerminal;
import com.wittams.gritty.swing.TermPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jline.Terminal;
import jline.console.ConsoleReader;
import org.freehep.jas.extensions.jconsole.JConsole;

public class JLineConsole
implements JConsole {
    private final GrittyTerminal _terminal = new GrittyTerminal();
    private final ConsoleReader _reader;

    public JLineConsole(String name) throws IOException {
        this._terminal.setName(name);
        TermPanel termPanel = this._terminal.getTermPanel();
        termPanel.setResizePanelDelegate((pixelDimension, origin) -> {
            if (origin == RequestOrigin.Remote) {
                this._terminal.setSize(pixelDimension);
                this._terminal.revalidate();
            }
        });
        termPanel.setSize(termPanel.getPreferredSize());
        TtyImpl tty = new TtyImpl();
        this._terminal.setTty((Tty)tty);
        this._reader = new ConsoleReader((InputStream)tty.getInputStream(), (OutputStream)tty.getOutputStream(), (Terminal)new SwingTerminal());
        this._terminal.start();
    }

    @Override
    public void dispose() {
        this._terminal.stop();
    }

    @Override
    public String getName() {
        return this._terminal.getName();
    }

    @Override
    public Component getView() {
        return this._terminal;
    }

    public ConsoleReader getConsoleReader() {
        return this._reader;
    }

    @Override
    public int getVerticalScrollBarPolicy() {
        return 21;
    }

    @Override
    public int getHorizontalScrollBarPolicy() {
        return 31;
    }

    private class TtyImpl
    implements Tty {
        private final BlockingQueue<byte[]> inputQueue = new LinkedBlockingQueue<byte[]>();
        private final BlockingQueue<byte[]> outputQueue = new LinkedBlockingQueue<byte[]>();
        private final TtyInputStream inputStream = new TtyInputStream();
        private final TtyOutputStream outputStream = new TtyOutputStream();

        public boolean init(Questioner qstnr) {
            return true;
        }

        public void close() {
        }

        public void resize(Dimension dmnsn, Dimension dmnsn1) {
        }

        public String getName() {
            return "Test";
        }

        public int read(byte[] bytes, int i, int i1) throws IOException {
            try {
                byte[] src = this.outputQueue.take();
                System.arraycopy(src, 0, bytes, i, src.length);
                return src.length;
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException();
            }
        }

        public void write(byte[] bytes) throws IOException {
            try {
                this.inputQueue.put(bytes);
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException();
            }
        }

        public TtyInputStream getInputStream() {
            return this.inputStream;
        }

        public TtyOutputStream getOutputStream() {
            return this.outputStream;
        }

        private class TtyOutputStream
        extends OutputStream {
            private TtyOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                try {
                    byte[] buffer = new byte[]{(byte)b};
                    TtyImpl.this.outputQueue.put(buffer);
                    if (b == 10) {
                        byte[] buffer2 = new byte[]{13};
                        TtyImpl.this.outputQueue.put(buffer2);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
        }

        private class TtyInputStream
        extends InputStream {
            private byte[] currentBuffer;
            private int pos;

            private TtyInputStream() {
            }

            @Override
            public int read() throws IOException {
                try {
                    while (this.currentBuffer == null || this.currentBuffer.length <= this.pos) {
                        this.currentBuffer = (byte[])TtyImpl.this.inputQueue.take();
                        this.pos = 0;
                    }
                    return this.currentBuffer[this.pos++];
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                try {
                    if (this.currentBuffer == null || this.currentBuffer.length <= this.pos) {
                        this.currentBuffer = (byte[])TtyImpl.this.inputQueue.take();
                        this.pos = 0;
                    }
                    int actual = Math.min(len, this.currentBuffer.length - this.pos);
                    System.arraycopy(this.currentBuffer, this.pos, b, off, actual);
                    this.pos += actual;
                    return actual;
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
        }
    }

    private class SwingTerminal
    implements Terminal {
        private SwingTerminal() {
        }

        public void init() throws Exception {
        }

        public void restore() throws Exception {
        }

        public void reset() throws Exception {
        }

        public boolean isSupported() {
            return true;
        }

        public int getWidth() {
            return 80;
        }

        public int getHeight() {
            return 100;
        }

        public boolean isAnsiSupported() {
            return false;
        }

        public OutputStream wrapOutIfNeeded(OutputStream out) {
            return out;
        }

        public InputStream wrapInIfNeeded(InputStream in) throws IOException {
            return in;
        }

        public boolean hasWeirdWrap() {
            return false;
        }

        public boolean isEchoEnabled() {
            return false;
        }

        public void setEchoEnabled(boolean bln) {
        }
    }
}

