/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.client.TrackedClientSet;
import org.astrogrid.samp.gui.ClientTransmissionHolder;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.HubView;
import org.astrogrid.samp.gui.IconBox;
import org.astrogrid.samp.gui.MessageTrackerListCellRenderer;
import org.astrogrid.samp.gui.Transmission;
import org.astrogrid.samp.gui.TransmissionCellRenderer;
import org.astrogrid.samp.gui.TransmissionListModel;
import org.astrogrid.samp.gui.TransmissionTableModel;
import org.astrogrid.samp.gui.TransmissionView;
import org.astrogrid.samp.gui.WrapperHubConnection;

public class MessageTrackerHubConnector
extends GuiHubConnector
implements ClientTransmissionHolder {
    private final TransmissionListModel txListModel_;
    private final TransmissionListModel rxListModel_;
    private final TransmissionTableModel txTableModel_;
    private final TransmissionTableModel rxTableModel_;
    private final Map callAllMap_;
    private final Map txModelMap_;
    private final Map rxModelMap_;
    private final ListDataListener transListListener_;
    private final int listRemoveDelay_;
    private static final Logger logger_ = Logger.getLogger(MessageTrackerHubConnector.class.getName());

    public MessageTrackerHubConnector(ClientProfile profile) {
        this(profile, 500, 20000, 100);
    }

    public MessageTrackerHubConnector(ClientProfile profile, int listRemoveDelay, int tableRemoveDelay, int tableMaxRows) {
        super(profile);
        this.listRemoveDelay_ = listRemoveDelay;
        this.transListListener_ = new ClientTransmissionListListener();
        this.txListModel_ = new TransmissionListModel(this.listRemoveDelay_);
        this.rxListModel_ = new TransmissionListModel(this.listRemoveDelay_);
        this.txListModel_.addListDataListener(this.transListListener_);
        this.rxListModel_.addListDataListener(this.transListListener_);
        this.txTableModel_ = new TransmissionTableModel(false, true, tableRemoveDelay, tableMaxRows);
        this.rxTableModel_ = new TransmissionTableModel(true, false, tableRemoveDelay, tableMaxRows);
        this.callAllMap_ = new HashMap();
        this.txModelMap_ = new WeakHashMap();
        this.rxModelMap_ = new WeakHashMap();
    }

    public ListModel getTxListModel() {
        return this.txListModel_;
    }

    public ListModel getRxListModel() {
        return this.rxListModel_;
    }

    public ListModel getTxListModel(Client client) {
        if (!this.txModelMap_.containsKey(client)) {
            TransmissionListModel listModel = new TransmissionListModel(this.listRemoveDelay_);
            listModel.addListDataListener(this.transListListener_);
            this.txModelMap_.put(client, listModel);
        }
        return (ListModel)this.txModelMap_.get(client);
    }

    public ListModel getRxListModel(Client client) {
        if (!this.rxModelMap_.containsKey(client)) {
            TransmissionListModel listModel = new TransmissionListModel(this.listRemoveDelay_);
            listModel.addListDataListener(this.transListListener_);
            this.rxModelMap_.put(client, listModel);
        }
        return (ListModel)this.rxModelMap_.get(client);
    }

    public JComponent createMessageBox(int iconSize) {
        JComponent box = MessageTrackerHubConnector.createMessageBox(iconSize, this.rxListModel_, this.txListModel_);
        this.registerUpdater(box, ENABLE_COMPONENT);
        return box;
    }

    public static JComponent createMessageBox(int iconSize, ListModel rxListModel, ListModel txListModel) {
        Color dtColor = UIManager.getColor("Label.disabledText");
        JPanel box = new JPanel(){
            final Color enabledFg = this.getForeground();
            final Color enabledBg = Color.WHITE;
            final Color disabledFg = null;
            final Color disabledBg = this.getBackground();

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.setForeground(enabled ? this.enabledFg : this.disabledFg);
                this.setBackground(enabled ? this.enabledBg : this.disabledFg);
            }
        };
        box.setLayout(new BoxLayout(box, 0));
        if (rxListModel != null) {
            IconBox rxBox = new IconBox(iconSize);
            rxBox.setOpaque(false);
            rxBox.setTrailing(true);
            rxBox.setModel(rxListModel);
            rxBox.setRenderer(new TransmissionCellRenderer(){

                public String getToolTipText(IconBox iconBox, Object value, int index) {
                    if (value instanceof Transmission) {
                        Transmission trans = (Transmission)value;
                        return trans.getMessage().getMType() + " <- " + trans.getSender().toString();
                    }
                    return super.getToolTipText(iconBox, value, index);
                }
            });
            Dimension prefSize = rxBox.getPreferredSize();
            prefSize.width = iconSize * 3;
            rxBox.setPreferredSize(prefSize);
            box.add(rxBox);
        }
        IconBox cBox = new IconBox(iconSize);
        cBox.setOpaque(false);
        cBox.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        cBox.setModel(new AbstractListModel(){

            public int getSize() {
                return 1;
            }

            public Object getElementAt(int index) {
                return "app";
            }
        });
        cBox.setRenderer(new TransmissionCellRenderer());
        Dimension cSize = cBox.getPreferredSize();
        cBox.setMaximumSize(cSize);
        cBox.setMinimumSize(cSize);
        box.add(cBox);
        if (txListModel != null) {
            IconBox txBox = new IconBox(iconSize);
            txBox.setOpaque(false);
            txBox.setModel(txListModel);
            txBox.setRenderer(new TransmissionCellRenderer(){

                public String getToolTipText(IconBox iconBox, Object value, int index) {
                    if (value instanceof Transmission) {
                        Transmission trans = (Transmission)value;
                        return trans.getMessage().getMType() + " -> " + trans.getReceiver().toString();
                    }
                    return super.getToolTipText(iconBox, value, index);
                }
            });
            Dimension prefSize = txBox.getPreferredSize();
            prefSize.width = iconSize * 3;
            txBox.setPreferredSize(prefSize);
            box.add(txBox);
        }
        box.setBackground(Color.WHITE);
        box.setBorder(MessageTrackerHubConnector.createBoxBorder());
        return box;
    }

    public ListCellRenderer createClientListCellRenderer() {
        MessageTrackerListCellRenderer renderer = new MessageTrackerListCellRenderer(this);
        renderer.setTransmissionCellRenderer(new TransmissionCellRenderer(){

            public String getToolTipText(IconBox iconBox, Object value, int index) {
                return value instanceof Transmission ? ((Transmission)value).getMessage().getMType() : super.getToolTipText(iconBox, value, index);
            }
        });
        return renderer;
    }

    public JComponent createMonitorPanel() {
        JTabbedPane tabber = new JTabbedPane();
        HubView hubView = new HubView(false);
        hubView.setClientListModel(this.getClientListModel());
        hubView.getClientList().setCellRenderer(this.createClientListCellRenderer());
        tabber.add("Clients", hubView);
        tabber.add("Received Messages", new TransmissionView(this.rxTableModel_));
        tabber.add("Sent Messages", new TransmissionView(this.txTableModel_));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)tabber, "Center");
        return panel;
    }

    protected HubConnection createConnection() throws SampException {
        HubConnection connection = super.createConnection();
        return connection == null ? null : new MessageTrackerHubConnection(connection);
    }

    private void scheduleAddTransmission(final Transmission trans, final boolean tx) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                (tx ? MessageTrackerHubConnector.this.txTableModel_ : MessageTrackerHubConnector.this.rxTableModel_).addTransmission(trans);
                ((TransmissionListModel)MessageTrackerHubConnector.this.getTxListModel(trans.getSender())).addTransmission(trans);
                ((TransmissionListModel)MessageTrackerHubConnector.this.getRxListModel(trans.getReceiver())).addTransmission(trans);
            }
        });
    }

    private void scheduleSetResponse(final Transmission trans, final Response response) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                trans.setResponse(response);
            }
        });
    }

    private void scheduleSetFailure(final Transmission trans, final Throwable error) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                trans.setError(error);
            }
        });
    }

    private class ClientTransmissionListListener
    implements ListDataListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        private ClientTransmissionListListener() {
        }

        public void contentsChanged(ListDataEvent evt) {
            this.transmissionChanged(evt);
        }

        public void intervalAdded(ListDataEvent evt) {
            this.transmissionChanged(evt);
        }

        public void intervalRemoved(ListDataEvent evt) {
            this.transmissionChanged(evt);
        }

        private void transmissionChanged(ListDataEvent evt) {
            Object src = evt.getSource();
            if (!$assertionsDisabled && !(src instanceof Transmission)) {
                throw new AssertionError();
            }
            if (src instanceof Transmission) {
                Transmission trans = (Transmission)src;
                TrackedClientSet clientSet = MessageTrackerHubConnector.this.getClientSet();
                clientSet.updateClient(trans.getReceiver(), false, false);
                clientSet.updateClient(trans.getSender(), false, false);
            }
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$gui$MessageTrackerHubConnector == null ? (class$org$astrogrid$samp$gui$MessageTrackerHubConnector = MessageTrackerHubConnector.class$("org.astrogrid.samp.gui.MessageTrackerHubConnector")) : class$org$astrogrid$samp$gui$MessageTrackerHubConnector).desiredAssertionStatus();
        }
    }

    private class CallAllHandler {
        private final String msgTag_;
        private final Map responseMap_;
        private Collection transSet_;
        static final /* synthetic */ boolean $assertionsDisabled;

        CallAllHandler(String msgTag) {
            this.msgTag_ = msgTag;
            this.responseMap_ = new HashMap();
        }

        public void setTransmissions(Transmission[] transmissions) {
            if (this.transSet_ != null) {
                throw new IllegalStateException();
            }
            this.transSet_ = new HashSet<Transmission>(Arrays.asList(transmissions));
            Iterator it = this.responseMap_.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String responderId = (String)entry.getKey();
                Response response = (Response)entry.getValue();
                this.processResponse(responderId, response);
            }
            this.retireIfDone();
        }

        public void addResponse(String responderId, Response response) {
            if (this.transSet_ != null) {
                this.processResponse(responderId, response);
                this.retireIfDone();
            } else {
                this.responseMap_.put(responderId, response);
            }
        }

        private void processResponse(String responderId, Response response) {
            if (!$assertionsDisabled && this.transSet_ == null) {
                throw new AssertionError();
            }
            Iterator it = this.transSet_.iterator();
            while (it.hasNext()) {
                Transmission trans = (Transmission)it.next();
                if (!trans.getReceiver().getId().equals(responderId)) continue;
                trans.setResponse(response);
                it.remove();
                return;
            }
            logger_.warning("Orphan reply " + this.msgTag_ + " - possible hub error?");
        }

        private void retireIfDone() {
            if (!$assertionsDisabled && this.transSet_ == null) {
                throw new AssertionError();
            }
            if (this.transSet_.isEmpty()) {
                if (!$assertionsDisabled && !MessageTrackerHubConnector.this.callAllMap_.containsKey(this.msgTag_)) {
                    throw new AssertionError();
                }
                MessageTrackerHubConnector.this.callAllMap_.remove(this.msgTag_);
            }
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$gui$MessageTrackerHubConnector == null ? (class$org$astrogrid$samp$gui$MessageTrackerHubConnector = MessageTrackerHubConnector.class$("org.astrogrid.samp.gui.MessageTrackerHubConnector")) : class$org$astrogrid$samp$gui$MessageTrackerHubConnector).desiredAssertionStatus();
        }
    }

    private class MessageTrackerCallableClient
    implements CallableClient {
        private final CallableClient base_;
        private final MessageTrackerHubConnection connection_;

        MessageTrackerCallableClient(CallableClient base, MessageTrackerHubConnection connection) {
            this.base_ = base;
            this.connection_ = connection;
        }

        private Client getSelfClient() {
            return this.connection_.getSelfClient();
        }

        public void receiveCall(String senderId, String msgId, Message msg) throws Exception {
            Transmission trans;
            Client sender = (Client)MessageTrackerHubConnector.this.getClientMap().get(senderId);
            Transmission transmission = trans = sender == null ? null : new Transmission(sender, this.getSelfClient(), msg, null, msgId);
            if (trans != null) {
                MessageTrackerHubConnector.this.scheduleAddTransmission(trans, false);
            }
            try {
                this.base_.receiveCall(senderId, msgId, msg);
            }
            catch (Exception e) {
                MessageTrackerHubConnector.this.scheduleSetFailure(trans, e);
                throw e;
            }
        }

        public void receiveNotification(String senderId, Message msg) throws Exception {
            Client sender = (Client)MessageTrackerHubConnector.this.getClientMap().get(senderId);
            this.base_.receiveNotification(senderId, msg);
            if (sender != null) {
                Transmission trans = new Transmission(sender, this.getSelfClient(), msg, null, null);
                MessageTrackerHubConnector.this.scheduleAddTransmission(trans, false);
                MessageTrackerHubConnector.this.scheduleSetResponse(trans, null);
            }
        }

        public void receiveResponse(final String responderId, final String msgTag, final Response response) throws Exception {
            this.base_.receiveResponse(responderId, msgTag, response);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CallAllHandler cah = (CallAllHandler)MessageTrackerHubConnector.this.callAllMap_.get(msgTag);
                    if (cah != null) {
                        cah.addResponse(responderId, response);
                    } else {
                        int nt = MessageTrackerHubConnector.this.txListModel_.getSize();
                        for (int i = 0; i < nt; ++i) {
                            Transmission trans = (Transmission)MessageTrackerHubConnector.this.txListModel_.getElementAt(i);
                            if (!responderId.equals(trans.getReceiver().getId()) || !msgTag.equals(trans.getMessageTag())) continue;
                            trans.setResponse(response);
                            return;
                        }
                        logger_.warning("Orphan reply " + msgTag + " - possible hub error?");
                    }
                }
            });
        }
    }

    private class MessageTrackerHubConnection
    extends WrapperHubConnection {
        private Client selfClient_;
        static final /* synthetic */ boolean $assertionsDisabled;

        MessageTrackerHubConnection(HubConnection base) {
            super(base);
        }

        Client getSelfClient() {
            if (this.selfClient_ == null) {
                this.selfClient_ = (Client)MessageTrackerHubConnector.this.getClientMap().get(this.getRegInfo().getSelfId());
                if (!$assertionsDisabled && this.selfClient_ == null) {
                    throw new AssertionError();
                }
                MessageTrackerHubConnector.this.txModelMap_.put(this.selfClient_, MessageTrackerHubConnector.this.txListModel_);
                MessageTrackerHubConnector.this.rxModelMap_.put(this.selfClient_, MessageTrackerHubConnector.this.rxListModel_);
            }
            return this.selfClient_;
        }

        public void notify(String recipientId, Map msg) throws SampException {
            Transmission trans;
            Client recipient = (Client)MessageTrackerHubConnector.this.getClientMap().get(recipientId);
            Transmission transmission = trans = recipient == null ? null : new Transmission(this.getSelfClient(), recipient, Message.asMessage(msg), null, null);
            if (trans != null) {
                MessageTrackerHubConnector.this.scheduleAddTransmission(trans, true);
            }
            try {
                super.notify(recipientId, msg);
                if (trans != null) {
                    MessageTrackerHubConnector.this.scheduleSetResponse(trans, null);
                }
            }
            catch (SampException e) {
                if (trans != null) {
                    MessageTrackerHubConnector.this.scheduleSetFailure(trans, e);
                }
                throw e;
            }
        }

        public List notifyAll(Map msg) throws SampException {
            List recipientIdList = super.notifyAll(msg);
            ArrayList transList = new ArrayList();
            Message message = Message.asMessage(msg);
            Client sender = this.getSelfClient();
            Iterator it = recipientIdList.iterator();
            while (it.hasNext()) {
                Client recipient = (Client)MessageTrackerHubConnector.this.getClientMap().get((String)it.next());
                if (recipient == null) continue;
                Transmission trans = new Transmission(sender, recipient, message, null, null);
                MessageTrackerHubConnector.this.scheduleAddTransmission(trans, true);
                MessageTrackerHubConnector.this.scheduleSetResponse(trans, null);
            }
            return recipientIdList;
        }

        public String call(String recipientId, String msgTag, Map msg) throws SampException {
            Transmission trans;
            Client recipient = (Client)MessageTrackerHubConnector.this.getClientMap().get(recipientId);
            Transmission transmission = trans = recipient == null ? null : new Transmission(this.getSelfClient(), recipient, Message.asMessage(msg), msgTag, null);
            if (trans != null) {
                MessageTrackerHubConnector.this.scheduleAddTransmission(trans, true);
            }
            try {
                return super.call(recipientId, msgTag, msg);
            }
            catch (SampException e) {
                MessageTrackerHubConnector.this.scheduleSetFailure(trans, e);
                throw e;
            }
        }

        public Map callAll(final String msgTag, Map msg) throws SampException {
            final CallAllHandler cah = new CallAllHandler(msgTag);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageTrackerHubConnector.this.callAllMap_.put(msgTag, cah);
                }
            });
            Map callMap = super.callAll(msgTag, msg);
            ArrayList<Transmission> transList = new ArrayList<Transmission>();
            Message message = Message.asMessage(msg);
            Iterator it = callMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String recipientId = (String)entry.getKey();
                Client sender = this.getSelfClient();
                Client recipient = (Client)MessageTrackerHubConnector.this.getClientMap().get(recipientId);
                if (recipient == null) continue;
                String msgId = (String)entry.getValue();
                Transmission trans = new Transmission(sender, recipient, message, msgTag, msgId);
                MessageTrackerHubConnector.this.scheduleAddTransmission(trans, true);
                transList.add(trans);
            }
            final Transmission[] transmissions = transList.toArray(new Transmission[0]);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    cah.setTransmissions(transmissions);
                }
            });
            return callMap;
        }

        public Response callAndWait(String recipientId, Map msg, int timeout) throws SampException {
            Transmission trans;
            Client recipient = (Client)MessageTrackerHubConnector.this.getClientMap().get(recipientId);
            Transmission transmission = trans = recipient == null ? null : new Transmission(this.getSelfClient(), recipient, Message.asMessage(msg), "<synchronous>", "<synchronous>");
            if (trans != null) {
                MessageTrackerHubConnector.this.scheduleAddTransmission(trans, true);
            }
            try {
                Response response = super.callAndWait(recipientId, msg, timeout);
                if (trans != null) {
                    MessageTrackerHubConnector.this.scheduleSetResponse(trans, response);
                }
                return response;
            }
            catch (SampException e) {
                if (trans != null) {
                    MessageTrackerHubConnector.this.scheduleSetFailure(trans, e);
                }
                throw e;
            }
        }

        public void reply(final String msgId, final Map response) throws SampException {
            Throwable err;
            try {
                super.reply(msgId, response);
                err = null;
            }
            catch (Throwable e) {
                err = e;
            }
            final Throwable error = err;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int nt = MessageTrackerHubConnector.this.rxListModel_.getSize();
                    for (int i = 0; i < nt; ++i) {
                        Transmission trans = (Transmission)MessageTrackerHubConnector.this.rxListModel_.getElementAt(i);
                        if (!msgId.equals(trans.getMessageId())) continue;
                        trans.setResponse(Response.asResponse(response));
                        if (error != null) {
                            trans.setError(error);
                        }
                        return;
                    }
                    logger_.warning("Orphan reply " + msgId + " - replier programming error?");
                }
            });
        }

        public void setCallable(CallableClient callable) throws SampException {
            MessageTrackerCallableClient mtCallable = new MessageTrackerCallableClient(callable, this);
            super.setCallable(mtCallable);
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$gui$MessageTrackerHubConnector == null ? (class$org$astrogrid$samp$gui$MessageTrackerHubConnector = MessageTrackerHubConnector.class$("org.astrogrid.samp.gui.MessageTrackerHubConnector")) : class$org$astrogrid$samp$gui$MessageTrackerHubConnector).desiredAssertionStatus();
        }
    }
}

