/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TrendingData
implements Serializable {
    @XmlElement
    DataValue[] datavalue;
    @XmlElement
    AxisValue axisvalue;

    public void setAxisValue(AxisValue axisValue) {
        this.axisvalue = axisValue;
    }

    public void setDataValue(DataValue[] dataValue) {
        this.datavalue = dataValue;
    }

    public DataValue[] getDatavalue() {
        return this.datavalue;
    }

    public AxisValue getAxisvalue() {
        return this.axisvalue;
    }

    public double getValue(String name) {
        if (this.datavalue != null) {
            for (DataValue dv : this.datavalue) {
                if (!dv.getName().equals(name)) continue;
                return dv.getValue();
            }
        }
        return Double.NaN;
    }

    public String getStrValue(String name) {
        if (this.datavalue != null) {
            for (DataValue dv : this.datavalue) {
                if (!name.equals(dv.getName())) continue;
                return dv.getStrValue();
            }
        }
        return null;
    }

    public static class AxisValue {
        @XmlAttribute
        String name = "";
        @XmlAttribute
        long value;
        @XmlAttribute
        long loweredge;
        @XmlAttribute
        long upperedge;

        public AxisValue(String name, long value) {
            this.name = name;
            this.value = value;
            this.loweredge = value;
            this.upperedge = value;
        }

        public AxisValue(String name, long value, long loweredge, long upperedge) {
            this.name = name;
            this.value = value;
            this.loweredge = loweredge;
            this.upperedge = upperedge;
        }

        public AxisValue() {
        }

        public long getLoweredge() {
            return this.loweredge;
        }

        public String getName() {
            return this.name;
        }

        public long getUpperedge() {
            return this.upperedge;
        }

        public long getValue() {
            return this.value;
        }
    }

    public static class DataValue {
        @XmlAttribute
        String name = "";
        @XmlAttribute(required=true)
        double value;
        @XmlAttribute(required=false)
        String strValue;

        public DataValue(String name, double value) {
            this.name = name;
            this.value = value;
        }

        public DataValue(String name, String value) {
            this.name = name;
            this.strValue = value;
            this.value = 0.0;
        }

        public DataValue() {
        }

        public double getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String getStrValue() {
            return this.strValue;
        }
    }
}

