/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.ChillerPlcTestState;
import org.lsst.ccs.subsystem.refrig.ui.ChillerPlcControlPanel;

public class PlcTestControlPanel
extends JPanel
implements CommandSender.ReplyHandler,
UiUtilities.ActionHandler {
    private static final String CMND_GET_STATE = "getControlState";
    private static final int NUM_SWITCHES = 10;
    private final CommandSender sender;
    private final UiUtilities uiUtilities = new UiUtilities((UiUtilities.ActionHandler)this);
    private JPanel switchPanel;
    private final JLabel[] swStatus = new JLabel[10];
    private final JRadioButton[] swOnButton = new JRadioButton[10];
    private final JRadioButton[] swOffButton = new JRadioButton[10];
    private final ButtonGroup[] swButtonGroup = new ButtonGroup[10];
    private ChillerPlcControlPanel plcControlPanel;
    private static final long serialVersionUID = 1L;

    public PlcTestControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        ChillerPlcTestState ps = (ChillerPlcTestState)reply;
        this.updatePanel(ps);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void onCommandError(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void updatePanel(ChillerPlcTestState ps) {
        SwingUtilities.invokeLater(new UpdateRefrigState(ps));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        for (int sw = 0; sw < 10; ++sw) {
            this.swStatus[sw] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(SwitchState.class));
            this.swOnButton[sw] = this.uiUtilities.newRadioButton("On", "T" + sw);
            this.swOffButton[sw] = this.uiUtilities.newRadioButton("Off", "F" + sw);
            this.swButtonGroup[sw] = new ButtonGroup();
            this.swButtonGroup[sw].add(this.swOnButton[sw]);
            this.swButtonGroup[sw].add(this.swOffButton[sw]);
        }
        this.switchPanel = UiUtilities.newBorderedPanel((String)"Maq20 Switches");
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 17;
        gbs.insets = new Insets(0, 0, 4, 4);
        gbs.gridy = -1;
        int numColm = 2;
        int colm = 0;
        for (int sw = 0; sw < 10; ++sw) {
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = gbs.gridy == 0 ? 4 : 0;
            gbs.insets.left = colm == 0 ? 4 : 40;
            this.switchPanel.add((Component)UiUtilities.newLabel((String)("Maq20 line " + sw + ":"), (int)0), gbs);
            gbs.insets.left = 4;
            ++gbs.gridx;
            this.switchPanel.add((Component)this.swStatus[sw], gbs);
            ++gbs.gridx;
            this.switchPanel.add((Component)this.swOffButton[sw], gbs);
            ++gbs.gridx;
            this.switchPanel.add((Component)this.swOnButton[sw], gbs);
            ++gbs.gridx;
            colm = (colm + 1) % numColm;
        }
        this.plcControlPanel = new ChillerPlcControlPanel(this.sender);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(4, 0, 4, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.plcControlPanel, gbm);
    }

    public void handleRadioButton(String name) {
        char action = name.charAt(0);
        int sw = Integer.valueOf(name.substring(1));
        this.swOffButton[sw].setEnabled(false);
        this.swOnButton[sw].setEnabled(false);
        this.sender.sendCommand(null, "setPlcLatch", new Object[]{sw, action == 'T'});
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            for (int sw = 0; sw < 10; ++sw) {
                PlcTestControlPanel.this.swStatus[sw].setEnabled(false);
                PlcTestControlPanel.this.swOffButton[sw].setEnabled(false);
                PlcTestControlPanel.this.swOnButton[sw].setEnabled(false);
            }
            PlcTestControlPanel.this.plcControlPanel.disablePanel();
            PlcTestControlPanel.this.repaint();
        }
    }

    class UpdateRefrigState
    implements Runnable {
        private final ChillerPlcTestState ps;

        UpdateRefrigState(ChillerPlcTestState ps) {
            this.ps = ps;
        }

        @Override
        public void run() {
            for (int sw = 0; sw < 10; ++sw) {
                SwitchState state = this.ps.getSwitchState(sw);
                PlcTestControlPanel.this.swStatus[sw].setText(state.name());
                Color color = state == SwitchState.OFF ? Color.black : (state == SwitchState.ON ? UiConstants.GREEN : UiConstants.BLUE);
                PlcTestControlPanel.this.swStatus[sw].setForeground(color);
                JRadioButton selButton = state == SwitchState.ON ? PlcTestControlPanel.this.swOnButton[sw] : PlcTestControlPanel.this.swOffButton[sw];
                selButton.setSelected(true);
                PlcTestControlPanel.this.swStatus[sw].setEnabled(true);
                PlcTestControlPanel.this.swOffButton[sw].setEnabled(true);
                PlcTestControlPanel.this.swOnButton[sw].setEnabled(true);
            }
            PlcTestControlPanel.this.plcControlPanel.updatePanel(this.ps.getPlcState());
            PlcTestControlPanel.this.repaint();
        }
    }
}

