/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.plotter;

import jas.hist.JASHist;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.freehep.application.PropertyUtilities;
import org.freehep.graphicsbase.util.export.ExportFileType;

class PlotMLExportFileType
extends ExportFileType {
    private static final String SNAPSHOT = "snapshot";

    PlotMLExportFileType() {
    }

    public void exportToFile(File file, Component[] target, Component parent, Properties properties, String creator) throws IOException {
        FileWriter writer = new FileWriter(file);
        ((JASHist)target[0]).writeXML((Writer)writer, PropertyUtilities.getBoolean(properties, SNAPSHOT, true));
        ((Writer)writer).close();
    }

    public void exportToFile(OutputStream os, Component[] target, Component parent, Properties properties, String creator) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os);
        ((JASHist)target[0]).writeXML((Writer)writer, true);
        ((Writer)writer).close();
    }

    public String getDescription() {
        return "XML Plot File";
    }

    public String[] getExtensions() {
        return new String[]{"plotml"};
    }

    public String[] getMIMETypes() {
        return new String[]{"application/x-plotml"};
    }

    public JPanel createOptionPanel(Properties options) {
        return new OptionPanel(PropertyUtilities.getBoolean(options, SNAPSHOT, true));
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public boolean applyChangedOptions(JPanel custom, Properties options) {
        PropertyUtilities.setBoolean(options, SNAPSHOT, ((OptionPanel)custom).isSnapshot());
        return true;
    }

    private class OptionPanel
    extends JPanel {
        private JRadioButton button1;
        private JRadioButton button2;

        OptionPanel(boolean snapshot) {
            super(new GridLayout(0, 1));
            this.button1 = new JRadioButton("Save current snapshot of data", snapshot);
            this.button2 = new JRadioButton("Save reference to live data", !snapshot);
            this.add(this.button1);
            this.add(this.button2);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.button1);
            bg.add(this.button2);
        }

        boolean isSnapshot() {
            return this.button1.isSelected();
        }
    }
}

