/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.auxelex.Bfr;
import org.lsst.ccs.drivers.commons.DriverException;

public class BfrServer
extends Thread {
    public static final int PORT = 8000;
    public static final int NUM_PORTS = 4;
    public static final InetAddress IP = InetAddress.getLoopbackAddress();
    private static final Logger LOG = Logger.getLogger(BfrServer.class.getName());
    private static Map<Integer, BfrServer> servers = Collections.synchronizedMap(new HashMap());
    private Bfr bfr;
    private ServerSocket socket;
    private volatile boolean stopping = false;
    private Set<RequestThread> rqstThreads = Collections.synchronizedSet(new HashSet());

    public BfrServer(Bfr bfr) throws DriverException {
        this.bfr = bfr;
        try {
            this.socket = new ServerSocket(BfrServer.getServerPort(bfr.getNode()), 4, IP);
        }
        catch (IOException e) {
            throw new DriverException("Error creating BFR server socket", (Throwable)e);
        }
    }

    public static void startServer(Bfr bfr) throws DriverException {
        if (!servers.keySet().contains(bfr.getNode())) {
            BfrServer server = new BfrServer(bfr);
            server.setDaemon(true);
            server.start();
            servers.put(bfr.getNode(), server);
        }
    }

    public static void stopServer(int node) {
        BfrServer server = servers.get(node);
        if (server != null) {
            server.stopRun();
            servers.remove(node);
        }
    }

    public static int getServerPort(int node) {
        return 8000 + node;
    }

    @Override
    public void run() {
        try {
            while (true) {
                Socket rqstSocket = this.socket.accept();
                RequestThread thread = new RequestThread(rqstSocket);
                this.rqstThreads.add(thread);
                thread.setDaemon(true);
                thread.start();
            }
        }
        catch (IOException e) {
            if (!this.stopping) {
                LOG.log(Level.SEVERE, "Error accepting incoming BFR server connection", e);
            }
            for (RequestThread rqstThread : this.rqstThreads) {
                rqstThread.stopRun();
            }
            return;
        }
    }

    public void stopRun() {
        try {
            this.stopping = true;
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class RequestThread
    extends Thread {
        private ObjectInputStream inStream;
        private ObjectOutputStream outStream;
        private volatile boolean stopping = false;

        public RequestThread(Socket socket) {
            try {
                this.outStream = new ObjectOutputStream(socket.getOutputStream());
                this.outStream.flush();
                this.inStream = new ObjectInputStream(socket.getInputStream());
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Error creating BFR server request streams", e);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void stopRun() {
            try {
                this.stopping = true;
                this.inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class Reply
    implements Serializable {
        double[] values;
        DriverException ex;
        private static final long serialVersionUID = -3339762080987937239L;

        Reply(double[] values) {
            this.values = values;
            this.ex = null;
        }

        Reply(DriverException ex) {
            this.values = null;
            this.ex = ex;
        }
    }

    public static class Request
    implements Serializable {
        int address;
        int sensor;
        int count;
        private static final long serialVersionUID = 1104232295274389306L;

        public Request(int address, int sensor, int count) {
            this.address = address;
            this.sensor = sensor;
            this.count = count;
        }
    }
}

