/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida.function;

import hep.aida.IFunction;
import hep.aida.ref.function.BaseModelFunction;
import hep.aida.ref.function.ExponentialCoreNotNorm;
import hep.aida.ref.function.FunctionCore;
import hep.aida.ref.plotter.adapter.AIDAFunctionAdapter;
import jas.hist.Basic1DFunction;
import jas.hist.FunctionFactoryError;
import jas.hist.InvalidFunctionParameter;
import jas.hist.JASHist;
import org.freehep.jas.extension.aida.function.AbstractFunctionFactory;

public class ExponentialFunctionFactory
extends AbstractFunctionFactory {
    public ExponentialFunctionFactory() {
        super("Exponential");
    }

    public Basic1DFunction createFunction(JASHist h) throws FunctionFactoryError {
        double xMin = h.getXAxis().getMin();
        double xMax = h.getXAxis().getMax();
        double yMin = h.getYAxis().getMin();
        double yMax = h.getYAxis().getMax();
        ExponentialFunction c = new ExponentialFunction(xMin, xMax, yMin, yMax);
        this.chooseName(c, h);
        return c;
    }

    private class ExponentialFunction
    extends AIDAFunctionAdapter {
        public ExponentialFunction(double xMin, double xMax, double yMin, double yMax) {
            super((IFunction)new BaseModelFunction("exp", "", (FunctionCore)new ExponentialCoreNotNorm("exp"), null));
            try {
                double a = yMin + (yMax - yMin) * 0.8;
                double b = xMin + (xMax - xMin) * 0.8;
                this.setParameter(0, a);
                this.setParameter(1, 1.0 / b * Math.log(Math.abs(yMin / a) + 2.0));
            }
            catch (InvalidFunctionParameter ifp) {
                throw new RuntimeException("Invalid parameter");
            }
        }
    }
}

