/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeUtils;

public class AgentPropertyPredicate
implements Predicate<AgentInfo> {
    private final Map<String, String> properties;

    public AgentPropertyPredicate(String propertiesStr) {
        this(propertiesStr, new HashMap<String, String>());
    }

    public AgentPropertyPredicate(String propertiesStr, Map<String, String> replacements) {
        for (Map.Entry<String, String> e : replacements.entrySet()) {
            String wild = "${" + e.getKey() + "}";
            propertiesStr = propertiesStr.replace(wild, e.getValue());
        }
        this.properties = (Map)InputConversionEngine.convertArgToType((String)propertiesStr, Map.class);
    }

    public AgentPropertyPredicate(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public boolean test(AgentInfo agent) {
        for (Map.Entry<String, String> e : this.properties.entrySet()) {
            String property = e.getKey();
            String propertyValue = e.getValue();
            if (propertyValue == null || propertyValue.isEmpty() || propertyValue.equals(agent.getAgentProperty(property))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return TypeUtils.stringify(this.properties);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.properties);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentPropertyPredicate other = (AgentPropertyPredicate)obj;
        return Objects.equals(this.properties, other.properties);
    }
}

