/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import org.lsst.ccs.utilities.reflect.AmbiguousConstructorException;

public class ConstructorUtils {
    public static Class NULL_CLASS = NullObject.class;

    private ConstructorUtils() {
    }

    public static Constructor getMatchingConstructor(Class<?> klass, Class<?>[] argumentsClasses) {
        Constructor<?>[] ctors = klass.getConstructors();
        HashSet varargsCtors = new HashSet();
        ArrayList<Constructor> validConstructors = new ArrayList<Constructor>();
        for (Constructor<?> c : ctors) {
            if (c.isVarArgs()) {
                varargsCtors.add(c);
                continue;
            }
            if (!ConstructorUtils.constructorMatches(c, argumentsClasses)) continue;
            validConstructors.add(c);
        }
        if (validConstructors.size() == 1) {
            return (Constructor)validConstructors.get(0);
        }
        if (validConstructors.size() > 1) {
            throw new AmbiguousConstructorException("ambiguous constructors : " + validConstructors);
        }
        for (Constructor constructor : varargsCtors) {
            if (!ConstructorUtils.varArgsConstructorMatches(constructor, argumentsClasses)) continue;
            validConstructors.add(constructor);
        }
        if (validConstructors.size() == 1) {
            return (Constructor)validConstructors.get(0);
        }
        if (validConstructors.size() > 1) {
            throw new AmbiguousConstructorException("ambiguous constructors : " + validConstructors);
        }
        return null;
    }

    private static boolean typeMatch(Class to, Class from) {
        if (to.isAssignableFrom(from)) {
            return true;
        }
        if (!to.isPrimitive() && from == NULL_CLASS) {
            return true;
        }
        if (to.isPrimitive() && from.isPrimitive()) {
            return ConstructorUtils.bothDifferentPrimitiveTypeMatch(to, from);
        }
        if (to.isPrimitive()) {
            return ConstructorUtils.assignToPrimitiveTypeMatch(to, from);
        }
        if (from.isPrimitive()) {
            return ConstructorUtils.assignFromPrimitiveTypeMatch(to, from);
        }
        return false;
    }

    private static boolean assignFromPrimitiveTypeMatch(Class to, Class from) {
        return Integer.TYPE.equals(from) && to.isAssignableFrom(Integer.class) || Long.TYPE.equals(from) && to.isAssignableFrom(Long.class) || Double.TYPE.equals(from) && to.isAssignableFrom(Double.class) || Character.TYPE.equals(from) && to.isAssignableFrom(Character.class) || Short.TYPE.equals(from) && to.isAssignableFrom(Short.class) || Boolean.TYPE.equals(from) && to.isAssignableFrom(Boolean.class) || Byte.TYPE.equals(from) && to.isAssignableFrom(Byte.class);
    }

    private static boolean assignToPrimitiveTypeMatch(Class to, Class from) {
        return Boolean.TYPE.equals(to) && from.equals(Boolean.class) || Byte.TYPE.equals(to) && from.equals(Byte.class) || Character.TYPE.equals(to) && from.equals(Character.class) || Short.TYPE.equals(to) && (from.equals(Byte.class) || from.equals(Short.class)) || Integer.TYPE.equals(to) && (from.equals(Byte.class) || from.equals(Short.class) || from.equals(Character.class) || from.equals(Integer.class)) || Long.TYPE.equals(to) && (from.equals(Byte.class) || from.equals(Short.class) || from.equals(Character.class) || from.equals(Integer.class) || from.equals(Long.class)) || Double.TYPE.equals(to) && (from.equals(Byte.class) || from.equals(Short.class) || from.equals(Character.class) || from.equals(Integer.class) || from.equals(Long.class) || from.equals(Double.class));
    }

    private static boolean bothDifferentPrimitiveTypeMatch(Class to, Class from) {
        if (Boolean.TYPE.equals(from)) {
            return false;
        }
        if (Double.TYPE.equals(to)) {
            return true;
        }
        return Long.TYPE.equals(to) && !Double.TYPE.equals(from) || Integer.TYPE.equals(to) && !Double.TYPE.equals(from) && !Long.TYPE.equals(from) || Short.TYPE.equals(to) && (Character.TYPE.equals(from) || Byte.TYPE.equals(from));
    }

    private static boolean constructorMatches(Constructor c, Class[] parameterClasses) {
        Class<?>[] constructorArgumentClasses = c.getParameterTypes();
        if (constructorArgumentClasses.length != parameterClasses.length) {
            return false;
        }
        for (int i = 0; i < parameterClasses.length; ++i) {
            if (ConstructorUtils.typeMatch(constructorArgumentClasses[i], parameterClasses[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean varArgsConstructorMatches(Constructor c, Class[] parameterClasses) {
        Parameter[] arguments = c.getParameters();
        for (int i = 0; i < arguments.length - 1; ++i) {
            if (ConstructorUtils.typeMatch(arguments[i].getType(), parameterClasses[i])) continue;
            return false;
        }
        int varargsIndex = arguments.length - 1;
        Class<?> varargType = arguments[varargsIndex].getType().getComponentType();
        for (int i = varargsIndex; i < parameterClasses.length; ++i) {
            if (ConstructorUtils.typeMatch(varargType, parameterClasses[i])) continue;
            return false;
        }
        return true;
    }

    public static Type getParameterType(Constructor c, int index) {
        int parmLength = c.getParameterCount();
        if (index < parmLength - 1) {
            return c.getParameters()[index].getParameterizedType();
        }
        Parameter lastParm = c.getParameters()[parmLength - 1];
        if (lastParm.isVarArgs()) {
            return lastParm.getType().getComponentType();
        }
        if (index == parmLength - 1) {
            return lastParm.getParameterizedType();
        }
        throw new IllegalArgumentException("index is greater than the number of arguments");
    }

    private static class NullObject {
        private NullObject() {
        }
    }
}

