/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.freehep.util.VersionComparator;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.ResourcesUtils;
import org.lsst.ccs.bootstrap.SubstitutionTokenUtils;
import org.lsst.ccs.bootstrap.SystemPropertyMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class Bootstrap {
    private Options bootstrapCommandLineOptions;
    private final List<String> additionalCommandLineArguments = new ArrayList<String>();
    private final List<String> passedAlongOptions = new ArrayList<String>();
    private static String bootstrapApplication = null;
    private static URLClassLoader applicationClassLoader = null;
    private boolean printHelp = false;
    private boolean listApplications = false;
    private boolean showDistributionInfo = false;
    private static boolean verbose = false;
    static final String APPLICATION_OPTION = "application";
    static final String HELP_OPTION = "help";
    static final String VERBOSE_OPTION = "verbose";
    static final String LIST_APPLICATIONS_OPTION = "listApplications";
    private String showProperties = null;
    private boolean showClasspath = false;
    private static final String APPLICATION_ARGS_PROPERTY = "org.lsst.ccs.application.args";
    private static final String APPLICATION_DESCRIPTION_PROPERTY = "org.lsst.ccs.application.description";
    private static final String APPLICATION_ENFORCE_USERNAME_PROPERTY = "org.lsst.ccs.application.enforce.username";
    private static Properties bootstrapCmdLineProperties = new Properties();
    private static Map<String, String> additionalClassPathEntriesMap = new HashMap<String, String>();
    private static List<String> additionalClassPathEntriesList = new ArrayList<String>();
    private static Properties bootstrapApplicationProperties = null;
    private static final String BOOTSTRAP_ENVIRONMENT_PROPERTY = "org.lsst.ccs.bootstrap.environment";
    private static String distributionMainJar = null;
    private static boolean quiet = false;
    static Class loaderClass = BootstrapUtils.class;
    protected static final String defaultDebugPort = "4000";
    private static boolean isDebugMode = false;
    private static String debugPort = null;
    private static final Pattern cmdLinePattern = Pattern.compile("[^\\s]*\"(\\\\+\"|[^\"])*?\"|[^\\s]*'(\\\\+'|[^'])*?'|(\\\\\\s|[^\\s])+", 8);
    private static final Logger LOG = Logger.getLogger(Bootstrap.class.getName());

    Bootstrap() {
        this(false);
    }

    Bootstrap(boolean quiet) {
        Bootstrap.quiet = quiet;
        this.bootstrapCommandLineOptions = new Options();
        this.bootstrapCommandLineOptions.addOption("h", HELP_OPTION, false, "Print the help message");
        this.bootstrapCommandLineOptions.addOption("v", VERBOSE_OPTION, false, "Turns on verbose statements");
        this.bootstrapCommandLineOptions.addOption("la", LIST_APPLICATIONS_OPTION, false, "List the available CCS applications in this distribution");
        this.bootstrapCommandLineOptions.addOption("app", APPLICATION_OPTION, true, "The APPLICATION to be launched");
        this.getOption(APPLICATION_OPTION).setArgName("APPLICATION");
        OptionBuilder.withArgName("SystemProperty=Value");
        OptionBuilder.hasArgs(2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription("Set the Value of a SystemProperty.");
        Option sysProperty = OptionBuilder.create("D");
        this.bootstrapCommandLineOptions.addOption(sysProperty);
        this.bootstrapCommandLineOptions.addOption("di", "distInfo", false, "Show information on current distribution.");
        this.bootstrapCommandLineOptions.addOption("sp", "showProperties", true, "Show the properties for <FILE_NAME>.");
        this.getOption("showProperties").setArgName("FILE_NAME");
        this.bootstrapCommandLineOptions.addOption("scp", "showClasspath", false, "Show the classpath for the given application.");
        this.bootstrapCommandLineOptions.addOption("d", "debug", true, "Turn on Java debugging for the specified port. Default port is 4000.");
        this.getOption("debug").setOptionalArg(true);
        this.bootstrapCommandLineOptions.addOption("wd", "waitForDebugger", false, "Suspend application to wait for debugger to connect.");
    }

    static void resetBootstrap() {
        bootstrapCmdLineProperties = new Properties();
        additionalClassPathEntriesMap = new HashMap<String, String>();
        additionalClassPathEntriesList = new ArrayList<String>();
        bootstrapApplication = null;
        BootstrapUtils.reset();
    }

    static Class getLoaderClass() {
        return loaderClass;
    }

    protected static void setBootstrapApplication(String app) {
        bootstrapApplication = app;
    }

    static synchronized Properties getBootstrapApplicationProperties() {
        if (bootstrapApplicationProperties == null) {
            bootstrapApplicationProperties = BootstrapUtils.getApplicationDefinitionProperties(Bootstrap.getBootstrapApplication());
        }
        return bootstrapApplicationProperties;
    }

    List<String> getAdditionalCommandLineArguments() {
        return this.additionalCommandLineArguments;
    }

    CommandLine parseCommandLineArguments(String[] args) throws ParseException {
        Option[] opts;
        List<String>[] splitArgs = BootstrapResourceUtils.separateArgumentsForOptions(args, this.bootstrapCommandLineOptions);
        List<String> argumentsToParse = splitArgs[0];
        this.additionalCommandLineArguments.addAll(splitArgs[1]);
        String[] newArgs = argumentsToParse.toArray(new String[argumentsToParse.size()]);
        BasicParser parser = new BasicParser();
        CommandLine line = parser.parse(this.bootstrapCommandLineOptions, newArgs, false);
        if (line.hasOption(APPLICATION_OPTION)) {
            String tmpApp = line.getOptionValue(APPLICATION_OPTION);
            if (BootstrapResourceUtils.findMatchingResources(".*" + tmpApp + "\\..*").isEmpty()) {
                throw new IllegalArgumentException("Application name:  " + tmpApp + " is not a valid value.");
            }
            Set<String> apps = BootstrapResourceUtils.findMatchingResources(".*" + tmpApp + "\\.properties");
            if (!apps.isEmpty()) {
                for (String app : apps) {
                    try {
                        InputStream is = BootstrapResourceUtils.getBootstrapResource(app);
                        try {
                            if (is == null) continue;
                            Properties p = new Properties();
                            try {
                                p.load(is);
                                String applicationMainClassName = p.getProperty("org.lsst.ccs.application.mainClass");
                                if (applicationMainClassName == null) continue;
                                LOG.log(Level.WARNING, "Application definition files with extension \".properties\" have discontinued.\n Please change the file extension to \".app\".\nThese are the files that were found: " + app);
                            }
                            catch (IOException applicationMainClassName) {
                                // empty catch block
                            }
                        }
                        finally {
                            if (is == null) continue;
                            is.close();
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("Could not close resource ", ioe);
                    }
                }
            }
            bootstrapApplication = tmpApp;
        }
        if (line.hasOption("debug")) {
            debugPort = line.getOptionValue("debug", defaultDebugPort);
            isDebugMode = true;
            String suspend = line.hasOption("waitForDebugger") ? "y" : "n";
            bootstrapCmdLineProperties.put("system.option.Xdebug", "");
            bootstrapCmdLineProperties.put("system.option.Xrunjdwp:server=y,transport=dt_socket,address=" + debugPort + ",suspend=" + (String)suspend, "");
        }
        if (line.hasOption(HELP_OPTION)) {
            this.printHelp = true;
        }
        for (String argToParse : argumentsToParse) {
            if (line.getArgList().contains(argToParse)) continue;
            this.additionalCommandLineArguments.remove(argToParse);
        }
        this.showClasspath = line.hasOption("showClasspath");
        if (line.hasOption("showProperties") && this.showProperties == null) {
            this.showProperties = line.getOptionValue("showProperties");
        }
        if (line.hasOption(LIST_APPLICATIONS_OPTION)) {
            this.listApplications = true;
        }
        verbose = line.hasOption(VERBOSE_OPTION);
        if (this.printHelp && !this.passedAlongOptions.contains("-help")) {
            this.passedAlongOptions.add("-help");
        }
        if (verbose && !this.passedAlongOptions.contains("-verbose")) {
            this.passedAlongOptions.add("-verbose");
        }
        Properties cmdLineProperties = line.getOptionProperties("D");
        for (Option opt : opts = line.getOptions()) {
            boolean wasSet;
            if (!opt.getOpt().equals("D")) continue;
            boolean bl = wasSet = opt.getValuesList().size() == 2;
            if (wasSet) continue;
            cmdLineProperties.setProperty(opt.getValue(), "");
        }
        if (Bootstrap.verbose() && !quiet && !cmdLineProperties.isEmpty()) {
            LOG.info("\n*** Adding the following command line properties to the Properties:");
            Set<Object> keys = cmdLineProperties.keySet();
            for (Object key : keys) {
                LOG.info("\t" + key + " = " + cmdLineProperties.getProperty((String)key));
            }
        }
        if (!cmdLineProperties.isEmpty()) {
            bootstrapCmdLineProperties.putAll((Map<?, ?>)cmdLineProperties);
            System.getProperties().putAll((Map<?, ?>)cmdLineProperties);
        }
        if (line.hasOption("distInfo")) {
            this.showDistributionInfo = true;
        }
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        for (String additional : this.additionalCommandLineArguments) {
            SystemPropertyMatcher m = SystemPropertyMatcher.matcher(additional);
            if (!m.matches()) continue;
            toBeRemoved.add(additional);
            bootstrapCmdLineProperties.put(m.getProperty(), m.getValue());
            System.getProperties().put(m.getProperty(), m.getValue());
        }
        for (String remove : toBeRemoved) {
            this.additionalCommandLineArguments.remove(remove);
        }
        return line;
    }

    static Properties getCmdLineProperties() {
        return bootstrapCmdLineProperties;
    }

    static String getBootstrapApplication() {
        return bootstrapApplication != null ? bootstrapApplication : System.getProperty("org.lsst.ccs.application.name", null);
    }

    private boolean doPrintHelp() {
        return this.printHelp;
    }

    static boolean verbose() {
        return verbose;
    }

    static boolean isQuiet() {
        return quiet;
    }

    Options getBootstrapCommandLineOptions() {
        return this.bootstrapCommandLineOptions;
    }

    private static String getBootstrapClassLoader() {
        URL[] urls = Bootstrap.getBootstrapApplicationClassLoader().getURLs();
        StringBuilder output = new StringBuilder();
        output.append("*** CLASSPATH").append("\n");
        for (URL url : urls) {
            output.append("\t\t").append(url).append("\n");
        }
        return output.toString();
    }

    private Option getOption(String opt) {
        return this.getBootstrapCommandLineOptions().getOption(opt);
    }

    protected String[] getApplicationArguments(Properties appProperties) throws ParseException {
        String applicationArgs = appProperties.getProperty(APPLICATION_ARGS_PROPERTY, "").trim();
        Matcher matcher = cmdLinePattern.matcher(applicationArgs);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        String[] parsedArguments = matches.toArray(new String[0]);
        int nArgs = this.passedAlongOptions.size() + this.additionalCommandLineArguments.size() + parsedArguments.length;
        String[] mainArgs = new String[nArgs];
        int argCount = 0;
        for (String opt : this.passedAlongOptions) {
            mainArgs[argCount++] = opt;
        }
        for (String cmdArg : this.additionalCommandLineArguments) {
            mainArgs[argCount++] = cmdArg;
        }
        for (String arg : parsedArguments) {
            mainArgs[argCount++] = arg;
        }
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            StringBuilder output = new StringBuilder();
            output.append("*** Command line arguments passed to the mainClass: ");
            for (String arg : mainArgs) {
                output.append(arg + " ");
            }
            output.append("\n");
            LOG.info(output.toString());
        }
        return mainArgs;
    }

    static URLClassLoader getBootstrapApplicationClassLoader() {
        if (applicationClassLoader == null) {
            Bootstrap.buildBootstrapClassLoader();
        }
        return applicationClassLoader;
    }

    private static void scanPropertiesForClassPathEntries(Properties props) {
        Set<Object> keySet = BootstrapResourceUtils.getAllKeysInProperties(props);
        for (Object obj : keySet) {
            String key = (String)obj;
            if (!key.endsWith("additional.classpath.entry")) continue;
            String entry = props.getProperty(key);
            if (additionalClassPathEntriesMap.containsKey(key)) {
                if (quiet) continue;
                System.err.println("*** [WARNING] ignoring additional classpath entry: " + key + "=" + entry + " it was already added to the CLASSPATH as " + additionalClassPathEntriesMap.get(key));
                continue;
            }
            additionalClassPathEntriesMap.put(key, entry);
            additionalClassPathEntriesList.add(entry);
        }
    }

    private static synchronized void buildBootstrapClassLoader() {
        if (applicationClassLoader != null) {
            throw new RuntimeException("The Bootstrap ClassLoader has already been built. Please report this problem.");
        }
        ArrayList<URL> classPathUrlList = new ArrayList<URL>();
        if (bootstrapApplication != null) {
            Bootstrap.scanPropertiesForClassPathEntries(Bootstrap.getBootstrapApplicationProperties());
        }
        try {
            String userProvidedDistributionDirs = BootstrapUtils.getUserProvidedDistributionDirectories();
            List<String> additionalDistributionJarDirs = BootstrapUtils.extractDirectoriesFromPath(userProvidedDistributionDirs, null, true);
            boolean checkForVersionIncompatibilities = additionalDistributionJarDirs.size() > 0;
            ClassPathBuilderSupport cpSupport = new ClassPathBuilderSupport();
            String applicationMainJar = Bootstrap.getDistributionMainJar();
            File jar = null;
            if (applicationMainJar != null) {
                jar = new File(applicationMainJar);
                classPathUrlList.add(jar.toURI().toURL());
            }
            for (String classPathEntry : additionalClassPathEntriesList) {
                File cpEntryFile = new File(classPathEntry);
                if (cpEntryFile.isDirectory()) {
                    if (quiet) continue;
                    System.err.println("*** [WARNING] Directories cannot be added to the classpath as additional Classpath entries. Skipping " + classPathEntry);
                    continue;
                }
                classPathUrlList.add(cpEntryFile.toURI().toURL());
            }
            if (checkForVersionIncompatibilities && jar != null) {
                Bootstrap.scanManifestForClassPathElements(jar, cpSupport);
            }
            for (String dir : additionalDistributionJarDirs) {
                String additionalMainJar = Bootstrap.getDistributionMainJar(dir);
                File mainjar = new File(additionalMainJar);
                classPathUrlList.add(mainjar.toURI().toURL());
                if (!checkForVersionIncompatibilities) continue;
                Bootstrap.scanManifestForClassPathElements(mainjar, cpSupport);
            }
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("Failed to build URL when building the classpath: " + mue.getMessage());
        }
        URL[] classpathUrls = new URL[classPathUrlList.size()];
        int count = 0;
        for (URL classpathURl : classPathUrlList) {
            classpathUrls[count++] = classpathURl;
        }
        applicationClassLoader = new URLClassLoader(classpathUrls);
    }

    private static String getDistributionMainJar(String distribution) {
        File distributionDefinitionFile = new File(BootstrapUtils.getDistributionResourcesDirectory(distribution) + "DIST-INF/distribution.xml");
        if (!distributionDefinitionFile.exists()) {
            throw new RuntimeException("FATAL: Cannot run distribution " + distribution + " as it does not contain the distribution definition xml file");
        }
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(distributionDefinitionFile);
            Element rootEl = doc.getDocumentElement();
            return BootstrapUtils.getDistributionJarFilesDirectory(distribution) + rootEl.getAttribute("mainJar");
        }
        catch (IOException | ParserConfigurationException | SAXException pce) {
            throw new RuntimeException(pce);
        }
    }

    protected static String getDistributionMainJar() {
        if (distributionMainJar == null) {
            distributionMainJar = Bootstrap.getDistributionMainJar(BootstrapUtils.getCCSDistributionRootDirectory());
        }
        return distributionMainJar;
    }

    private void launchCCSApplication(String applicationName) {
        Properties allProps;
        String usernameToEnforce;
        String applicationMainClassName;
        Properties applicationProperties = BootstrapUtils.getApplicationDefinitionProperties(applicationName);
        if (this.doPrintHelp()) {
            String appDescription = applicationProperties.getProperty(APPLICATION_DESCRIPTION_PROPERTY, "");
            System.out.println("\n\tCCS Application " + applicationName + " " + appDescription + "\n");
        }
        if ((applicationMainClassName = applicationProperties.getProperty("org.lsst.ccs.application.mainClass")) == null) {
            throw new RuntimeException("*** Application " + applicationName + " must define the main Class to launch. This can be done either in the Manifest of the main jar or by defining the property org.lsst.ccs.application.mainClass in its definition file. ");
        }
        if (Bootstrap.verbose() && Bootstrap.isQuiet()) {
            StringBuilder output = new StringBuilder();
            output.append("*** Distribution Root: ").append(BootstrapUtils.getCCSDistributionRootDirectory()).append("\n");
            output.append("*** Application name: ").append(applicationName).append("\n");
            output.append("*** MainClass: ").append(applicationMainClassName).append("\n");
            output.append("*** LD_LIBRARY_PATH: ").append(System.getenv("LD_LIBRARY_PATH")).append("\n");
            LOG.info(output.toString());
        }
        if (!(usernameToEnforce = (allProps = BootstrapResourceUtils.getBootstrapProperties(applicationName)).getProperty(APPLICATION_ENFORCE_USERNAME_PROPERTY, "")).equals("") && !System.getProperty("user.name").equals(usernameToEnforce)) {
            throw new RuntimeException("Application " + applicationName + " cannot run under account " + System.getProperty("user.name") + ". It must run under account " + usernameToEnforce + ".");
        }
        try {
            Class<?> applicationMainClass = Class.forName(applicationMainClassName);
            try {
                Method applicationMainMethod = applicationMainClass.getMethod("main", String[].class);
                String[] mainArgs = this.getApplicationArguments(applicationProperties);
                if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                    LOG.info(Bootstrap.getBootstrapClassLoader());
                }
                try {
                    applicationMainMethod.invoke(null, new Object[]{mainArgs});
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOG.log(Level.SEVERE, "*** Failed to invoke main method in class " + applicationMainClassName, e);
                    System.exit(1);
                }
                catch (InvocationTargetException e) {
                    LOG.log(Level.SEVERE, "*** Execution failed", e);
                    System.exit(1);
                }
            }
            catch (NoSuchMethodException | SecurityException | ParseException e) {
                LOG.log(Level.SEVERE, "*** Could not access the main method in class " + applicationMainClassName, e);
                System.exit(1);
            }
        }
        catch (ClassNotFoundException cnfe) {
            StringBuilder output = new StringBuilder();
            output.append("*** Could not find class ").append(applicationMainClassName).append(" in the following classpath: ").append("\n");
            output.append(Bootstrap.getBootstrapClassLoader());
            output.append("*************************************************************************\n");
            LOG.log(Level.SEVERE, output.toString(), cnfe);
            System.exit(1);
        }
    }

    public static void main(String[] args) throws Exception {
        boolean doneSomething;
        Bootstrap bootstrap;
        block11: {
            String applicationName;
            block14: {
                block16: {
                    List<String> availableApplications;
                    block15: {
                        block13: {
                            block12: {
                                block10: {
                                    String hostname = InetAddress.getLocalHost().getHostName();
                                    if (hostname.contains(".")) {
                                        hostname = hostname.substring(0, hostname.indexOf("."));
                                    }
                                    SubstitutionTokenUtils.addSubstitutionToken("host", hostname);
                                    System.setProperty(BOOTSTRAP_ENVIRONMENT_PROPERTY, "true");
                                    bootstrap = new Bootstrap();
                                    bootstrap.parseCommandLineArguments(args);
                                    applicationName = Bootstrap.getBootstrapApplication();
                                    if (applicationName != null) {
                                        SubstitutionTokenUtils.addSubstitutionToken("app", applicationName);
                                    }
                                    if (bootstrap.doPrintHelp()) {
                                        System.out.println("\n\tCCS Bootstrap Help \n");
                                        Bootstrap.printHelp(bootstrap.getBootstrapCommandLineOptions());
                                    }
                                    doneSomething = false;
                                    if (!bootstrap.showClasspath) break block10;
                                    if (Bootstrap.getBootstrapApplication() == null) {
                                        throw new IllegalArgumentException("To display the content of the classpath you have to provide an application with the --app option");
                                    }
                                    System.out.println(Bootstrap.getBootstrapClassLoader());
                                    doneSomething = true;
                                    break block11;
                                }
                                if (bootstrap.showProperties == null) break block12;
                                if (Bootstrap.getBootstrapApplication() == null) {
                                    throw new IllegalArgumentException("To display the content of a properties file you have to provide an application with the --app option");
                                }
                                ResourcesUtils.printProperties(BootstrapResourceUtils.getBootstrapProperties(bootstrap.showProperties));
                                doneSomething = true;
                                break block11;
                            }
                            if (!bootstrap.showDistributionInfo) break block13;
                            Bootstrap.printDistributionInfo();
                            doneSomething = true;
                            break block11;
                        }
                        if (!bootstrap.listApplications) break block14;
                        availableApplications = BootstrapUtils.getBootstrapListOfApplications();
                        Collections.sort(availableApplications);
                        if (!availableApplications.isEmpty()) break block15;
                        System.out.println("No CCS applications are defined in the current distribution.");
                        if (!bootstrap.verbose()) break block16;
                        if (bootstrap.isQuiet()) break block16;
                        System.out.println(BootstrapUtils.getDistributionResourcesDirectory());
                        break block16;
                    }
                    System.out.println("Available CCS applications :");
                    if (bootstrap.verbose()) {
                        if (!bootstrap.isQuiet()) {
                            System.out.println(BootstrapUtils.getDistributionResourcesDirectory());
                        }
                    }
                    for (String application : availableApplications) {
                        Properties applicationProps = BootstrapUtils.getApplicationDefinitionProperties(application);
                        System.out.println("\t" + application + "\t" + applicationProps.getProperty(APPLICATION_DESCRIPTION_PROPERTY));
                    }
                }
                doneSomething = true;
                break block11;
            }
            if (applicationName != null) {
                bootstrap.launchCCSApplication(applicationName);
                doneSomething = true;
            }
        }
        if (!doneSomething) {
            System.out.println("\n*** The Bootstrap could not do anything with the provided options.");
            Bootstrap.printHelp(bootstrap.getBootstrapCommandLineOptions());
        }
    }

    private static void printHelp(Options o) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "CCSbootstrap", "", o, "", true);
    }

    private static void printDistributionInfo() {
        System.out.println("\n*** Distribution info");
        System.out.println("\tDistribution path: " + BootstrapUtils.getCCSDistributionRootDirectory());
        System.out.println("\tResources ordered search path: ");
        List<String> distSearchPathList = BootstrapUtils.getOrderedListOfResourceDirectories();
        Object resourcesDirList = "";
        StringBuilder b = new StringBuilder();
        for (String dir : distSearchPathList) {
            BootstrapUtils.ExternalResourceDirectory extDir = BootstrapUtils.getExternalResourceDir(dir);
            Object tmpDir = dir;
            if (!extDir.getExtensionsSet().isEmpty()) {
                tmpDir = (String)tmpDir + " " + extDir.getExtensions();
            }
            if (!extDir.exists()) {
                tmpDir = (String)tmpDir + " (missing)";
            }
            b.append("\t\t").append((String)tmpDir).append("\n");
        }
        resourcesDirList = (String)resourcesDirList + b.toString();
        System.out.print((String)resourcesDirList);
    }

    static boolean isBootstrapEnvironment() {
        return "true".equals(System.getProperty(BOOTSTRAP_ENVIRONMENT_PROPERTY));
    }

    protected boolean isInDebugMode() {
        return isDebugMode;
    }

    protected String getDebugPort() {
        return debugPort != null ? debugPort : defaultDebugPort;
    }

    private static void scanManifestForClassPathElements(File file, ClassPathBuilderSupport cp) {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            String manifestClassPath = manifest.getMainAttributes().getValue("Class-Path").trim();
            File parentDir = file.getParentFile();
            StringTokenizer classPathTokens = new StringTokenizer(manifestClassPath, " ");
            while (classPathTokens.hasMoreTokens()) {
                String manifestClassPathJar = classPathTokens.nextToken();
                cp.addClasspathEntry(parentDir.getAbsolutePath(), manifestClassPathJar);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static class ClassPathBuilderSupport {
        private HashMap<String, ClassPathElementWithVersion> classPathEntries = new HashMap();

        private ClassPathBuilderSupport() {
        }

        void addClasspathEntry(String resourceDir, String fileName) {
            String jarName = VersionComparator.stripVersion(fileName);
            ClassPathElementWithVersion existingEntry = this.classPathEntries.get(jarName);
            ClassPathElementWithVersion newEntry = new ClassPathElementWithVersion(resourceDir, fileName);
            if (existingEntry == null) {
                this.classPathEntries.put(jarName, newEntry);
            } else if (!existingEntry.fileName.equals(newEntry.fileName) && !quiet) {
                StringBuilder output = new StringBuilder();
                output.append("WARNING Classpath entry version conflict: ").append("\n");
                output.append("\t ").append(newEntry.resourceDir).append(BootstrapUtils.FILE_SEPARATOR).append(newEntry.fileName).append("\n");
                output.append("\t ").append(existingEntry.resourceDir).append(BootstrapUtils.FILE_SEPARATOR).append(existingEntry.fileName).append("\n");
                LOG.severe(output.toString());
            }
        }

        Collection<ClassPathElementWithVersion> getListOfClasspathElements() {
            return this.classPathEntries.values();
        }
    }

    private static class ClassPathElementWithVersion {
        private String fileName;
        private String resourceDir;
        private VersionComparator.Version version;

        ClassPathElementWithVersion(String resourceDir, String fileName) {
            this.fileName = fileName;
            this.resourceDir = resourceDir;
        }

        VersionComparator.Version getVersion() {
            if (this.version == null) {
                this.version = VersionComparator.getVersionFromFileName(this.fileName);
            }
            return this.version;
        }

        String getFileName() {
            return this.fileName;
        }

        URL getElementUrl() {
            File element = new File(this.resourceDir, this.fileName);
            if (element.exists()) {
                try {
                    return element.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            StringBuilder output = new StringBuilder();
            output.append("The following file does not exist : ").append(element.getAbsolutePath()).append("\n");
            output.append("Something went wrong with its version in the Bootstrap");
            LOG.severe(output.toString());
            return null;
        }
    }
}

