/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Function;
import org.lsst.ccs.subsystem.rafts.fpga.xml.FunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatFunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatSubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Subroutine;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Visitable;

@XmlType(propOrder={"repeat", "repeatFcnPtr", "repeatSubPtr", "calls"})
public class Call
implements Visitable,
Serializable {
    private static final long serialVersionUID = -8170623760515903084L;
    private Function fcn;
    private Subroutine sub;
    private String repeat = null;
    private List<Call> calls;
    private FunctionPointer fcnPtr;
    private SubroutinePointer subPtr;
    private RepeatFunctionPointer repeatFcnPtr;
    private RepeatSubroutinePointer repeatSubPtr;
    private boolean infinity;
    private int repeatValue;
    private String fcnName;
    private String subName;

    public Call() {
    }

    public Call(Function c) {
        this.setFunction(c);
    }

    public Call(Function c, String repeat) {
        this.setFunction(c);
        this.repeat = repeat;
    }

    public Call(Subroutine c) {
        this.setSubroutine(c);
    }

    public Call(Subroutine c, String repeat) {
        this.setSubroutine(c);
        this.repeat = repeat;
    }

    public Call(String repeat, List<Call> subroutine) {
        this.repeat = repeat;
        this.setCalls(subroutine);
    }

    private void checkConstraints() {
        int i = 0;
        StringBuilder b = new StringBuilder();
        if (this.fcn != null) {
            ++i;
            b.append("fcn ");
        }
        if (this.sub != null) {
            ++i;
            b.append("sub ");
        }
        if (this.fcnPtr != null) {
            ++i;
            b.append("fcnPtr ");
        }
        if (this.subPtr != null) {
            ++i;
            b.append("subPtr ");
        }
        if (this.calls != null) {
            ++i;
            b.append("calls ");
        }
        if (i > 1) {
            throw new RuntimeException("cannot specify simultaneously " + b.toString());
        }
        if (this.repeatFcnPtr != null && (this.sub != null || this.subPtr != null)) {
            throw new RuntimeException("cannot specify repeatfcnptr with sub/subptr");
        }
        if (this.repeatSubPtr != null && (this.fcn != null || this.fcnPtr != null)) {
            throw new RuntimeException("cannot specify repeatsubptr with fcn/fcnptr");
        }
        if (this.repeat != null && (this.repeatSubPtr != null || this.repeatFcnPtr != null)) {
            throw new RuntimeException("cannot specify repeat and a repeat pointer");
        }
        if (this.repeat != null && this.repeat.equals("infinity")) {
            if (this.sub != null || this.subPtr != null) {
                throw new RuntimeException("cannot specify infinity for a subroutine");
            }
            if (this.repeatSubPtr != null || this.repeatFcnPtr != null) {
                throw new RuntimeException("cannot specify infinity and a repeat attribute");
            }
        }
    }

    @XmlIDREF
    @XmlAttribute(name="fcn")
    public Function getFunction() {
        return this.fcn;
    }

    public void setFunction(Function fcn) {
        this.fcn = fcn;
        this.checkConstraints();
    }

    @XmlIDREF
    @XmlAttribute(name="sub")
    public Subroutine getSubroutine() {
        return this.sub;
    }

    public void setSubroutine(Subroutine sub) {
        this.sub = sub;
        this.checkConstraints();
    }

    @XmlIDREF
    @XmlAttribute(name="fcnptr")
    public FunctionPointer getFunctionPointer() {
        return this.fcnPtr;
    }

    public void setFunctionPointer(FunctionPointer fcnPtr) {
        this.fcnPtr = fcnPtr;
        this.checkConstraints();
    }

    @XmlIDREF
    @XmlAttribute(name="subptr")
    public SubroutinePointer getSubroutinePointer() {
        return this.subPtr;
    }

    public void setSubroutinePointer(SubroutinePointer subPtr) {
        this.subPtr = subPtr;
        this.checkConstraints();
    }

    @XmlIDREF
    @XmlElement(name="repeatfcnptr")
    public RepeatFunctionPointer getRepeatFcnPtr() {
        return this.repeatFcnPtr;
    }

    public void setRepeatFcnPtr(RepeatFunctionPointer repeatFcnPtr) {
        this.repeatFcnPtr = repeatFcnPtr;
        this.checkConstraints();
    }

    @XmlIDREF
    @XmlElement(name="repeatsubptr")
    public RepeatSubroutinePointer getRepeatSubPtr() {
        return this.repeatSubPtr;
    }

    public void setRepeatSubPtr(RepeatSubroutinePointer repeatSubPtr) {
        this.repeatSubPtr = repeatSubPtr;
        this.checkConstraints();
    }

    @XmlElement(name="repeat", required=false, defaultValue="1")
    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
        this.repeat = repeat != null && repeat.equals("1") ? null : repeat;
        this.checkConstraints();
    }

    @XmlElement(name="call")
    public List<Call> getCalls() {
        return this.calls;
    }

    public void setCalls(List<Call> calls) {
        this.calls = calls;
        this.checkConstraints();
    }

    @XmlTransient
    public boolean isInfinity() {
        return this.infinity;
    }

    public void setInfinity(boolean infinity) {
        this.infinity = infinity;
        this.checkConstraints();
    }

    @XmlTransient
    public int getRepeatValue() {
        return this.repeatValue;
    }

    public void setRepeatValue(int repeatValue) {
        this.repeatValue = repeatValue;
    }

    @XmlTransient
    public String getFcnName() {
        return this.fcnName;
    }

    public void setFcnName(String fcnName) {
        this.fcnName = fcnName;
    }

    @XmlTransient
    public String getSubName() {
        return this.subName;
    }

    public void setSubName(String subName) {
        this.subName = subName;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }
}

