/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.demo;

import com.l2fprod.common.model.DefaultBeanInfoResolver;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.UIManager;

public class BeanBinder {
    private final Object bean;
    private final PropertySheetPanel sheet;
    private final PropertyChangeListener listener;

    public BeanBinder(Object bean, PropertySheetPanel sheet) {
        this(bean, sheet, new DefaultBeanInfoResolver().getBeanInfo(bean));
    }

    public BeanBinder(Object bean, PropertySheetPanel sheet, BeanInfo beanInfo) {
        this.bean = bean;
        this.sheet = sheet;
        sheet.setProperties(beanInfo.getPropertyDescriptors());
        sheet.readFromObject(bean);
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                block2: {
                    Property prop = (Property)evt.getSource();
                    try {
                        prop.writeToObject(BeanBinder.this.bean);
                    }
                    catch (RuntimeException e) {
                        if (!(e.getCause() instanceof PropertyVetoException)) break block2;
                        UIManager.getLookAndFeel().provideErrorFeedback(BeanBinder.this.sheet);
                        prop.setValue(evt.getOldValue());
                    }
                }
            }
        };
        sheet.addPropertySheetChangeListener(this.listener);
    }

    public void unbind() {
        this.sheet.removePropertyChangeListener(this.listener);
        this.sheet.setProperties(new Property[0]);
    }
}

