/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Header;

public class FcHeader
extends Header {
    public static final byte REPLENISH = 1;
    public static final byte CREDIT_REQUEST = 2;
    byte type = 1;

    public FcHeader() {
    }

    public FcHeader(byte type) {
        this.type = type;
    }

    @Override
    public Supplier<? extends Header> create() {
        return FcHeader::new;
    }

    @Override
    public short getMagicId() {
        return 59;
    }

    @Override
    public int serializedSize() {
        return 1;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.type);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.type = in.readByte();
    }

    @Override
    public String toString() {
        switch (this.type) {
            case 1: {
                return "REPLENISH";
            }
            case 2: {
                return "CREDIT_REQUEST";
            }
        }
        return "<invalid type>";
    }
}

