/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jline.console.ConsoleReader;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.AgentLockServiceCommands;
import org.lsst.ccs.subsystem.shell.BusCommandSet;
import org.lsst.ccs.subsystems.console.jython.JythonConsoleSocketConnection;

public class ConsoleCommandShell
implements AgentCommandDictionaryService.AgentCommandDictionaryListener {
    private final AgentMessagingLayer messagingAccess;
    private final RouteSelectionCommandSet rsc;
    private final ConcurrentMessagingUtils sci;
    private final BusMasterCommands busMasterCommands = new BusMasterCommands();
    private final CompositeCommandSet builtInsCommandSet;
    private static final int timeoutMillis = 10000;
    private JythonConsoleSocketConnection jythonConsoleSocketConnection = null;
    private String showJythonOutput = "false";
    private final Agent agent;

    ConsoleCommandShell(Agent agent) {
        this.messagingAccess = agent.getMessagingAccess();
        this.sci = new ConcurrentMessagingUtils(this.messagingAccess, Duration.ofMillis(10000L));
        this.rsc = new RouteSelectionCommandSet();
        CommandSetBuilder builder = new CommandSetBuilder();
        this.builtInsCommandSet = new CompositeCommandSet();
        this.builtInsCommandSet.add(builder.buildCommandSet((Object)this.busMasterCommands));
        this.builtInsCommandSet.add(builder.buildCommandSet((Object)new AgentLockServiceCommands(agent.getAgentService(AgentLockService.class), agent.getAgentService(AgentLoginService.class), this.rsc)));
        this.rsc.add((CommandSet)this.builtInsCommandSet);
        this.rsc.getCommandDictionary().setLevelForTypes(-1, new Command.CommandType[0]);
        this.rsc.getCommandDictionary().setLevelForTypes(0, new Command.CommandType[]{Command.CommandType.QUERY});
        this.builtInsCommandSet.getCommandDictionary().setLevelForTypes(99999, new Command.CommandType[0]);
        this.agent = agent;
        agent.getAgentService(AgentCommandDictionaryService.class).addAgentCommandDictionaryListener(this);
    }

    public RouteSelectionCommandSet getConsoleCommandSet() {
        return this.rsc;
    }

    @Override
    public void commandDictionaryUpdate(AgentCommandDictionaryService.AgentCommandDictionaryEvent evt) {
        if (!evt.getAgentInfo().getType().equals((Object)AgentInfo.AgentType.LISTENER)) {
            String agentName = evt.getAgentInfo().getName();
            if (evt.getEventType().equals((Object)AgentCommandDictionaryService.AgentCommandDictionaryEvent.EventType.ADDED)) {
                if (!this.rsc.containsPath(agentName)) {
                    this.agent.getScheduler().execute(() -> {
                        for (String string : evt.getDictionary().keySet()) {
                            void var4_4;
                            Object route = string;
                            if (!((String)route).startsWith(agentName)) {
                                route = agentName + (((String)route).isEmpty() ? "" : "/") + (String)route;
                            }
                            if (!string.startsWith(agentName)) {
                                String string2 = agentName + (string.isEmpty() ? "" : "/") + string;
                            }
                            this.rsc.addRoutingCommandSet((String)route, (String)var4_4, (CommandSet)new BusCommandSet(this.sci, (String)var4_4, evt.getDictionary().get(var4_4)));
                        }
                    });
                }
            } else if (evt.getEventType().equals((Object)AgentCommandDictionaryService.AgentCommandDictionaryEvent.EventType.REMOVED)) {
                this.rsc.removeRoute(agentName);
            }
        }
    }

    BusMasterCommands getBusMasterCommands() {
        return this.busMasterCommands;
    }

    public static JLineShell createJLineShell(Agent agent, ConsoleReader reader) throws IOException {
        ConsoleCommandShell comShell = new ConsoleCommandShell(agent);
        return new JLineShell((CommandSet)comShell.getConsoleCommandSet(), reader, "${target} ccs>");
    }

    public static ConsoleCommandShell createConsoleCommandShell(Agent agent) {
        ConsoleCommandShell comShell = new ConsoleCommandShell(agent);
        return comShell;
    }

    public static void main(String[] argv) throws Exception {
        Subsystem busMaster = new Subsystem("ccs-shell", AgentInfo.AgentType.CONSOLE);
        busMaster.startAgent();
        ConsoleCommandShell comShell = new ConsoleCommandShell(busMaster);
        JLineShell shell = new JLineShell((CommandSet)comShell.getConsoleCommandSet(), "${target} ccs>");
        shell.run();
        System.exit(0);
    }

    public class BusMasterCommands {
        public List<String> listSubsystems() {
            return this.listSubsystems(new Options(), "Worker", true);
        }

        @Option(name="host", description="Show the host information")
        @Command(name="listSubsystems", description="List the subsystems on the CCS buses for a given Agent type", alias="ls", type=Command.CommandType.QUERY)
        public List<String> listSubsystems(Options options, @Argument(name="Agent type", defaultValue="Worker") String agentType, @Argument(defaultValue="true") boolean allTypesAbove) {
            AgentInfo.AgentType referenceType = AgentInfo.AgentType.valueOf((String)agentType.toUpperCase());
            ArrayList<String> result = new ArrayList<String>();
            for (AgentInfo agent : ConsoleCommandShell.this.messagingAccess.getAgentPresenceManager().listConnectedAgents()) {
                if ((!allTypesAbove || agent.getType().ordinal() < referenceType.ordinal()) && agent.getType().ordinal() != referenceType.ordinal()) continue;
                result.add(this.getAgentInformation(agent, options));
            }
            Collections.sort(result);
            return result;
        }

        private String getAgentInformation(AgentInfo agentInfo, Options options) {
            StringBuilder sb = new StringBuilder();
            sb.append(agentInfo.getName());
            if (options.hasOption("host")) {
                sb.append("[");
                String host = agentInfo.getAgentProperty("org.lsst.ccs.agent.hostname");
                if (host != null && !host.isEmpty()) {
                    sb.append("host=").append(host);
                    String jmxport = agentInfo.getAgentProperty("org.lsst.ccs.agent.jmxport");
                    if (jmxport != null && !jmxport.isEmpty()) {
                        sb.append(":").append(jmxport);
                    }
                }
                sb.append("]");
            }
            return sb.toString();
        }

        @Command(description="Set Console parameters", type=Command.CommandType.QUERY)
        public void set(@Argument(name="item") ConsoleParameters what, @Argument(name="value") String value) {
            if (what == ConsoleParameters.TIMEOUT) {
                ConsoleCommandShell.this.sci.setDefaultTimeout(Duration.ofMillis(Long.valueOf(value)));
            } else if (what == ConsoleParameters.SHOW_JYTHON_OUTPUT) {
                if (ConsoleCommandShell.this.jythonConsoleSocketConnection != null) {
                    ConsoleCommandShell.this.jythonConsoleSocketConnection.setPrintStream(value.equals("true") ? System.out : null);
                }
                ConsoleCommandShell.this.showJythonOutput = value;
            }
        }

        @Command(description="Set Dictionary Category Visibility", type=Command.CommandType.QUERY)
        public void set(@Argument(name="item") Visibility what, @Argument(name="category") Command.CommandCategory category, boolean visibility) {
            if (what == Visibility.VISIBILITY) {
                ConsoleCommandShell.this.rsc.getCommandDictionary().setCategoryVisible(category, visibility);
            }
        }

        @Command(description="Get Dictionary Category Visibility", type=Command.CommandType.QUERY)
        public boolean get(@Argument(name="item") Visibility what, @Argument(name="category") Command.CommandCategory category) {
            if (what == Visibility.VISIBILITY) {
                return ConsoleCommandShell.this.rsc.getCommandDictionary().isCategoryVisible(category);
            }
            throw new UnsupportedOperationException("Unknown item " + what);
        }

        @Command(description="Get a Console parameter", type=Command.CommandType.QUERY)
        public String get(@Argument(name="item") ConsoleParameters what) {
            if (what == ConsoleParameters.TIMEOUT) {
                return String.valueOf(ConsoleCommandShell.this.sci.getDefaultTimeout().toMillis());
            }
            if (what == ConsoleParameters.SHOW_JYTHON_OUTPUT) {
                return ConsoleCommandShell.this.showJythonOutput;
            }
            return null;
        }

        @Command(description="Execute a Jython script", type=Command.CommandType.QUERY)
        public void executeScript(@Argument(name="scriptPath") String scriptPath, String ... args) throws IOException {
            JythonScriptExecutorUtils.executeScript(scriptPath, args);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter", type=Command.CommandType.QUERY)
        public void connectToJythonConsole(@Argument(name="host", defaultValue="localhost") String host, @Argument(name="port", defaultValue="4444") int port) throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection != null) {
                throw new RuntimeException("There is already a connection established. There can be only one! Please \"closeConnectionWithJythonConsole\" before opening a new one.");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection = new JythonConsoleSocketConnection("CommandShellConnection_" + System.currentTimeMillis(), port, host);
            ConsoleCommandShell.this.jythonConsoleSocketConnection.setPrintStream(ConsoleCommandShell.this.showJythonOutput.equals("true") ? System.out : null);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter", type=Command.CommandType.QUERY)
        public void submitScript(@Argument(name="scriptPath") String scriptPath, String ... args) throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection == null) {
                throw new RuntimeException("No connection was established with a JythonConsole. Please invoke \"connectToJythonConsole\" first");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection.asynchFileExecution(scriptPath, args);
        }

        @Command(description="Submit a Jython script to a Jython Interpreter", type=Command.CommandType.QUERY)
        public void closeConnectionWithJythonConsole() throws IOException {
            if (ConsoleCommandShell.this.jythonConsoleSocketConnection == null) {
                throw new RuntimeException("There is open connection to a JythonConsole.");
            }
            ConsoleCommandShell.this.jythonConsoleSocketConnection.close();
            ConsoleCommandShell.this.jythonConsoleSocketConnection = null;
        }

        @Command(type=Command.CommandType.QUERY, description="Provide a list of normal mode commands")
        public String listNormalModeCommands() {
            StringBuilder sb = new StringBuilder();
            AgentCommandDictionaryService dictService = ConsoleCommandShell.this.agent.getAgentService(AgentCommandDictionaryService.class);
            sb.append("NORMAL mode commands in common with all agents").append("\n");
            ArrayList<DictionaryCommand> commonCommands = new ArrayList<DictionaryCommand>();
            HashMap<String, Dictionary> thisDict = dictService.getAgentCommandDictionary();
            for (Map.Entry e : thisDict.entrySet()) {
                Dictionary d = (Dictionary)e.getValue();
                for (DictionaryCommand dc : d) {
                    if (dc.getType() == Command.CommandType.QUERY || dc.getLevel() != 0) continue;
                    sb.append(" ").append(dc.getCommandName()).append(" ").append(dc.getDescription()).append(" (type=").append(dc.getType()).append(")").append("\n");
                    commonCommands.add(dc);
                }
            }
            boolean hasProcessedWorkerOrService = false;
            boolean hasProcessedImageHanlder = false;
            DictionaryListener listener = new DictionaryListener();
            dictService.addAgentCommandDictionaryListener(listener);
            Map<AgentInfo, Map<String, Dictionary>> dictionaries = listener.getDictionaries();
            for (Map.Entry<AgentInfo, Map<String, Dictionary>> e : dictionaries.entrySet()) {
                String target;
                AgentInfo ai = e.getKey();
                boolean extractCommonCommands = false;
                if (ai.isAgentWorkerOrService() && !hasProcessedWorkerOrService) {
                    hasProcessedWorkerOrService = true;
                    extractCommonCommands = true;
                }
                Map<String, Dictionary> dicts = e.getValue();
                HashMap<String, List> levelZeroCommands = new HashMap<String, List>();
                for (Map.Entry<String, Dictionary> entry : dicts.entrySet()) {
                    target = entry.getKey();
                    Dictionary d = entry.getValue();
                    for (DictionaryCommand dc : d) {
                        if (dc.getType() == Command.CommandType.QUERY || dc.getLevel() != 0) continue;
                        if (extractCommonCommands) {
                            switch (dc.getCommandName()) {
                                case "switchToEngineeringMode": 
                                case "switchToNormalMode": {
                                    if (!dc.getType().equals((Object)Command.CommandType.ACTION)) break;
                                    sb.append(" ").append(dc.getCommandName()).append(" ").append(dc.getDescription()).append(" (type=").append(dc.getType()).append(")").append("\n");
                                    commonCommands.add(dc);
                                    break;
                                }
                                case "abort": 
                                case "stop": {
                                    if (!dc.getType().equals((Object)Command.CommandType.SIGNAL)) break;
                                    sb.append(" ").append(dc.getCommandName()).append(" ").append(dc.getDescription()).append(" (type=").append(dc.getType()).append(")").append("\n");
                                    commonCommands.add(dc);
                                }
                            }
                        }
                        boolean isCommon = false;
                        for (DictionaryCommand common : commonCommands) {
                            if (!DictionaryUtils.areDictionaryCommandsEqual((DictionaryCommand)common, (DictionaryCommand)dc)) continue;
                            isCommon = true;
                            break;
                        }
                        if (isCommon) continue;
                        levelZeroCommands.computeIfAbsent(target, t -> new ArrayList()).add(dc);
                    }
                }
                if (!levelZeroCommands.isEmpty()) {
                    if (ai.getAgentProperty("agentCategory", "").equalsIgnoreCase(AgentCategory.IMAGE_HANDLER.name())) {
                        if (!hasProcessedImageHanlder) {
                            hasProcessedImageHanlder = true;
                            sb.append("Agent: ").append(AgentCategory.IMAGE_HANDLER.name()).append("\n");
                        }
                    } else {
                        sb.append("Agent: ").append(ai.getName()).append("\n");
                    }
                    for (Map.Entry<String, Object> entry : levelZeroCommands.entrySet()) {
                        target = entry.getKey();
                        if (!target.isEmpty() && !target.equals(ai.getName())) {
                            sb.append(" Target: ").append(target).append("\n");
                        }
                        List cmds = (List)entry.getValue();
                        for (DictionaryCommand dc : cmds) {
                            sb.append("  ").append(dc.getCommandName()).append(" ").append(dc.getDescription());
                            if (dc.getType() != Command.CommandType.ACTION) {
                                sb.append(" (type=").append(dc.getType()).append(")");
                            }
                            sb.append("\n");
                        }
                    }
                    continue;
                }
                if (ai.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) < 0) continue;
                sb.append("Agent: ").append(ai.getName()).append(" has no additional NORMAL mode commands\n");
            }
            return sb.toString();
        }

        @Command(description="Print dictionary commands and levels for an agent", type=Command.CommandType.QUERY, category=Command.CommandCategory.USER)
        public String printDictionaryCommandLevels(@Argument(allowedValueProvider="listSubsystems", defaultValue="CurrentTarget") String agentName, @Argument(defaultValue="caqs") String typesToDisplay, @Argument(defaultValue="csu") String categoryToDisplay) {
            if ("CurrentTarget".equals(agentName) && (agentName = ConsoleCommandShell.this.rsc.getActiveRoute()).contains("/")) {
                agentName = agentName.substring(0, agentName.indexOf("/"));
            }
            typesToDisplay = typesToDisplay.toUpperCase();
            categoryToDisplay = categoryToDisplay.toUpperCase();
            AgentCommandDictionaryService dictService = ConsoleCommandShell.this.agent.getAgentService(AgentCommandDictionaryService.class);
            DictionaryListener listener = new DictionaryListener();
            dictService.addAgentCommandDictionaryListener(listener);
            Map<AgentInfo, Map<String, Dictionary>> dictionaries = listener.getDictionaries();
            Map dicts = null;
            for (Map.Entry<AgentInfo, Map<String, Dictionary>> e : dictionaries.entrySet()) {
                AgentInfo agentInfo = e.getKey();
                if (!agentInfo.getName().equals(agentName)) continue;
                dicts = (Map)e.getValue();
                break;
            }
            if (dicts == null) {
                return "No dictionary found for agent name " + agentName;
            }
            TreeMap<Integer, List> commandsSortedByLevel = new TreeMap<Integer, List>();
            for (Map.Entry entry : dicts.entrySet()) {
                String target = (String)entry.getKey();
                for (Object cmd : (Dictionary)entry.getValue()) {
                    String cat = cmd.getCategory().name().substring(0, 1);
                    String type = cmd.getType().name().substring(0, 1);
                    if (!categoryToDisplay.contains(cat) || !typesToDisplay.contains(type)) continue;
                    int level = cmd.getLevel();
                    Object fullTarget = cmd.getCommandName();
                    if (target != null && !target.isEmpty()) {
                        fullTarget = target + "/" + (String)fullTarget;
                    }
                    fullTarget = ((String)fullTarget).replace(agentName + "/", "");
                    fullTarget = "(" + type + "," + cat + ") " + (String)fullTarget;
                    commandsSortedByLevel.computeIfAbsent(level, l -> new ArrayList()).add(fullTarget);
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Commands for subsystem ").append(agentName).append(" sorted by level and preceded by (type,category).\n").append("\n");
            for (Map.Entry e : commandsSortedByLevel.entrySet()) {
                sb.append("Commands at level ").append(e.getKey()).append("\n");
                for (Object cmd : (List)e.getValue()) {
                    sb.append("     ").append((String)cmd).append("\n");
                }
            }
            return sb.toString();
        }

        private class DictionaryListener
        implements AgentCommandDictionaryService.AgentCommandDictionaryListener {
            private Map<AgentInfo, Map<String, Dictionary>> dictionaries = new HashMap<AgentInfo, Map<String, Dictionary>>();

            private DictionaryListener() {
            }

            @Override
            public void commandDictionaryUpdate(AgentCommandDictionaryService.AgentCommandDictionaryEvent evt) {
                if (evt.getEventType() == AgentCommandDictionaryService.AgentCommandDictionaryEvent.EventType.ADDED) {
                    this.dictionaries.put(evt.getAgentInfo(), evt.getDictionary());
                }
            }

            Map<AgentInfo, Map<String, Dictionary>> getDictionaries() {
                return this.dictionaries;
            }
        }
    }

    public static enum Visibility {
        VISIBILITY;

    }

    public static enum ConsoleParameters {
        TIMEOUT,
        SHOW_JYTHON_OUTPUT;

    }
}

