/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.gconsole.services.persist.Savable;

public class OutputPane
extends JScrollPane
implements Savable {
    private final TextPane textPane;
    private final StyledDocument document;
    private final LinkedList<Position> records = new LinkedList();
    private final Style attBase;
    private final Style attPlane;
    private final HashMap<Color, Style> color2style = new HashMap(4);
    private String recordTerminator = "\n";
    private int lineLength;
    private Descriptor descriptor;

    public OutputPane() {
        this((Descriptor)null);
    }

    public OutputPane(Descriptor desc) {
        this.descriptor = desc == null ? new Descriptor() : desc.clone();
        this.textPane = new TextPane();
        this.setViewportView(this.textPane);
        this.document = this.textPane.getStyledDocument();
        this.recordTerminator = this.descriptor.isSkipLine() ? "\n\n" : "\n";
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        this.attBase = this.document.addStyle("attBase", def);
        StyleConstants.setFontSize(this.attBase, this.descriptor.getFontSize());
        this.attPlane = this.document.addStyle("attPlane", this.attBase);
        this.lineLength = this.descriptor.getMaxLineLength();
    }

    private void setFontSize(int size) {
        this.setButtonSize(this, size);
        StyleConstants.setFontSize(this.attBase, size);
        this.descriptor.setFontSize(size);
    }

    public void setSkipLine(boolean skipLine) {
        this.recordTerminator = skipLine ? "\n\n" : "\n";
        this.descriptor.setSkipLine(skipLine);
        this.textPane.actSkipLine.putValue("SwingSelectedKey", skipLine);
    }

    public void setLineLength(int maxLength) {
        this.lineLength = maxLength;
        this.descriptor.setMaxLineLength(this.lineLength);
    }

    public void println(Object record, Color color) {
        JScrollBar bar = this.getVerticalScrollBar();
        boolean adjusting = bar.getValueIsAdjusting();
        boolean bottom = bar.getValue() + bar.getVisibleAmount() >= bar.getMaximum();
        try {
            int start = this.document.getEndPosition().getOffset() - 1;
            String s = record.toString().replaceFirst("\\s++$", "");
            if (this.lineLength > 0) {
                Position beforeRecord;
                String[] ss = this.split(s);
                SimpleAttributeSet attButton = new SimpleAttributeSet(this.attBase);
                StyleConstants.setAlignment(attButton, 1);
                Button button = new Button(ss);
                StyleConstants.setComponent(attButton, button);
                this.document.insertString(start, " ", attButton);
                this.document.insertString(start + 1, ss[0] + this.recordTerminator, this.getStyle(color));
                button.before = beforeRecord = this.document.createPosition(start);
                button.addActionListener(e -> button.act());
                this.records.add(beforeRecord);
            } else {
                this.document.insertString(start, s + this.recordTerminator, this.getStyle(color));
                this.records.add(this.document.createPosition(start));
            }
            if (!adjusting) {
                if (bottom) {
                    while (this.records.size() > this.descriptor.maxRecords) {
                        this.records.removeFirst();
                        this.document.remove(0, this.records.getFirst().getOffset());
                    }
                    this.scrollToBottom();
                } else {
                    Position top = null;
                    while (this.records.size() > this.descriptor.maxRecords) {
                        int topOffset;
                        if (top == null) {
                            topOffset = this.textPane.viewToModel(this.getViewport().getViewPosition());
                            top = this.document.createPosition(topOffset);
                        } else {
                            topOffset = top.getOffset();
                        }
                        int firstOffset = this.records.getFirst().getOffset();
                        if (firstOffset < topOffset) {
                            this.records.removeFirst();
                            this.document.remove(0, this.records.getFirst().getOffset());
                            continue;
                        }
                        int max = this.descriptor.getMaxRecordsOverflow();
                        if (max == 0) {
                            max = this.descriptor.getMaxRecords() * 10;
                        }
                        if (this.records.size() <= max) break;
                        while (this.records.size() > this.descriptor.maxRecords) {
                            this.records.removeFirst();
                            this.document.remove(0, this.records.getFirst().getOffset());
                        }
                        top = null;
                        this.scrollToBottom();
                    }
                    if (top != null) {
                        this.scrollToPosition(top);
                    }
                }
            }
        }
        catch (BadLocationException x) {
            throw new RuntimeException(x);
        }
    }

    public void println(Object record) {
        this.println(record, null);
    }

    private void setButtonSize(Component comp, int size) {
        if (comp instanceof JButton) {
            comp.setPreferredSize(new Dimension(size, size));
        } else if (comp instanceof Container) {
            Component[] cc;
            for (Component c : cc = ((Container)comp).getComponents()) {
                this.setButtonSize(c, size);
            }
        }
    }

    private void scrollToBottom() {
        SwingUtilities.invokeLater(() -> {
            JScrollBar bar = this.getVerticalScrollBar();
            bar.setValue(bar.getMaximum());
        });
    }

    private void scrollToPosition(Position p) {
        try {
            Rectangle r = this.textPane.modelToView(p.getOffset());
            this.textPane.scrollRectToVisible(r);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private Style getStyle(Color color) {
        if (color == null) {
            return this.attPlane;
        }
        Style style = this.color2style.get(color);
        if (style == null) {
            style = this.document.addStyle(Integer.toHexString(color.getRGB()), this.attBase);
            StyleConstants.setForeground(style, color);
            this.color2style.put(color, style);
        }
        return style;
    }

    private String[] split(String s) {
        int i = s.indexOf("\n");
        if (i == -1) {
            if (s.length() > this.lineLength) {
                return new String[]{s.substring(0, this.lineLength), s.substring(this.lineLength)};
            }
            return new String[]{s, null};
        }
        if (i > this.lineLength) {
            return new String[]{s.substring(0, this.lineLength), s.substring(this.lineLength)};
        }
        return new String[]{s.substring(0, i), s.substring(i + 1)};
    }

    @Override
    public void restore(Serializable descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
        } else if (descriptor == null) {
            this.descriptor = new Descriptor();
        }
        this.setFontSize(this.descriptor.getFontSize());
        this.setSkipLine(this.descriptor.isSkipLine());
    }

    @Override
    public Descriptor save() {
        return this.descriptor.clone();
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("OutputPane test");
            frame.setDefaultCloseOperation(3);
            final OutputPane pane = new OutputPane();
            frame.add((Component)pane, "Center");
            Box buttonBox = Box.createHorizontalBox();
            frame.add((Component)buttonBox, "South");
            buttonBox.add(new JButton(new AbstractAction("Add one record"){
                private int line;
                {
                    super(name);
                    this.line = 0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    pane.println("-" + this.line++ + "-- Line rtgertgretghrtehrth tryhtyhtyh tyjtyjyu \njuyjyu \niunfbweprfui \niofjeo");
                }
            }));
            buttonBox.add(new JButton(new AbstractAction("Add red record"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    pane.println("--- Line rtgertgretghrtehrth", Color.RED);
                }
            }));
            buttonBox.add(Box.createHorizontalGlue());
            frame.pack();
            frame.setVisible(true);
        });
    }

    public static class Descriptor
    implements Serializable,
    Cloneable {
        private boolean nowrap;
        private boolean skipLine;
        private int maxLineLength;
        private int maxRecords = 300;
        private int maxRecordsOverflow = 3000;
        private int fontSize = 15;

        public int getMaxLineLength() {
            return this.maxLineLength;
        }

        public void setMaxLineLength(int maxLineLength) {
            this.maxLineLength = maxLineLength;
        }

        public boolean isSkipLine() {
            return this.skipLine;
        }

        public void setSkipLine(boolean skipLine) {
            this.skipLine = skipLine;
        }

        public int getMaxRecordsOverflow() {
            return this.maxRecordsOverflow;
        }

        public void setMaxRecordsOverflow(int maxRecordsOverflow) {
            this.maxRecordsOverflow = maxRecordsOverflow;
        }

        public boolean isNowrap() {
            return this.nowrap;
        }

        public void setNowrap(boolean nowrap) {
            this.nowrap = nowrap;
        }

        public int getMaxRecords() {
            return this.maxRecords;
        }

        public void setMaxRecords(int maxRecords) {
            this.maxRecords = maxRecords;
        }

        public int getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(int fontSize) {
            this.fontSize = fontSize;
        }

        public Descriptor clone() {
            try {
                return (Descriptor)super.clone();
            }
            catch (CloneNotSupportedException x) {
                throw new RuntimeException();
            }
        }
    }

    final class TextPane
    extends JTextPane
    implements HasPopupItems {
        private final Action actClear;
        private final Action actFontLarger;
        private final Action actFontSmaller;
        private final Action actSkipLine;
        private final Action actWrap;
        private final Action actCollapse;

        TextPane() {
            this.setEditable(false);
            try {
                ((DefaultCaret)this.getCaret()).setUpdatePolicy(1);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            String name = "Clear";
            KeyStroke ks = KeyStroke.getKeyStroke(67, 512);
            this.actClear = new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        OutputPane.this.document.remove(0, OutputPane.this.document.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    OutputPane.this.records.clear();
                }
            };
            this.actClear.putValue("AcceleratorKey", ks);
            this.getInputMap(1).put(ks, name);
            this.getActionMap().put(name, this.actClear);
            name = "Larger";
            ks = KeyStroke.getKeyStroke(61, 512);
            this.actFontLarger = new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int fs = StyleConstants.getFontSize(OutputPane.this.attBase);
                    OutputPane.this.setFontSize(fs + 1);
                }
            };
            this.actFontLarger.putValue("AcceleratorKey", ks);
            this.getInputMap(1).put(ks, name);
            this.getActionMap().put(name, this.actFontLarger);
            name = "Smaller";
            ks = KeyStroke.getKeyStroke(45, 512);
            this.actFontSmaller = new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int fs = StyleConstants.getFontSize(OutputPane.this.attBase);
                    if (fs > 6) {
                        OutputPane.this.setFontSize(fs - 1);
                    }
                }
            };
            this.actFontSmaller.putValue("AcceleratorKey", ks);
            this.getInputMap(1).put(ks, name);
            this.getActionMap().put(name, this.actFontSmaller);
            name = "Extra line";
            this.actSkipLine = new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OutputPane.this.setSkipLine((Boolean)TextPane.this.actSkipLine.getValue("SwingSelectedKey"));
                }
            };
            this.actSkipLine.putValue("SwingSelectedKey", OutputPane.this.descriptor.isSkipLine());
            this.getActionMap().put(name, this.actSkipLine);
            name = "Wrap";
            this.actWrap = new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OutputPane.this.descriptor.setNowrap((Boolean)TextPane.this.actWrap.getValue("SwingSelectedKey") == false);
                }
            };
            this.actWrap.putValue("SwingSelectedKey", !OutputPane.this.descriptor.isNowrap());
            this.getActionMap().put(name, this.actWrap);
            name = "Collapse";
            this.actCollapse = new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OutputPane.this.setLineLength((Boolean)TextPane.this.actCollapse.getValue("SwingSelectedKey") != false ? 100 : 0);
                }
            };
            this.actCollapse.putValue("SwingSelectedKey", OutputPane.this.lineLength > 0);
            this.getActionMap().put(name, this.actCollapse);
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component cmpnt, Point point) {
            menu.add(new JMenuItem(this.actClear));
            JMenu fontMenu = new JMenu("Font size");
            menu.add(fontMenu);
            fontMenu.add(new JMenuItem(this.actFontLarger));
            fontMenu.add(new JMenuItem(this.actFontSmaller));
            menu.add(new JCheckBoxMenuItem(this.actSkipLine));
            menu.add(new JCheckBoxMenuItem(this.actWrap));
            menu.add(new JCheckBoxMenuItem(this.actCollapse));
            return menu;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            if (OutputPane.this.descriptor.isNowrap()) {
                return this.getUI().getPreferredSize((JComponent)this).width <= this.getParent().getSize().width;
            }
            return super.getScrollableTracksViewportWidth();
        }
    }

    private final class Button
    extends JButton {
        Position before;
        int length;
        String hidden;

        Button(String[] ss) {
            super(ss[1] == null ? "-" : "+");
            this.hidden = ss[1];
            this.length = ss[0].length();
            int fs = StyleConstants.getFontSize(OutputPane.this.attBase);
            this.setPreferredSize(new Dimension(fs, fs));
            this.setAlignmentY(0.8f);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setFocusPainted(false);
        }

        void act() {
            try {
                int offset = this.before.getOffset() + 1;
                if (this.hidden == null) {
                    String s = OutputPane.this.document.getText(offset, this.length);
                    String[] ss = OutputPane.this.split(s);
                    if (ss[1] != null) {
                        this.setText("+");
                        this.hidden = ss[1];
                        int newLength = ss[0].length();
                        OutputPane.this.document.remove(offset + newLength, this.length - newLength);
                        this.length = newLength;
                    }
                } else {
                    OutputPane.this.document.insertString(offset + this.length, this.hidden, OutputPane.this.document.getCharacterElement(offset + 2).getAttributes());
                    this.length += this.hidden.length();
                    this.hidden = null;
                    this.setText("-");
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

