/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.EnumMap;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.messaging.TransportStateException;
import org.lsst.ccs.messaging.util.AbstractDispatcher;
import org.lsst.ccs.messaging.util.Dispatcher;

public class LegacyDispatcher
extends AbstractDispatcher {
    private final EnumMap<Bus, Object> busLocks = new EnumMap(Bus.class);
    private volatile boolean off = true;

    public LegacyDispatcher(String args) {
        super(args);
        for (Bus bus : Bus.values()) {
            this.busLocks.put(bus, new Object());
        }
        this.config = null;
    }

    @Override
    public void initialize() {
        this.off = false;
    }

    @Override
    public void shutdown() {
        this.off = true;
        super.shutdown();
    }

    @Override
    protected void in(AbstractDispatcher.DTask task, Bus bus, String ... agents) {
        if (this.off) {
            return;
        }
        this.notifyTaskListeners(task, Dispatcher.Stage.START);
        this.notifyTaskListeners(task, Dispatcher.Stage.WAIT);
        task.run();
        this.notifyTaskListeners(task, Dispatcher.Stage.RUN);
        this.notifyTaskListeners(task, Dispatcher.Stage.SUBMIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void out(AbstractDispatcher.DTask task, Bus bus, Dispatcher.Order order) {
        if (this.off) {
            throw new TransportStateException();
        }
        this.notifyTaskListeners(task, Dispatcher.Stage.START);
        this.notifyTaskListeners(task, Dispatcher.Stage.WAIT);
        Object object = this.busLocks.get((Object)bus);
        synchronized (object) {
            task.run();
        }
        this.notifyTaskListeners(task, Dispatcher.Stage.RUN);
        this.notifyTaskListeners(task, Dispatcher.Stage.SUBMIT);
    }
}

