/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.base.Const;

public final class SearchDialog
extends JDialog {
    private static String SD_KEY = "_sdkey_";
    private final ArrayList<String> all;
    private int maxResults = 30;
    private String description;
    private ArrayList<Button> actions;
    private String prevText = "";
    private ArrayList<String> results;
    private List<String> selected;
    private JTextField field;
    private JList resultsList;
    private JButton cancelButton;

    public SearchDialog(List<String> items, String title, Component parent) {
        super(parent == null ? null : SwingUtilities.getWindowAncestor(parent), title, Dialog.ModalityType.MODELESS);
        this.all = new ArrayList<String>(items);
    }

    private void init() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                SearchDialog.this.results = null;
                SearchDialog.this.selected = null;
                SearchDialog.this.dispose();
            }
        });
        JPanel root = new JPanel(new BorderLayout());
        this.add(root);
        root.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        if (this.actions != null) {
            this.actions.trimToSize();
        }
        this.field = new JTextField();
        this.field.addCaretListener(e -> this.updateResults());
        if (this.description == null) {
            root.add((Component)this.field, "North");
        } else {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            JTextArea descrArea = new JTextArea(this.description);
            descrArea.setOpaque(false);
            descrArea.setEditable(false);
            panel.add((Component)descrArea, "North");
            panel.add(Box.createRigidArea(Const.VDIM), "Center");
            panel.add((Component)this.field, "South");
            panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            root.add((Component)panel, "North");
        }
        this.resultsList = new JList();
        root.add((Component)new JScrollPane(this.resultsList), "Center");
        this.resultsList.setSelectionMode(2);
        this.resultsList.setPrototypeCellValue("D1234567890123456789012345678901234567890");
        this.resultsList.setVisibleRowCount(Math.min(this.maxResults, 20));
        this.resultsList.addListSelectionListener(e -> this.updateSelection());
        Box box = Box.createHorizontalBox();
        root.add((Component)box, "South");
        box.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        if (this.actions != null) {
            for (Action action : this.actions) {
                box.add(new JButton(action));
                box.add(Box.createRigidArea(Const.HDIM));
            }
        }
        box.add(Box.createHorizontalGlue());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(e -> this.cancel());
        box.add(this.cancelButton);
        this.setSize(this.getPreferredSize());
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.field.requestFocusInWindow();
        this.updateResults();
        this.setVisible(true);
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addAction(Button action) {
        if (this.actions == null) {
            this.actions = new ArrayList(1);
        }
        action.putValue(SD_KEY, this);
        this.actions.add(action);
    }

    public List<String> getMatches() {
        return this.results == null ? null : Collections.unmodifiableList(this.results);
    }

    public List<String> getSelected() {
        return this.selected == null ? null : Collections.unmodifiableList(this.selected);
    }

    public List<String> search() {
        this.init();
        return this.getSelected();
    }

    public void cancel() {
        this.results = null;
        this.selected = null;
        this.dispose();
    }

    private void updateResults() {
        String text = this.field.getText();
        if (text.equals(this.prevText)) {
            return;
        }
        this.selected = null;
        if (text.isEmpty()) {
            this.results = null;
        } else {
            ArrayList<String> items = new ArrayList<String>(this.maxResults);
            int n = 0;
            try {
                Pattern p = Pattern.compile(text.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*").replaceAll("\\?", "."));
                for (String candidate : this.all) {
                    if (!p.matcher(candidate).matches()) continue;
                    if (++n > this.maxResults) {
                        this.setForeground(Color.BLACK);
                        items = null;
                        break;
                    }
                    items.add(candidate);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
            this.results = items;
            if (this.results == null) {
                this.field.setForeground(Color.BLACK);
            } else {
                this.field.setForeground(this.results.isEmpty() ? Color.RED : Color.BLACK);
                this.selected = Collections.emptyList();
            }
        }
        this.prevText = text;
        this.resultsList.setModel(new Model());
        this.field.requestFocusInWindow();
        this.actions.forEach(action -> action.setEnabled(this));
    }

    private void updateSelection() {
        this.selected = this.resultsList == null ? null : this.resultsList.getSelectedValuesList();
        this.actions.forEach(action -> action.setEnabled(this));
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            List<String> items = Arrays.asList("uno", "dos", "tres", "trei.nta", "sorok/chetyre/s/polovinoy");
            SearchDialog d = new SearchDialog(items, "Title", null);
            d.setDescription("Enter search string");
            Button b = new Button("Print"){

                @Override
                public void setEnabled(SearchDialog dialog) {
                    List<String> ss = dialog.getSelected();
                    this.setEnabled(ss != null);
                }

                @Override
                public void actionPerformed(SearchDialog dialog) {
                    List<String> ss = dialog.getSelected();
                    System.out.println(ss);
                }
            };
            d.addAction(b);
            List<String> selected = d.search();
            System.out.println(selected);
        });
    }

    public static abstract class Button
    extends AbstractAction {
        public Button(String name) {
            super(name);
        }

        public Button(String name, Icon icon) {
            super(name, icon);
        }

        public void setEnabled(SearchDialog dialog) {
            List<String> matches = dialog.getMatches();
            this.setEnabled(matches != null && !matches.isEmpty());
        }

        public abstract void actionPerformed(SearchDialog var1);

        @Override
        public final void actionPerformed(ActionEvent event) {
            this.actionPerformed((SearchDialog)this.getValue(SD_KEY));
        }
    }

    private class Model
    extends AbstractListModel<String> {
        private Model() {
        }

        @Override
        public int getSize() {
            if (SearchDialog.this.results == null) {
                return SearchDialog.this.prevText.isEmpty() ? 0 : 1;
            }
            return SearchDialog.this.results.size();
        }

        @Override
        public String getElementAt(int index) {
            return SearchDialog.this.results == null ? "More than " + SearchDialog.this.maxResults + " matches" : (String)SearchDialog.this.results.get(index);
        }
    }
}

