/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertInstance;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.plugins.alert.LsstAlertPlugin;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.util.tree.TreeUtil;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;

public class AlertViewer
implements AlertListener {
    private final LsstAlertPlugin plugin;
    private Descriptor config;
    private AlertTree tree;
    private JTextPane infoPanel;
    private JPanel rightPanel;
    private JScrollPane leftPanel;
    private JSplitPane rootPanel;
    private Action clearAction;
    private JCheckBox freezeBox;
    private JCheckBox historyBox;
    private JCheckBox muteBox;
    private JCheckBox toFrontBox;
    private JCheckBox selectNewBox;
    private StyledDocument document;
    private Style attBase;
    private Style attBlack;
    private Style attBlackBold;
    private final EnumMap<AlertState, Style> attPlane = new EnumMap(AlertState.class);
    private final EnumMap<AlertState, Style> attBold = new EnumMap(AlertState.class);
    private static final EnumMap<AlertState, Color> COLOR = new EnumMap(AlertState.class);

    public AlertViewer(LsstAlertPlugin plugin, Descriptor configuration) {
        this.plugin = plugin;
        this.config = configuration == null ? new Descriptor() : configuration;
    }

    private void start() {
        HashMap<String, Serializable> data;
        this.clearAction = new AbstractAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertNode node = AlertViewer.this.tree.getSelectedNode();
                if (node == null) {
                    return;
                }
                final HashMap alerts = AlertViewer.this.getAlertMap(node);
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        AlertViewer.this.plugin.clearAlerts(alerts);
                        return null;
                    }
                }.execute();
            }
        };
        this.clearAction.putValue("ShortDescription", "Clear selected alerts.");
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(new JButton(this.clearAction));
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        this.freezeBox = new JCheckBox("Freeze");
        this.freezeBox.setSelected(false);
        this.freezeBox.addActionListener(e -> {
            if (!this.freezeBox.isSelected()) {
                this.tree.getSelectedNode().fillInfoPanel(this);
            }
        });
        this.freezeBox.setToolTipText("Freeze information panel content");
        buttonPanel.add(this.freezeBox);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        this.historyBox = new JCheckBox("History");
        this.historyBox.setSelected((Boolean)this.plugin.getServices().getProperty("history"));
        this.historyBox.addActionListener(e -> {
            this.plugin.getServices().setProperty("history", this.historyBox.isSelected());
            this.tree.getSelectedNode().fillInfoPanel(this);
        });
        this.historyBox.setToolTipText("Show history of alerts");
        buttonPanel.add(this.historyBox);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        this.muteBox = new JCheckBox("Mute");
        this.muteBox.setSelected((Boolean)this.plugin.getServices().getProperty("mute"));
        this.muteBox.addActionListener(e -> this.plugin.getServices().setProperty("mute", this.muteBox.isSelected()));
        this.muteBox.setToolTipText("Disable audio alerts");
        buttonPanel.add(this.muteBox);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        this.selectNewBox = new JCheckBox("Select new alerts");
        this.selectNewBox.setSelected((Boolean)this.plugin.getServices().getProperty("selectLast"));
        this.selectNewBox.addActionListener(e -> this.plugin.getServices().setProperty("selectLast", this.selectNewBox.isSelected()));
        this.selectNewBox.setToolTipText("Automatically select new alerts");
        buttonPanel.add(this.selectNewBox);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        this.toFrontBox = new JCheckBox("Show viewer on alert");
        this.toFrontBox.setSelected((Boolean)this.plugin.getServices().getProperty("toFront"));
        this.toFrontBox.addActionListener(e -> this.plugin.getServices().setProperty("toFront", this.toFrontBox.isSelected()));
        this.toFrontBox.setToolTipText("Display alert viewer when new alerts are received");
        buttonPanel.add(this.toFrontBox);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tree = AlertTree.getInstance();
        this.tree.addTreeSelectionListener(e -> {
            AlertNode node = this.tree.getSelectedNode();
            if (node == null) {
                this.clearAction.setEnabled(false);
                this.historyBox.setEnabled(false);
                if (!this.freezeBox.isSelected()) {
                    this.infoPanel.setText("");
                }
            } else {
                this.clearAction.setEnabled(true);
                this.historyBox.setEnabled(node.isLeaf());
                if (!this.freezeBox.isSelected()) {
                    node.fillInfoPanel(this);
                }
            }
        });
        this.tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AlertViewer.this.freezeBox.isSelected()) {
                    AlertViewer.this.freezeBox.doClick();
                }
            }
        });
        this.infoPanel = new JTextPane();
        this.infoPanel.setEditable(false);
        this.infoPanel.setContentType("text/plain");
        this.infoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        try {
            DefaultCaret caret = (DefaultCaret)this.infoPanel.getCaret();
            caret.setUpdatePolicy(1);
        }
        catch (ClassCastException caret) {
            // empty catch block
        }
        this.infoPanel.setText("");
        this.document = this.infoPanel.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        this.attBase = this.document.addStyle("attBase", style);
        this.attBlack = this.document.addStyle("attBlack", this.attBase);
        this.attBlackBold = this.document.addStyle("attBlackBold", this.attBase);
        StyleConstants.setBold(this.attBlackBold, true);
        for (AlertState state : AlertState.values()) {
            style = this.document.addStyle(state.name(), this.attBase);
            StyleConstants.setForeground(style, COLOR.get(state));
            this.attPlane.put(state, style);
            style = this.document.addStyle(state.name(), style);
            StyleConstants.setBold(style, true);
            this.attBold.put(state, style);
        }
        this.rightPanel = new JPanel(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.infoPanel);
        this.rightPanel.add((Component)scroll, "Center");
        this.rightPanel.add((Component)buttonPanel, "South");
        this.leftPanel = new JScrollPane(this.tree);
        this.rootPanel = new JSplitPane(1, this.leftPanel, this.rightPanel);
        Dimension minimumSize = new Dimension(100, 50);
        this.leftPanel.setMinimumSize(minimumSize);
        this.rightPanel.setMinimumSize(minimumSize);
        this.rootPanel.setOneTouchExpandable(false);
        this.rootPanel.setResizeWeight(0.3);
        this.rootPanel.resetToPreferredSizes();
        HashMap<Object, Object> par = new HashMap<Object, Object>();
        DataPanelDescriptor panDesc = this.config.getPage();
        if (panDesc != null && panDesc.isOpen() && (data = panDesc.getData()) != null) {
            par.putAll(data);
        }
        par.put(Panel.TITLE, "Alerts");
        Consumer<JComponent> onClose = c -> this.stop();
        par.put(Panel.ON_CLOSE, onClose);
        Console.getConsole().getPanelManager().open((Component)this.rootPanel, par);
    }

    void stop() {
        if (this.rootPanel == null) {
            return;
        }
        this.config = this.save();
        this.clearAction = null;
        this.historyBox = null;
        this.muteBox = null;
        this.toFrontBox = null;
        this.tree = null;
        this.infoPanel = null;
        this.rightPanel = null;
        this.leftPanel = null;
        this.rootPanel = null;
    }

    void destroy() {
        if (this.rootPanel != null) {
            Console.getConsole().getPanelManager().close(this.rootPanel);
        }
    }

    public void onAlert(AlertEvent event) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.update(event);
        } else {
            SwingUtilities.invokeLater(() -> this.update(event));
        }
    }

    private void update(AlertEvent event) {
        TreePath path;
        String source = event.getSource();
        RaisedAlertSummary summary = event.getSummary();
        if (summary == null) {
            AlertNode sourceNode;
            if (this.tree != null && (sourceNode = this.getSourceNode(source)) != null) {
                sourceNode.removeFromParent();
                this.tree.getModel().reload();
                this.tree.clearSelection();
            }
            return;
        }
        Set currentAlerts = summary.getAllRaisedAlertHistories();
        if (this.tree == null) {
            if (currentAlerts.isEmpty()) {
                return;
            }
            this.start();
        }
        TreePath selPath = this.tree.getSelectionPath();
        AlertNode sourceNode = this.getSourceNode(source);
        if (sourceNode == null) {
            if (currentAlerts.isEmpty()) {
                return;
            }
            sourceNode = new AlertNode(source);
            for (Object h2 : currentAlerts) {
                this.updateAlert(sourceNode, (RaisedAlertHistory)h2);
            }
            this.tree.getRoot().add(sourceNode);
        } else {
            HashMap id2history = new HashMap(currentAlerts.size() * 2);
            currentAlerts.forEach(h -> id2history.put(h.getLatestAlert().getAlertId(), h));
            for (IDNode idNode : sourceNode.getLeaves()) {
                String id = idNode.getID();
                RaisedAlertHistory history = (RaisedAlertHistory)id2history.remove(id);
                if (history == null) {
                    this.removeAlert(idNode);
                    continue;
                }
                this.updateAlert(sourceNode, history);
            }
            for (RaisedAlertHistory h3 : id2history.values()) {
                this.updateAlert(sourceNode, h3);
            }
        }
        ArrayList<TreePath> state = TreeUtil.saveExpansionState(this.tree);
        this.tree.getModel().reload();
        TreeUtil.restoreExpansionState(this.tree, state);
        if (this.selectNewBox.isSelected()) {
            Object[] objectArray;
            IDNode idNode;
            String id = "";
            Alert alert = event.getAlert();
            if (alert == null) {
                for (String clearedID : event.getClearedIds()) {
                    try {
                        if (!event.isPartialClear(clearedID)) continue;
                        id = clearedID;
                        break;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                }
            } else {
                id = alert.getAlertId();
            }
            IDNode iDNode = idNode = id.isEmpty() ? null : this.tree.findID(sourceNode, id);
            if (idNode == null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.tree.getRoot();
                objectArray = objectArray2;
                objectArray2[1] = sourceNode;
            } else {
                objectArray = idNode.getPath();
            }
            path = new TreePath(objectArray);
        } else {
            path = selPath;
        }
        if (this.isValidPath(path)) {
            this.tree.setSelectionPath(path);
            this.tree.expandPath(path);
        } else {
            this.tree.clearSelection();
        }
        if (!this.muteBox.isSelected()) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.toFrontBox.isSelected()) {
            this.toFront();
        }
    }

    void toFront() {
        if (this.rootPanel == null) {
            AlertService serv = (AlertService)this.plugin.getConsole().getAgentService(AlertService.class);
            LinkedList events = new LinkedList();
            AlertListener temp = e -> events.add(e);
            serv.addListener(temp);
            serv.removeListener(temp);
            events.forEach(e -> this.update((AlertEvent)e));
        } else {
            PanelManager panMan = this.plugin.getConsole().getPanelManager();
            try {
                panMan.set(this.rootPanel, Panel.SELECTED, true);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private AlertNode getSourceNode(String source) {
        AlertNode root = this.tree.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            AlertNode node = root.getChildAt(i);
            if (!node.getUserObject().equals(source)) continue;
            return node;
        }
        return null;
    }

    private HashMap<String, String[]> getAlertMap(AlertNode node) {
        HashMap<String, String[]> alerts = new HashMap<String, String[]>();
        if (node instanceof IDNode) {
            IDNode idNode = (IDNode)node;
            alerts.put(node.getSource(), new String[]{idNode.getID()});
        } else if (node.isRoot()) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                AlertNode sourceNode = (AlertNode)e.nextElement();
                alerts.put(sourceNode.getSource(), null);
            }
        } else if (node.getLevel() == 1) {
            alerts.put(node.getSource(), null);
        } else {
            String source = node.getSource();
            ArrayList<String> ids = new ArrayList<String>();
            Enumeration<TreeNode> e = node.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                TreeNode o = e.nextElement();
                if (!(o instanceof IDNode)) continue;
                IDNode idNode = (IDNode)o;
                ids.add(idNode.getID());
            }
            alerts.put(source, ids.toArray(new String[0]));
        }
        return alerts;
    }

    public static String formatTimeStamp(Instant instant) {
        return Const.DEFAULT_DT_FORMAT.format(instant);
    }

    private void updateAlert(AlertNode sourceNode, RaisedAlertHistory history) {
        String id = history.getLatestAlert().getAlertId();
        String[] ss = id.split("/");
        ArrayList<String> tokens = new ArrayList<String>(ss.length);
        for (String s : ss) {
            if ((s = s.trim()).isEmpty()) continue;
            tokens.add(s);
        }
        if (tokens.isEmpty()) {
            return;
        }
        for (int i = 0; i < tokens.size() - 1; ++i) {
            String s = (String)tokens.get(i);
            AlertNode tokenNode = null;
            Enumeration<TreeNode> e = sourceNode.children();
            while (e.hasMoreElements()) {
                AlertNode node = (AlertNode)e.nextElement();
                if (node.isLeaf() || !node.getUserObject().equals(s)) continue;
                tokenNode = node;
                break;
            }
            if (tokenNode == null) {
                tokenNode = new AlertNode(s);
                sourceNode.add(tokenNode);
            }
            sourceNode = tokenNode;
        }
        IDNode idNode = null;
        Enumeration<TreeNode> e = sourceNode.children();
        while (e.hasMoreElements()) {
            IDNode node;
            TreeNode o = e.nextElement();
            if (!(o instanceof IDNode) || !(node = (IDNode)o).getID().equals(id)) continue;
            idNode = node;
            break;
        }
        if (idNode == null) {
            idNode = new IDNode(history);
            sourceNode.add(idNode);
        } else {
            idNode.setHistory(history);
        }
    }

    private void removeAlert(IDNode idNode) {
        AlertNode node = idNode;
        AlertNode parent;
        while ((parent = node.getParent()) != null) {
            if (parent.isRoot() || parent.getChildCount() > 1) {
                node.removeFromParent();
                return;
            }
            node = parent;
        }
        return;
    }

    private boolean isValidPath(TreePath path) {
        if (path == null) {
            return false;
        }
        int n = path.getPathCount();
        if (n == 0) {
            return false;
        }
        AlertNode child = (AlertNode)path.getLastPathComponent();
        for (int i = n - 2; i >= 0; --i) {
            AlertNode parentFromPath = (AlertNode)path.getPathComponent(i);
            AlertNode parentFromChild = child.getParent();
            if (parentFromPath == null || parentFromChild == null || !parentFromPath.equals(parentFromChild)) {
                return false;
            }
            child = parentFromPath;
        }
        return child.equals(this.tree.getRoot());
    }

    Descriptor save() {
        if (this.rootPanel != null) {
            this.config.setPage(DataPanelDescriptor.get(this.rootPanel));
        }
        return this.config;
    }

    static {
        COLOR.put(AlertState.NOMINAL, new Color(0, 170, 0));
        COLOR.put(AlertState.WARNING, new Color(0, 0, 170));
        COLOR.put(AlertState.ALARM, new Color(170, 0, 0));
    }

    static class AlertNode
    extends DefaultMutableTreeNode
    implements Comparable<AlertNode> {
        private boolean mute;
        private boolean ignore;

        AlertNode(String userObject) {
            super(userObject);
        }

        @Override
        public String getUserObject() {
            return (String)super.getUserObject();
        }

        @Override
        public int compareTo(AlertNode other) {
            return this.getUserObject().compareTo(other.getUserObject());
        }

        @Override
        public void add(MutableTreeNode newChildNode) {
            AlertNode newChild = (AlertNode)newChildNode;
            Enumeration<TreeNode> e = this.children();
            int i = 0;
            boolean replace = false;
            while (e.hasMoreElements()) {
                AlertNode child = (AlertNode)e.nextElement();
                int c = newChild.compareTo(child);
                if (c > 0) {
                    ++i;
                    continue;
                }
                if (c != 0) break;
                replace = true;
                break;
            }
            if (replace) {
                this.remove(i);
            }
            this.insert(newChild, i);
        }

        @Override
        public AlertNode getParent() {
            return (AlertNode)super.getParent();
        }

        @Override
        public AlertNode getChildAt(int index) {
            return (AlertNode)super.getChildAt(index);
        }

        public ArrayList<IDNode> getLeaves() {
            ArrayList<IDNode> out = new ArrayList<IDNode>(this.getLeafCount());
            Enumeration<TreeNode> e = this.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                TreeNode node = e.nextElement();
                if (!(node instanceof IDNode)) continue;
                out.add((IDNode)node);
            }
            return out;
        }

        void fillInfoPanel(AlertViewer v) {
            StyledDocument d = v.document;
            try {
                d.remove(0, d.getLength());
                d.insertString(d.getLength(), "Source: ", v.attBlack);
                d.insertString(d.getLength(), this.getSource() + "\n", v.attBlackBold);
                d.insertString(d.getLength(), "Alerts selected: ", v.attBlack);
                d.insertString(d.getLength(), this.getLeafCount() + "\n", v.attBlackBold);
                d.insertString(d.getLength(), "Highest alert level: ", v.attBlack);
                AlertState highestState = this.getAlertLevel();
                d.insertString(d.getLength(), highestState + "\n", (AttributeSet)v.attBold.get(highestState));
                d.insertString(d.getLength(), "Last changed at ", v.attBlack);
                d.insertString(d.getLength(), Const.DEFAULT_DT_FORMAT.format(this.getTimeStamp()) + "\n", v.attBlackBold);
                v.infoPanel.setCaretPosition(0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        String getSource() {
            int level = this.getLevel();
            if (level > 1) {
                return this.getParent().getSource();
            }
            return this.getUserObject();
        }

        Instant getTimeStamp() {
            Instant out = Instant.EPOCH;
            if (this.children != null) {
                for (Object child : this.children) {
                    Instant time = ((AlertNode)child).getTimeStamp();
                    if (time.compareTo(out) <= 0) continue;
                    out = time;
                }
            }
            return out;
        }

        AlertState getAlertLevel() {
            AlertState childState;
            AlertState alertState = AlertState.NOMINAL;
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements() && ((childState = ((AlertNode)e.nextElement()).getAlertLevel()).compareTo((Enum)alertState) <= 0 || !(alertState = childState).equals((Object)AlertState.ALARM))) {
            }
            return alertState;
        }

        WatchState getWatchState() {
            WatchState thisState;
            WatchState watchState = this.isIgnore() ? WatchState.IGNORE : (thisState = this.isMute() ? WatchState.MUTE : WatchState.ACTIVE);
            if (thisState == WatchState.IGNORE) {
                return WatchState.IGNORE;
            }
            WatchState parentState = this.getParent().getWatchState();
            return thisState.compareTo(parentState) == -1 ? parentState : thisState;
        }

        boolean isMute() {
            return this.mute;
        }

        void setMute(boolean isMute) {
            this.mute = isMute;
        }

        boolean isIgnore() {
            return this.ignore;
        }

        void setIgnore(boolean isIgnored) {
            this.ignore = isIgnored;
        }
    }

    private static class AlertTree
    extends JTree {
        private AlertTree() {
        }

        static AlertTree getInstance() {
            AlertTree t = new AlertTree();
            t.setModel(new AlertTreeModel());
            t.getSelectionModel().setSelectionMode(1);
            t.setCellRenderer(new AlertTreeRenderer());
            ToolTipManager.sharedInstance().registerComponent(t);
            return t;
        }

        public AlertNode getSelectedNode() {
            return (AlertNode)this.getLastSelectedPathComponent();
        }

        @Override
        public AlertTreeModel getModel() {
            return (AlertTreeModel)super.getModel();
        }

        AlertNode getRoot() {
            return this.getModel().getRoot();
        }

        IDNode findID(AlertNode sourceNode, String id) {
            if (sourceNode == null) {
                return null;
            }
            Enumeration<TreeNode> e = sourceNode.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                TreeNode node = e.nextElement();
                if (!(node instanceof IDNode) || !((IDNode)node).getID().equals(id)) continue;
                return (IDNode)node;
            }
            return null;
        }
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private DataPanelDescriptor page;

        public DataPanelDescriptor getPage() {
            return this.page;
        }

        public void setPage(DataPanelDescriptor page) {
            this.page = page;
        }
    }

    private static class AlertTreeModel
    extends DefaultTreeModel {
        AlertTreeModel() {
            super(new AlertNode("CCS Alerts"){

                @Override
                WatchState getWatchState() {
                    return this.isIgnore() ? WatchState.IGNORE : (this.isMute() ? WatchState.MUTE : WatchState.ACTIVE);
                }

                @Override
                void fillInfoPanel(AlertViewer v) {
                    int activeAlerts = 0;
                    if (this.children != null) {
                        for (Object child : this.children) {
                            if (((AlertNode)child).getAlertLevel() == AlertState.NOMINAL) continue;
                            ++activeAlerts;
                        }
                    }
                    StyledDocument d = v.document;
                    try {
                        d.remove(0, d.getLength());
                        d.insertString(d.getLength(), "CCS Control System\n\n", v.attBlackBold);
                        d.insertString(d.getLength(), "Subsystems with active alerts: ", v.attBlack);
                        d.insertString(d.getLength(), activeAlerts + "\n", v.attBlackBold);
                        d.insertString(d.getLength(), "Overall alert level: ", v.attBlack);
                        d.insertString(d.getLength(), this.getAlertLevel() + "\n", (AttributeSet)v.attBold.get(this.getAlertLevel()));
                        d.insertString(d.getLength(), "Last changed at ", v.attBlack);
                        d.insertString(d.getLength(), Const.DEFAULT_DT_FORMAT.format(this.getTimeStamp()) + "\n", v.attBlackBold);
                        v.infoPanel.setCaretPosition(0);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }

                @Override
                String getSource() {
                    throw new UnsupportedOperationException("Trying to look up source subsystem for the root node.");
                }
            });
        }

        @Override
        public AlertNode getRoot() {
            return (AlertNode)super.getRoot();
        }
    }

    final class IDNode
    extends AlertNode {
        private RaisedAlertHistory history;

        IDNode(RaisedAlertHistory history) {
            super(history.getLatestAlert().getAlertId());
            this.setHistory(history);
        }

        void setHistory(RaisedAlertHistory history) {
            this.history = history;
        }

        RaisedAlertHistory getHistory() {
            return this.history;
        }

        String getID() {
            return this.getUserObject();
        }

        @Override
        public String toString() {
            return this.getLastIdComponent();
        }

        String getLastIdComponent() {
            String[] ss = this.getID().split("/");
            int i = ss.length;
            while (i > 0) {
                String s;
                if ((s = ss[--i].trim()).isEmpty()) continue;
                return s;
            }
            return this.getID();
        }

        @Override
        void fillInfoPanel(AlertViewer v) {
            Alert alert = this.history.getLatestAlert();
            StyledDocument d = v.document;
            try {
                d.remove(0, d.getLength());
                d.insertString(d.getLength(), "Source: ", v.attBlack);
                d.insertString(d.getLength(), this.getSource() + "\n", v.attBlackBold);
                d.insertString(d.getLength(), "ID: ", v.attBlack);
                d.insertString(d.getLength(), alert.getAlertId() + "\n", v.attBlackBold);
                d.insertString(d.getLength(), "Description: ", v.attBlack);
                d.insertString(d.getLength(), alert.getDescription() + "\n", v.attBlackBold);
                d.insertString(d.getLength(), "Highest level: ", v.attBlack);
                d.insertString(d.getLength(), this.history.getHighestAlertState() + "\n\n", (AttributeSet)v.attBold.get(this.history.getHighestAlertState()));
                ArrayList alerts = this.history.getRaisedAlertInstancesList();
                if (AlertViewer.this.historyBox.isSelected()) {
                    d.insertString(d.getLength(), "History:\n\n", v.attBlackBold);
                    int n = alerts.size();
                    int nShow = Math.min(n, 50);
                    for (int i = 0; i < nShow; ++i) {
                        RaisedAlertInstance ra = (RaisedAlertInstance)alerts.get(n - 1 - i);
                        d.insertString(d.getLength(), AlertViewer.formatTimeStamp(ra.getCCSTimeStamp().getUTCInstant()) + " " + ra.getAlertState() + "\n", (AttributeSet)v.attBold.get(ra.getAlertState()));
                        d.insertString(d.getLength(), ra.getCause() + "\n\n", v.attBlack);
                    }
                    if (nShow < n) {
                        if (nShow < n - 1) {
                            d.insertString(d.getLength(), "...\n\n" + (n - nShow - 1) + " more.\n\n...\n\n", v.attBlack);
                        }
                        RaisedAlertInstance ra = (RaisedAlertInstance)alerts.get(0);
                        d.insertString(d.getLength(), AlertViewer.formatTimeStamp(ra.getCCSTimeStamp().getUTCInstant()) + " " + ra.getAlertState() + "\n", (AttributeSet)v.attPlane.get(ra.getAlertState()));
                        d.insertString(d.getLength(), ra.getCause() + "\n\n", v.attBlack);
                    }
                } else {
                    int n = alerts.size();
                    if (n > 1) {
                        d.insertString(d.getLength(), "Last raised: " + AlertViewer.formatTimeStamp(this.history.getLatestAlertCCSTimeStamp().getUTCInstant()) + " : ", v.attBlackBold);
                        d.insertString(d.getLength(), this.history.getLatestAlertState() + "\n", (AttributeSet)v.attBold.get(this.history.getLatestAlertState()));
                        d.insertString(d.getLength(), ((RaisedAlertInstance)alerts.get(n - 1)).getCause() + "\n\n", v.attBlack);
                        RaisedAlertInstance first = (RaisedAlertInstance)alerts.get(0);
                        d.insertString(d.getLength(), "First raised: " + AlertViewer.formatTimeStamp(first.getCCSTimeStamp().getUTCInstant()) + " : ", v.attBlackBold);
                        d.insertString(d.getLength(), first.getAlertState() + "\n", (AttributeSet)v.attBold.get(first.getAlertState()));
                        d.insertString(d.getLength(), first.getCause() + "\n", v.attBlack);
                    } else if (n > 0) {
                        d.insertString(d.getLength(), "Raised: " + AlertViewer.formatTimeStamp(this.history.getLatestAlertCCSTimeStamp().getUTCInstant()) + " : ", v.attBlackBold);
                        d.insertString(d.getLength(), this.history.getLatestAlertState() + "\n", (AttributeSet)v.attBold.get(this.history.getLatestAlertState()));
                        d.insertString(d.getLength(), ((RaisedAlertInstance)alerts.get(0)).getCause() + "\n", v.attBlack);
                    }
                }
                v.infoPanel.setCaretPosition(0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        Instant getTimeStamp() {
            return this.history.getLatestAlertCCSTimeStamp().getUTCInstant();
        }

        @Override
        AlertState getAlertLevel() {
            return this.history.getHighestAlertState();
        }
    }

    private static class AlertTreeRenderer
    extends DefaultTreeCellRenderer {
        private AlertTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            try {
                AlertNode node = (AlertNode)value;
                AlertState state = node.getAlertLevel();
                if (!sel) {
                    this.setForeground((Color)COLOR.get(state));
                }
                if (leaf) {
                    this.setToolTipText(((IDNode)node).getHistory().getLatestAlert().getDescription());
                } else {
                    this.setToolTipText(null);
                }
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
            return this;
        }
    }

    private static enum WatchState {
        ACTIVE,
        MUTE,
        IGNORE;

    }
}

