/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public class MonitorFormat {
    public static final MonitorFormat DEFAULT = new MonitorFormat();

    public FormattedValue format(MonitorField field, List<AgentChannel> channels) {
        return field.format(channels);
    }

    public FormattedValue format(MonitorField field, AgentChannel channel) {
        return field.format(channel);
    }

    public boolean format(MonitorCell cell) {
        List<AgentChannel> channels = cell.getChannels().stream().flatMap(h -> h.getChannels().stream()).collect(Collectors.toList());
        FormattedValue fv = this.format(cell.getField(), channels);
        if (Objects.equals(fv, cell.getFormattedValue())) {
            return false;
        }
        cell.setFormattedValue(fv);
        return true;
    }

    public boolean format(MonitorCell cell, DisplayChannel channelHandle) {
        return this.format(cell);
    }

    public FormattedValue format(MonitorField field, DisplayChannel channelHandle) {
        return this.format(field, channelHandle.getChannels());
    }
}

