/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mmm;

import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeUtils;

public class AlertPredicate
implements Predicate<Alert> {
    private final Map<String, String> properties;
    private Pattern originPattern;
    private Pattern idPattern;
    private Pattern causePattern;
    private Pattern severityPattern;

    public AlertPredicate(String propertiesStr) {
        this.properties = (Map)InputConversionEngine.convertArgToType((String)propertiesStr, Map.class);
        this.updatePatterns();
    }

    public AlertPredicate(Map<String, String> properties) {
        this.properties = properties;
        this.updatePatterns();
    }

    private void updatePatterns() {
        block12: for (Map.Entry<String, String> e : this.properties.entrySet()) {
            String property = e.getKey();
            String propertyValue = e.getValue();
            Pattern p = Pattern.compile(propertyValue);
            switch (property) {
                case "cause": {
                    this.causePattern = p;
                    continue block12;
                }
                case "id": {
                    this.idPattern = p;
                    continue block12;
                }
                case "origin": {
                    this.originPattern = p;
                    continue block12;
                }
                case "severity": {
                    this.severityPattern = p;
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Unsupported predicate property: " + property);
        }
    }

    @Override
    public boolean test(Alert alert) {
        if (this.idPattern != null) {
            return this.idPattern.matcher(alert.getAlertId()).matches();
        }
        return true;
    }

    public boolean testOrigin(String origin) {
        if (this.originPattern != null) {
            return this.originPattern.matcher(origin).matches();
        }
        return true;
    }

    public boolean testCause(String cause) {
        if (this.causePattern != null) {
            return this.causePattern.matcher(cause).matches();
        }
        return true;
    }

    public boolean testSeverity(String severity) {
        if (this.severityPattern != null) {
            return this.severityPattern.matcher(severity).matches();
        }
        return true;
    }

    public String toString() {
        return TypeUtils.stringify(this.properties);
    }
}

