/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class KeyValueData
implements Serializable {
    private static final long serialVersionUID = -45918237359438L;
    private final String key;
    private final Serializable value;
    private final CCSTimeStamp ccsTimeStamp;
    protected transient boolean needsEncoding = false;
    private final KeyValueDataType type;
    private static final transient List<Class> SKIP_ENCODING_TYPES = Arrays.asList(Boolean.class, Short.class, Integer.class, Float.class, Double.class, Long.class, String.class, byte[].class, boolean[].class, short[].class, int[].class, float[].class, double[].class, long[].class, String[].class, BitSet.class, BigDecimal.class);

    public KeyValueData(String key, Serializable value, CCSTimeStamp ccsTimeStamp, KeyValueDataType type) {
        this.key = key;
        this.value = value;
        this.type = type;
        this.ccsTimeStamp = ccsTimeStamp;
        this.updateNeedsEncoding(value);
    }

    public KeyValueData(String key, Serializable value, CCSTimeStamp ccsTimeStamp) {
        this(key, value, ccsTimeStamp, KeyValueDataType.KeyValueTrendingData);
    }

    public KeyValueData(String key, Serializable value) {
        this(key, value, CCSTimeStamp.currentTime());
    }

    public CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimeStamp;
    }

    public Serializable getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public KeyValueDataType getType() {
        return this.type;
    }

    public String toString() {
        return "KeyValueData{ key=" + this.key + ", value=" + this.value + ", timestamp=" + this.ccsTimeStamp + ", type=" + (Object)((Object)this.type) + " }";
    }

    protected final void updateNeedsEncoding(Object obj) {
        Class<?> clazz;
        if (!(this.needsEncoding || obj == null || (clazz = obj.getClass()).isPrimitive() || SKIP_ENCODING_TYPES.contains(clazz))) {
            this.needsEncoding = true;
        }
    }

    public boolean needsEncoding() {
        return this.needsEncoding;
    }

    public static enum KeyValueDataType {
        KeyValueTrendingData,
        KeyValuePlotData,
        KeyValueMetaData;

    }
}

