/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.HeaderSpecification;

public class FitsHeadersSpecifications {
    private static final Map<String, HeaderSpecification> IMAGE_WRITER_CONFIG = new LinkedHashMap<String, HeaderSpecification>();

    static final void loadDefaultSpecFiles() {
        FitsHeadersSpecifications.addSpecFile("primary");
        FitsHeadersSpecifications.addSpecFile("extended");
    }

    public static final void addSpecFile(String fileName) {
        FitsHeadersSpecifications.readHeaderSpecification(fileName, null);
    }

    public static final void addSpecFile(String fileName, String headerName) {
        FitsHeadersSpecifications.readHeaderSpecification(fileName, headerName);
    }

    public static final Map<String, HeaderSpecification> getHeaderSpecifications() {
        return Collections.unmodifiableMap(IMAGE_WRITER_CONFIG);
    }

    private static void readHeaderSpecification(String name, String headerName) throws RuntimeException {
        String fileName;
        String string = fileName = name.endsWith(".spec") ? name : name + ".spec";
        if (headerName == null) {
            headerName = fileName.replace(".spec", "");
        }
        try (InputStream bootstrapResource = BootstrapResourceUtils.getBootstrapResource((String)fileName);){
            if (bootstrapResource == null) {
                FitsHeadersSpecificationsBuilder.log.severe((Object)("Failed to open spect file " + fileName));
                return;
            }
            HeaderSpecification desc = null;
            if (IMAGE_WRITER_CONFIG.containsKey(headerName)) {
                desc = IMAGE_WRITER_CONFIG.get(headerName);
                desc.loadHeaderSpecification(bootstrapResource);
            } else {
                desc = new HeaderSpecification(headerName, bootstrapResource);
                IMAGE_WRITER_CONFIG.put(headerName, desc);
            }
            FitsHeadersSpecificationsBuilder.log.log(Level.FINE, "Loaded fits header spec file {0}. Already loaded spec files: {1}", new Object[]{headerName, IMAGE_WRITER_CONFIG.keySet()});
        }
        catch (IOException x) {
            throw new RuntimeException("Error reading " + fileName, x);
        }
    }

    static {
        FitsHeadersSpecifications.loadDefaultSpecFiles();
    }
}

