/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import java.util.ArrayList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;

public class FTreeSelectionEvent {
    private TreeSelectionEvent event;
    private FTreeNode[] addedNodes = null;
    private FTreeNode[] removedNodes = null;
    private ArrayList add;
    private boolean haveNodesBeenChecked = false;
    private FTree tree;

    protected FTreeSelectionEvent(TreeSelectionEvent event, FTree tree) {
        this.event = event;
        this.tree = tree;
    }

    public FTree tree() {
        return this.tree;
    }

    public FTreeNode[] removedNodes() {
        if (!this.haveNodesBeenChecked) {
            this.checkNodes();
        }
        return this.removedNodes;
    }

    public FTreeNode[] addedNodes() {
        if (!this.haveNodesBeenChecked) {
            this.checkNodes();
        }
        return this.addedNodes;
    }

    public FTreeNode[] selectedNodes() {
        return this.tree.selectedNodes();
    }

    boolean isAddedNode(FTreeNode node) {
        if (!this.haveNodesBeenChecked) {
            this.checkNodes();
        }
        return this.add.contains(node);
    }

    private void checkNodes() {
        this.haveNodesBeenChecked = true;
        this.add = new ArrayList();
        TreePath[] paths = this.event.getPaths();
        for (int i = 0; i < paths.length; ++i) {
            if (!this.event.isAddedPath(i)) continue;
            this.add.add(paths[i].getLastPathComponent());
        }
        int added = this.add.size();
        int removed = paths.length - this.add.size();
        if (added > 0) {
            this.addedNodes = new FTreeNode[added];
        }
        if (removed > 0) {
            this.removedNodes = new FTreeNode[removed];
        }
        int addCounter = 0;
        int removeCounter = 0;
        for (int i = 0; i < paths.length; ++i) {
            if (this.event.isAddedPath(i)) {
                this.addedNodes[addCounter++] = (FTreeNode)paths[i].getLastPathComponent();
                continue;
            }
            this.removedNodes[removeCounter++] = (FTreeNode)paths[i].getLastPathComponent();
        }
    }
}

