/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.kafka.avro;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.lsst.ccs.camera.kafka.avro.RequestResult;
import org.lsst.ccs.camera.kafka.avro.Topic;

public class KafkaProxyUtils {
    private final Client client = ClientBuilder.newClient();
    private final WebTarget serv;
    private static final Logger LOG = Logger.getLogger(KafkaProxyUtils.class.getName());
    private final String clusterId;
    private String basePath = "v3/clusters";
    private final ObjectMapper mapper;
    private final Map<Schema, Integer> schemaIdMap = new ConcurrentHashMap<Schema, Integer>();
    private static Schema topicRegistrationSchema = ReflectData.get().getSchema(TopicRegistrationRequest.class);

    public KafkaProxyUtils(String baseUrl) {
        this.serv = this.client.target(baseUrl);
        this.mapper = new ObjectMapper();
        this.clusterId = this.getClusterId();
        this.basePath = this.basePath + "/" + this.clusterId;
    }

    KafkaProxyUtils() {
        this("https://data-int.lsst.cloud/sasquatch-rest-proxy");
    }

    private String getClusterId() {
        String sResult = (String)this.serv.path(this.basePath).request(new String[]{"application/json"}).get(String.class);
        try {
            return this.mapper.readTree(sResult).get("data").get(0).get("cluster_id").asText();
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException(jpe);
        }
    }

    public List<String> listTopics() {
        ArrayList<String> allTopics = new ArrayList<String>();
        String sResult = (String)this.serv.path(this.basePath).path("topics").request(new String[]{"application/json"}).get(String.class);
        try {
            Map jsonObject = (Map)this.mapper.readValue(sResult, Map.class);
            List data = (List)jsonObject.get("data");
            for (Object d : data) {
                allTopics.add((String)((Map)d).get("topic_name"));
            }
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException(jpe);
        }
        return allTopics;
    }

    public boolean registerKafkaTopic(Topic topic) {
        String topicCreationPayload;
        TopicRegistrationRequest request = new TopicRegistrationRequest(topic.getFullName());
        ReflectDatumWriter writer = new ReflectDatumWriter(TopicRegistrationRequest.class);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonEncoder encoder = EncoderFactory.get().jsonEncoder(topicRegistrationSchema, (OutputStream)baos);
            writer.write((Object)request, (Encoder)encoder);
            encoder.flush();
            topicCreationPayload = new String(baos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        try (Response response = this.serv.path(this.basePath).path("topics").request(new String[]{"application/json"}).post(Entity.entity((Object)topicCreationPayload, (String)"application/json"));){
            if (response.getStatus() != 201) {
                LOG.log(Level.WARNING, "Failed to register topic {0} with status code {1}: {2}", new Object[]{topic.getFullName(), response.getStatus(), response.readEntity(String.class)});
                boolean bl = false;
                return bl;
            }
            LOG.log(Level.INFO, "Topic {0} successfully created", new Object[]{topic.getFullName()});
            boolean bl = true;
            return bl;
        }
    }

    public RequestResult publishRecordsForSchema(Schema schema, List<GenericRecord> listOfRecords) {
        if (listOfRecords.isEmpty()) {
            LOG.log(Level.INFO, "No data to publish for schema {0}.", new Object[]{schema.getFullName()});
        }
        ArrayList<GenericRecordWithValue> listOfRecordsWithValue = new ArrayList<GenericRecordWithValue>();
        for (GenericRecord genericRecord : listOfRecords) {
            listOfRecordsWithValue.add(new GenericRecordWithValue(genericRecord));
        }
        Integer schemaId = this.schemaIdMap.get(schema);
        LinkedHashMap<String, Object> payloadMap = new LinkedHashMap<String, Object>();
        if (schemaId == null) {
            payloadMap.put("\"value_schema\"", "\"" + schema.toString().replace("\"", "\\\"") + "\"");
        } else {
            payloadMap.put("\"value_schema_id\"", schemaId);
        }
        payloadMap.put("\"records\"", listOfRecordsWithValue);
        Entity payloadEntity = Entity.entity((Object)((Object)payloadMap).toString().replace("=", ":"), (String)"application/vnd.kafka.avro.v2+json");
        RequestResult result = new RequestResult(payloadEntity, listOfRecords.size());
        LOG.log(Level.FINER, () -> {
            try {
                return "Payload for topic " + schema.getFullName() + ": " + this.prettyPrintJsonObject(payloadEntity.getEntity().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Problem with printing payload for " + schema.getFullName() + ": " + e.getMessage();
            }
        });
        try (Response response = this.serv.path("topics").path(schema.getFullName()).request(new String[]{"application/vnd.kafka.avro.v2+json"}).accept(new String[]{"application/vnd.kafka.v2+json"}).post(payloadEntity);){
            Object id;
            Map responseContent = (Map)response.readEntity(Map.class);
            if (schemaId == null && (id = responseContent.get("value_schema_id")) != null) {
                this.schemaIdMap.put(schema, (Integer)id);
            }
            if (response.getStatus() != 200) {
                LOG.log(Level.WARNING, "Failed to publish data for topic {0} with status code {1}: {2}\n Published payload: {3}", new Object[]{schema.getFullName(), response.getStatus(), responseContent, this.prettyPrintJsonObject(payloadEntity.getEntity().toString())});
                throw new RuntimeException("Failed to publish data for " + schema.getFullName() + " " + response.getStatus() + " " + responseContent);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed request for topic " + schema.getFullName(), e);
            throw new RuntimeException("Failed request for topic " + schema.getFullName(), e);
        }
        result.done();
        LOG.log(Level.FINE, () -> "Published " + listOfRecords.size() + " records in " + result.getTimeInMillis() + " ms with payload size " + result.getRequestSize() + " Kb for topic " + schema.getFullName());
        return result;
    }

    public static void main(String[] args) {
        KafkaProxyUtils proxy = new KafkaProxyUtils();
        List<String> allTopics = proxy.listTopics();
        for (String topicName : allTopics) {
            System.out.println(topicName);
        }
    }

    private String prettyPrintJsonObject(String jsonString) {
        try {
            Object jsonObject = this.mapper.readValue(jsonString, Object.class);
            String prettyJson = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
            return prettyJson;
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException(jpe);
        }
    }

    private static class TopicRegistrationRequest {
        private final String topic_name;
        private final int partitions_count = 1;
        private final int replication_factor = 3;

        public TopicRegistrationRequest(String topicName) {
            this.topic_name = topicName;
        }
    }

    private static class GenericRecordWithValue {
        private final GenericRecord genericRecord;

        GenericRecordWithValue(GenericRecord genericRecord) {
            this.genericRecord = genericRecord;
        }

        public String toString() {
            String result = "{ \"value\" : ";
            GenericDatumWriter writer = new GenericDatumWriter(this.genericRecord.getSchema());
            writer.setSchema(this.genericRecord.getSchema());
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                JsonEncoder encoder = EncoderFactory.get().jsonEncoder(this.genericRecord.getSchema(), (OutputStream)baos);
                writer.write((Object)this.genericRecord, (Encoder)encoder);
                encoder.flush();
                result = result + new String(baos.toByteArray());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            result = result + "}";
            return result;
        }
    }
}

