/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.data.RebPsState;

public class RebPsControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    private static final String CMND_GET_STATE = "getFullState";
    private static final int REB_Q = 3;
    private static final int N_REB = 6;
    private static final int N_PS = 8;
    private static final int PS_DIG = 0;
    private static final int PS_ANA = 1;
    private static final int PS_OD = 2;
    private static final int PS_CLKH = 3;
    private static final int PS_CLKL = 4;
    private static final int PS_HTR = 5;
    private static final int PS_DPHI = 6;
    private static final int PS_HV = 7;
    private static final String[] psNames = new String[8];
    private static final Map<Integer, Integer> btnMapSR;
    private static final Map<Integer, Integer> invBtnMapSR;
    private static final Map<Integer, Integer> btnMapCR;
    private static final Map<Integer, Integer> invBtnMapCR;
    private static final String SOLID_BAR = "\u2588\u2588";
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private final JPanel pnlSystemState = new JPanel();
    private JLabel lblPowerStateValue;
    private JLabel lblPsIdValue;
    private JButton btnMainPower;
    private TextFieldX tfPowerPeriod;
    private final JPanel pnlPowerControl = new JPanel();
    private final JComponent[][] cmpPsState = new JComponent[6][8];
    private final JButton[] btnSeqOn = new JButton[6];
    private final JButton[] btnSeqOff = new JButton[6];
    private final TextFieldX[] tfBiasDac = new TextFieldX[6];
    private final TextFieldX[] tfDphiDac = new TextFieldX[6];
    private int numReb = 0;
    private boolean gotCR = false;
    private static final long serialVersionUID = 1L;

    public RebPsControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((RebPsState)reply);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void updatePanel(RebPsState rs) {
        SwingUtilities.invokeLater(new UpdatePowerStatus(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        this.lblPowerStateValue = UiUtilities.newLabel((String)"X", (int)UiUtilities.maxLabelWidth((String[])new String[]{"STOPPED", "RUNNING"}, (String)""));
        this.lblPsIdValue = UiUtilities.newLabel((String)"MM-9999", (int)0);
        this.btnMainPower = this.uiUtils.newButton(SOLID_BAR, "M", true);
        this.tfPowerPeriod = this.uiUtils.newTextFieldX("00000.0", "P", 2, true);
        for (int reb = 0; reb < 6; ++reb) {
            this.btnSeqOn[reb] = this.uiUtils.newButton("On", "N" + reb, true);
            this.btnSeqOn[reb].setForeground(UiConstants.GREEN);
            this.btnSeqOff[reb] = this.uiUtils.newButton("Off", "F" + reb, true);
            this.btnSeqOff[reb].setForeground(UiConstants.RED);
            for (int ps = 0; ps < 8; ++ps) {
                this.cmpPsState[reb][ps] = ps == 7 || ps == 6 ? this.uiUtils.newButton(SOLID_BAR, "R" + (reb << 4 | ps), true) : UiUtilities.newLabel((String)SOLID_BAR, (int)0);
            }
            this.tfDphiDac[reb] = this.uiUtils.newTextFieldX("000000", "D" + reb, 1, true);
            this.tfBiasDac[reb] = this.uiUtils.newTextFieldX("000000", "B" + reb, 1, true);
        }
        this.drawStatus();
        this.pnlPowerControl.setLayout(new GridBagLayout());
        this.drawControl(6, false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 10, 6, 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.pnlSystemState, gbc);
        ++gbc.gridy;
        this.add((Component)this.pnlPowerControl, gbc);
    }

    private void drawStatus() {
        this.pnlSystemState.setLayout(new GridBagLayout());
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 17;
        gbs.insets = new Insets(5, 0, 5, 0);
        gbs.gridx = 0;
        gbs.gridy = 0;
        this.pnlSystemState.add((Component)UiUtilities.newLabel((String)"System State:", (int)0), gbs);
        ++gbs.gridx;
        gbs.insets.left = 5;
        this.pnlSystemState.add((Component)this.lblPowerStateValue, gbs);
        ++gbs.gridx;
        gbs.insets.left = 30;
        this.pnlSystemState.add((Component)UiUtilities.newLabel((String)"PS ID: ", (int)0), gbs);
        ++gbs.gridx;
        gbs.insets.left = 5;
        this.pnlSystemState.add((Component)this.lblPsIdValue, gbs);
        ++gbs.gridx;
        gbs.insets.left = 30;
        this.pnlSystemState.add((Component)UiUtilities.newLabel((String)"Main Power:", (int)0), gbs);
        ++gbs.gridx;
        gbs.insets.left = 5;
        this.pnlSystemState.add((Component)this.btnMainPower, gbs);
        ++gbs.gridx;
        gbs.insets.left = 30;
        this.pnlSystemState.add((Component)UiUtilities.newLabel((String)"Update Period:", (int)0), gbs);
        ++gbs.gridx;
        gbs.insets.left = 5;
        this.pnlSystemState.add((Component)this.tfPowerPeriod, gbs);
        ++gbs.gridx;
        this.pnlSystemState.add((Component)UiUtilities.newLabel((String)"sec", (int)0), gbs);
    }

    private void drawControl(int nReb, boolean isCR) {
        if (nReb == 0 || nReb == this.numReb && isCR == this.gotCR) {
            return;
        }
        this.numReb = nReb;
        this.gotCR = isCR;
        this.pnlPowerControl.removeAll();
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.insets = new Insets(0, 6, 4, 6);
        gbp.gridx = 1;
        gbp.gridwidth = 2;
        gbp.gridy = 0;
        this.pnlPowerControl.add((Component)UiUtilities.newLabel((String)"Sequenced", (int)0), gbp);
        gbp.gridx += 2;
        gbp.gridwidth = 1;
        for (int ps = 0; ps < 8; ++ps) {
            if (this.gotCR || ps != 6) {
                this.pnlPowerControl.add((Component)UiUtilities.newLabel((String)psNames[ps], (int)0), gbp);
                ++gbp.gridx;
            }
            if (this.gotCR && ps == 6) {
                this.pnlPowerControl.add((Component)UiUtilities.newLabel((String)"Dphi DAC", (int)0), gbp);
                ++gbp.gridx;
            }
            if (ps != 7) continue;
            this.pnlPowerControl.add((Component)UiUtilities.newLabel((String)"Bias DAC", (int)0), gbp);
            ++gbp.gridx;
        }
        gbp.gridx = 0;
        ++gbp.gridy;
        for (int reb = 0; reb < this.numReb; ++reb) {
            if (this.gotCR && reb % 3 == 2) continue;
            this.pnlPowerControl.add((Component)UiUtilities.newLabel((String)("REB" + reb + ":"), (int)0), gbp);
            ++gbp.gridx;
            this.pnlPowerControl.add((Component)this.btnSeqOn[reb], gbp);
            ++gbp.gridx;
            this.pnlPowerControl.add((Component)this.btnSeqOff[reb], gbp);
            ++gbp.gridx;
            for (int ps = 0; ps < 8; ++ps) {
                if (this.gotCR || ps != 6) {
                    if (ps != 5 || !this.gotCR || reb % 3 == 0) {
                        this.pnlPowerControl.add((Component)this.cmpPsState[reb][ps], gbp);
                    }
                    ++gbp.gridx;
                }
                if (this.gotCR && ps == 6) {
                    this.pnlPowerControl.add((Component)this.tfDphiDac[reb], gbp);
                    ++gbp.gridx;
                }
                if (ps != 7) continue;
                this.pnlPowerControl.add((Component)this.tfBiasDac[reb], gbp);
                ++gbp.gridx;
            }
            gbp.gridx = 0;
            ++gbp.gridy;
        }
    }

    public void handleButton(String name) {
        char type = name.charAt(0);
        if (type == 'M') {
            this.sender.sendCommand(null, "toggleMainPower", new Object[0]);
        } else if (type == 'R') {
            int srcPsReb = Integer.valueOf(name.substring(1));
            int dstPsReb = (this.gotCR ? invBtnMapCR : invBtnMapSR).get(srcPsReb);
            this.sender.sendCommand(null, "togglePower", new Object[]{dstPsReb >> 4, dstPsReb & 0xF});
        } else {
            int reb = Integer.valueOf(name.substring(1, 2));
            this.sender.sendCommand(null, "sequencePower", new Object[]{reb, type == 'N'});
        }
    }

    public void handleTextFieldX(String name, Object value) {
        char type = name.charAt(0);
        if (type == 'P') {
            this.sender.sendCommand(null, "setUpdatePeriod", new Object[]{(int)(1000.0 * (Double)value)});
        } else {
            int reb = Integer.valueOf(name.substring(1));
            this.sender.sendCommand(null, type == 'B' ? "setBiasDac" : "setDphiDac", new Object[]{reb, (Integer)value});
        }
    }

    static {
        RebPsControlPanel.psNames[0] = "Dig";
        RebPsControlPanel.psNames[1] = "Ana";
        RebPsControlPanel.psNames[2] = "OD";
        RebPsControlPanel.psNames[3] = "ClkH";
        RebPsControlPanel.psNames[4] = "ClkL";
        RebPsControlPanel.psNames[5] = "Htr";
        RebPsControlPanel.psNames[6] = "Dphi";
        RebPsControlPanel.psNames[7] = "HVbias";
        btnMapSR = new HashMap<Integer, Integer>();
        for (int reb = 0; reb < 6; ++reb) {
            btnMapSR.put(reb << 4 | 0, reb << 4 | 0);
            btnMapSR.put(reb << 4 | 1, reb << 4 | 1);
            btnMapSR.put(reb << 4 | 2, reb << 4 | 2);
            btnMapSR.put(reb << 4 | 3, reb << 4 | 3);
            btnMapSR.put(reb << 4 | 4, reb << 4 | 4);
            btnMapSR.put(reb << 4 | 5, reb << 4 | 5);
            btnMapSR.put(reb << 4 | 6, reb << 4 | 7);
        }
        invBtnMapSR = new HashMap<Integer, Integer>();
        for (int ps : btnMapSR.keySet()) {
            invBtnMapSR.put(btnMapSR.get(ps), ps);
        }
        btnMapCR = new HashMap<Integer, Integer>();
        for (int reb = 0; reb < 6; ++reb) {
            if (reb % 3 != 2) {
                btnMapCR.put(reb << 4 | 0, reb << 4 | 0);
            } else {
                btnMapCR.put(reb << 4 | 0, reb - 2 << 4 | 5);
            }
            btnMapCR.put(reb << 4 | 1, reb << 4 | 1);
            btnMapCR.put(reb << 4 | 2, reb << 4 | 2);
            btnMapCR.put(reb << 4 | 3, reb << 4 | 3);
            btnMapCR.put(reb << 4 | 4, reb << 4 | 4);
            btnMapCR.put(reb << 4 | 5, reb << 4 | 6);
            btnMapCR.put(reb << 4 | 6, reb << 4 | 7);
        }
        invBtnMapCR = new HashMap<Integer, Integer>();
        for (int ps : btnMapCR.keySet()) {
            invBtnMapCR.put(btnMapCR.get(ps), ps);
        }
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            RebPsControlPanel.this.lblPowerStateValue.setText("STOPPED");
            RebPsControlPanel.this.lblPowerStateValue.setForeground(UiConstants.RED);
            RebPsControlPanel.this.btnMainPower.setEnabled(false);
            RebPsControlPanel.this.btnMainPower.setForeground(Color.GRAY);
            RebPsControlPanel.this.tfPowerPeriod.setDisabled();
            for (int reb = 0; reb < RebPsControlPanel.this.numReb; ++reb) {
                RebPsControlPanel.this.btnSeqOn[reb].setEnabled(false);
                RebPsControlPanel.this.btnSeqOff[reb].setEnabled(false);
                for (int ps = 0; ps < 8; ++ps) {
                    RebPsControlPanel.this.cmpPsState[reb][ps].setEnabled(false);
                    RebPsControlPanel.this.cmpPsState[reb][ps].setForeground(Color.GRAY);
                }
                RebPsControlPanel.this.tfBiasDac[reb].setDisabled();
                RebPsControlPanel.this.tfDphiDac[reb].setDisabled();
            }
        }
    }

    class UpdatePowerStatus
    implements Runnable {
        private final RebPsState rs;

        UpdatePowerStatus(RebPsState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            int nReb = this.rs.getPowerState().length;
            boolean isCR = this.rs.getPsType() == 1;
            RebPsControlPanel.this.drawControl(nReb, isCR);
            RebPsControlPanel.this.lblPowerStateValue.setText("RUNNING");
            RebPsControlPanel.this.lblPowerStateValue.setForeground(UiConstants.GREEN);
            RebPsControlPanel.this.lblPsIdValue.setText(this.rs.getPsId());
            int mps = this.rs.getMainPowerState();
            Color color = mps == 1 ? UiConstants.GREEN : (mps == 0 ? UiConstants.RED : Color.GRAY);
            RebPsControlPanel.this.btnMainPower.setEnabled(color != Color.GRAY);
            RebPsControlPanel.this.btnMainPower.setForeground(color);
            RebPsControlPanel.this.tfPowerPeriod.update((Object)((double)this.rs.getTickMillis() / 1000.0), true);
            Map btnMap = isCR ? btnMapCR : btnMapSR;
            int[] state = this.rs.getPowerState();
            double[] bDacs = this.rs.getHvBiasDacs();
            double[] dDacs = this.rs.getDphiDacs();
            for (int reb = 0; reb < nReb; ++reb) {
                boolean present = state[reb] >= 0;
                RebPsControlPanel.this.btnSeqOn[reb].setEnabled(present);
                RebPsControlPanel.this.btnSeqOff[reb].setEnabled(present);
                for (int ps = 0; ps < 7; ++ps) {
                    color = present ? ((state[reb] & 1 << ps + 1) == 0 ? UiConstants.RED : UiConstants.GREEN) : Color.GRAY;
                    int btnPsReb = (Integer)btnMap.get(reb << 4 | ps);
                    RebPsControlPanel.this.cmpPsState[btnPsReb >> 4][btnPsReb & 0xF].setEnabled(present);
                    RebPsControlPanel.this.cmpPsState[btnPsReb >> 4][btnPsReb & 0xF].setForeground(color);
                }
                int value = reb < bDacs.length ? (int)bDacs[reb] : 0;
                RebPsControlPanel.this.tfBiasDac[reb].update((Object)value, present);
                value = reb < dDacs.length ? (int)dDacs[reb] : 0;
                RebPsControlPanel.this.tfDphiDac[reb].update((Object)value, present);
            }
        }
    }
}

