/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.subsystem.refrig.ui.BulkSupplyPanel;
import org.lsst.ccs.subsystem.refrig.ui.TrimHeaterPanel;

public class ThermalControlPanel
extends JPanel
implements CommandSender.ReplyHandler,
UiUtilities.ActionHandler {
    private static final String CMND_GET_STATE = "getSystemState";
    private final int LABEL_WIDTH = Math.max(TrimHeaterPanel.getLabelWidth(), BulkSupplyPanel.getLabelWidth());
    private final int STATE_WIDTH = Math.max(TrimHeaterPanel.getStateWidth(), BulkSupplyPanel.getStateWidth());
    private final CommandSender sender;
    private SystemStatusPanel statusPanel;
    private BulkSupplyPanel bulkPanel;
    private final TrimHeaterPanel[] trimHeaterPanels = new TrimHeaterPanel[7];
    private JPanel trimPanel;
    private final JPanel mainPanel = new JPanel();
    private Integer[] trimHeaters = new Integer[0];
    private static final long serialVersionUID = 1L;

    public ThermalControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((ThermalState)reply);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void updatePanel(ThermalState rs) {
        SwingUtilities.invokeLater(new UpdateThermalState(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        this.statusPanel = new SystemStatusPanel(this.sender, "MonitorControl");
        this.bulkPanel = new BulkSupplyPanel(this.sender, this.LABEL_WIDTH, this.STATE_WIDTH);
        for (int htr = 0; htr < 7; ++htr) {
            this.trimHeaterPanels[htr] = new TrimHeaterPanel(htr, this.sender, this.LABEL_WIDTH, this.STATE_WIDTH);
        }
        this.trimPanel = UiUtilities.newBorderedPanel((String)"Trim heater control");
        GridBagConstraints gbt = new GridBagConstraints();
        gbt.anchor = 18;
        gbt.insets = new Insets(5, 0, 2, 0);
        this.trimPanel.add((Component)this.bulkPanel, gbt);
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(5, 0, 0, 0);
        gbm.gridx = 0;
        gbm.gridy = 0;
        gbm.anchor = 11;
        this.mainPanel.add((Component)this.statusPanel, gbm);
        ++gbm.gridy;
        gbm.insets.bottom = 5;
        this.mainPanel.add((Component)this.trimPanel, gbm);
        this.add(this.mainPanel);
    }

    private void updateTrimPanel(Integer[] newTrimHeaters) {
        int n;
        Integer[] integerArray = this.trimHeaters;
        int n2 = integerArray.length;
        for (n = 0; n < n2; ++n) {
            int htr = integerArray[n];
            this.trimPanel.remove(this.trimHeaterPanels[htr]);
        }
        this.trimHeaters = newTrimHeaters;
        GridBagConstraints gbt = new GridBagConstraints();
        gbt.insets = new Insets(0, 0, 0, 0);
        gbt.gridx = 0;
        gbt.gridy = 1;
        gbt.anchor = 11;
        Integer[] integerArray2 = this.trimHeaters;
        n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int htr = integerArray2[i];
            gbt.insets.bottom = gbt.gridy == this.trimHeaters.length ? 5 : 0;
            this.trimPanel.add((Component)this.trimHeaterPanels[htr], gbt);
            gbt.insets.top = 0;
            ++gbt.gridy;
        }
    }

    public ThermalControlPanel() {
        this.sender = null;
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            ThermalControlPanel.this.statusPanel.disablePanel();
            ThermalControlPanel.this.bulkPanel.disablePanel();
            Integer[] integerArray = ThermalControlPanel.this.trimHeaters;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int htr = integerArray[i];
                ThermalControlPanel.this.trimHeaterPanels[htr].disablePanel();
            }
            ThermalControlPanel.this.repaint();
        }
    }

    class UpdateThermalState
    implements Runnable {
        private final ThermalState rs;

        UpdateThermalState(ThermalState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            ThermalControlPanel.this.statusPanel.updatePanel(this.rs.getTickMillis());
            ThermalControlPanel.this.bulkPanel.updatePanel(this.rs.getBulkPowerState());
            if (this.rs.getTrimHeaters().length != ThermalControlPanel.this.trimHeaters.length) {
                ThermalControlPanel.this.updateTrimPanel(this.rs.getTrimHeaters());
            }
            Integer[] integerArray = ThermalControlPanel.this.trimHeaters;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int htr = integerArray[i];
                ThermalControlPanel.this.trimHeaterPanels[htr].updatePanel(this.rs);
            }
            ThermalControlPanel.this.repaint();
        }
    }
}

