/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.PLCState;
import org.lsst.ccs.subsystem.refrig.constants.PcpHeaterState;
import org.lsst.ccs.subsystem.refrig.constants.PcpSwitchState;

@SkipEncoding
public class PcpSysState
implements Serializable {
    public static final String KEY = "PcpState";
    private int tickMillis;
    private PLCState plcState = PLCState.ALIVE;
    private final PcpSwitchState[] switchState = new PcpSwitchState[2];
    private final LatchState[] latchState = new LatchState[3];
    private final ConditionState[] conditionState = new ConditionState[2];
    private final int[] tempLimit = new int[2];
    private final PcpHeaterState[] heaterState = new PcpHeaterState[3];
    private final double[] heaterPower = new double[3];
    private static final long serialVersionUID = 2009439736778543360L;

    public PcpSysState() {
        Arrays.fill((Object[])this.switchState, (Object)PcpSwitchState.OFFLINE);
        Arrays.fill((Object[])this.latchState, (Object)LatchState.OFFLINE);
        Arrays.fill((Object[])this.conditionState, (Object)ConditionState.OFF);
        Arrays.fill(this.tempLimit, Integer.MAX_VALUE);
        Arrays.fill((Object[])this.heaterState, (Object)PcpHeaterState.OFFLINE);
    }

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setPlcState(PLCState value) {
        this.plcState = value;
    }

    public PLCState getPlcState() {
        return this.plcState;
    }

    public void setSwitchState(int sw, PcpSwitchState state) {
        this.switchState[sw] = state;
    }

    public PcpSwitchState getSwitchState(int sw) {
        return this.switchState[sw];
    }

    public void setLatch(int latch, LatchState state) {
        this.latchState[latch] = state;
    }

    public LatchState getLatch(int latch) {
        return this.latchState[latch];
    }

    public void setCondition(int cond, ConditionState state) {
        this.conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return this.conditionState[cond];
    }

    public void setLimit(int limit, int value) {
        this.tempLimit[limit] = value;
    }

    public int getLimit(int limit) {
        return this.tempLimit[limit];
    }

    public void setHeaterState(int heater, PcpHeaterState state) {
        this.heaterState[heater] = state;
    }

    public PcpHeaterState getHeaterState(int heater) {
        return this.heaterState[heater];
    }

    public void setHeaterPower(int heater, double value) {
        this.heaterPower[heater] = value;
    }

    public double getHeaterPower(int heater) {
        return this.heaterPower[heater];
    }
}

