/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.refrig.data.HexState;
import org.lsst.ccs.subsystem.refrig.ui.HexControlPanel;
import org.lsst.ccs.subsystem.refrig.ui.jas.CmprOptionalPage;

@Plugin(name="Hex Control Plugin", description="Hex Control Plugin")
public class HexPlugin
extends ConsolePlugin {
    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new CmprOptionalPage("hexType", HexControl.class, "compressorType"));
    }

    public static class HexControl
    extends ControlPanel
    implements StatusMessageListener {
        private HexControlPanel ctrlPanel;

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("HexState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        public JPanel getControlPanel(String agent) {
            this.ctrlPanel = new HexControlPanel(agent);
            return this.ctrlPanel;
        }

        public void initControlPanel() {
            this.ctrlPanel.initPanel();
        }

        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updatePanel((HexState)obj);
        }

        public void disableControlPanel() {
            this.ctrlPanel.disablePanel();
        }

        public StatusMessageListener getListener() {
            return this;
        }
    }
}

