/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.comcamvacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.LatchState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.PLCState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.comcamvacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.VacuumState;

public class VacSysState
implements Serializable {
    public static final String KEY = "ComCamVacuumState";
    public static final int SW_CRYO_TURBO = 0;
    public static final int SW_CRYO_ION_PUMP1 = 1;
    public static final int SW_CRYO_VALVE = 2;
    public static final int SW_CRYOTEL_CRYO = 6;
    public static final int SW_CRYOTEL_COLD1 = 7;
    public static final int SW_CRYOTEL_COLD2 = 8;
    public static final int NUM_SWITCHES = 9;
    public static final int LATCH_CR_VACUUM = 0;
    public static final int LATCH_CR_GATE_NFC = 1;
    public static final int LATCH_CR_GATE_AO = 2;
    public static final int LATCH_CR_PUMP = 3;
    public static final int NUM_LATCHES = 4;
    public static final int COND_CR_FORELINE_VAC = 0;
    public static final int COND_CR_TRB_PUMP_OFF = 1;
    public static final int COND_CR_TRB_PRESS_10 = 2;
    public static final int COND_CR_VACUUM_01 = 3;
    public static final int COND_CR_VACUUM_001 = 4;
    public static final int NUM_CONDITIONS = 5;
    private int tickMillis;
    private VacuumState vacuumState = VacuumState.UNKNOWN;
    private PLCState plcState = PLCState.ALIVE;
    private int switchMask;
    private int conditionMask;
    private final SwitchState[] switchState = new SwitchState[9];
    private final SwitchEnable[] switchEnable = new SwitchEnable[9];
    private final DeviceState[] deviceState = new DeviceState[9];
    private final ConditionState[] conditionState = new ConditionState[5];
    private int latchMask;
    private final LatchState[] latchState = new LatchState[4];
    private static final long serialVersionUID = 2081368367194546251L;

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setVacuumState(VacuumState value) {
        this.vacuumState = value;
    }

    public VacuumState getVacuumState() {
        return this.vacuumState;
    }

    public void setPlcState(PLCState value) {
        this.plcState = value;
    }

    public PLCState getPlcState() {
        return this.plcState;
    }

    public void addSwitch(int sw) {
        this.switchMask |= 1 << sw;
    }

    public boolean hasSwitch(int sw) {
        return (this.switchMask & 1 << sw) != 0;
    }

    public void setSwitchState(int sw, SwitchState state) {
        this.switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return this.switchState[sw];
    }

    public void setSwitchEnable(int sw, SwitchEnable enable) {
        this.switchEnable[sw] = enable;
    }

    public SwitchEnable getSwitchEnable(int sw) {
        return this.switchEnable[sw];
    }

    public void addLatch(int latch) {
        this.latchMask |= 1 << latch;
    }

    public boolean hasLatch(int latch) {
        return (this.latchMask & 1 << latch) != 0;
    }

    public void setLatch(int latch, LatchState state) {
        this.latchState[latch] = state;
    }

    public LatchState getLatch(int latch) {
        return this.latchState[latch];
    }

    public void setDeviceState(int sw, DeviceState state) {
        this.deviceState[sw] = state;
    }

    public DeviceState getDeviceState(int sw) {
        return this.deviceState[sw];
    }

    public void addCondition(int cond) {
        this.conditionMask |= 1 << cond;
    }

    public boolean hasCondition(int cond) {
        return (this.conditionMask & 1 << cond) != 0;
    }

    public void setCondition(int cond, ConditionState state) {
        this.conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return this.conditionState[cond];
    }
}

